# smc
Utility to save code and other files.

## Install
`cargo install smc`

## Usage
### Config file
Create a config file named `smc.toml`.

```toml
[profiles]
[profiles.toto]             # Profile name
paths = ["./"]              # Path to include
files = ["./"]              # Files to include
output = "/tmp"             # Output dir or filename (default: "./${SAVE_DIR}_${TIME}${EXT}") [$TIME: current date and time, $SAVE_DIR: save directory, $EXT: container extension]
hidden = true               # Save also hidden (default: false)
gitignore = true            # Follow gitignore (default: true)
container = "Zip"           # Container [None, Zip, SevenZip, Tar] (default: Zip)
compression = "Bzip2"       # Compression if possible [None, Deflate, Bzip2, Bzip3, Zstd, Gzip, Xz] (default: Deflate)
compression_level = 9       # Compression level if possible 
directory = "."             # Current directory (default: ".")
signatures = ["Sha256"]     # Signatures to generate [Sha256, Sha384, Sha512, Sha3_256, Sha3_384, Sha3_512]
ignore = ["Cargo.*"]        # Files to ignore
whitelist = [".gitignore"]  # Whitelist files
```

### Run
Run smc with the profiles names as arguments: `smc profile_name`.

Several profiles can be set. In this case all the files will be put in the first profile container.

Some command line arguments can be used to change profile.