!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports,require("three")):"function"==typeof define&&define.amd?define(["exports","three"],t):t((e="undefined"!=typeof globalThis?globalThis:e||self).PhotoSphereViewer={},e.THREE)}(this,(function(e,t){
/*!
 * PhotoSphereViewer 5.5.0
 * @copyright 2014-2015 Jérémy Heleine
 * @copyright 2023 Damien "Mistic" Sorel
 * @licence MIT (https://opensource.org/licenses/MIT)
 */
"use strict";var i=Object.defineProperty,s=Object.getOwnPropertyDescriptor,o=Object.getOwnPropertyNames,n=Object.prototype.hasOwnProperty,r=(e,t)=>{for(var s in t)i(e,s,{get:t[s],enumerable:!0})},a=()=>t,h={};r(h,{AbstractAdapter:()=>Bt,AbstractButton:()=>oi,AbstractComponent:()=>ii,AbstractConfigurablePlugin:()=>_i,AbstractPlugin:()=>Ei,CONSTANTS:()=>l,DEFAULTS:()=>Mi,EquirectangularAdapter:()=>ti,PSVError:()=>ne,SYSTEM:()=>Qt,TypedEvent:()=>Ue,VERSION:()=>hs,Viewer:()=>as,events:()=>De,registerButton:()=>Pi,utils:()=>C});var c=a(),l={};r(l,{ACTIONS:()=>_,ANIMATION_MIN_DURATION:()=>p,CAPTURE_EVENTS_CLASS:()=>E,CTRLZOOM_TIMEOUT:()=>g,DBLCLICK_DELAY:()=>v,DEFAULT_TRANSITION:()=>d,EASINGS:()=>O,ICONS:()=>T,IDS:()=>x,INERTIA_WINDOW:()=>f,KEY_CODES:()=>M,LONGTOUCH_DELAY:()=>m,MOVE_THRESHOLD:()=>u,SPHERE_RADIUS:()=>y,TWOFINGERSOVERLAY_DELAY:()=>w,VIEWER_DATA:()=>b});var d=1500,p=500,u=4,v=300,m=500,w=100,g=2e3,f=300,y=10,b="photoSphereViewer",E="psv--capture-event",_=(e=>(e.ROTATE_UP="ROTATE_UP",e.ROTATE_DOWN="ROTATE_DOWN",e.ROTATE_RIGHT="ROTATE_RIGHT",e.ROTATE_LEFT="ROTATE_LEFT",e.ZOOM_IN="ZOOM_IN",e.ZOOM_OUT="ZOOM_OUT",e))(_||{}),x={MENU:"menu",TWO_FINGERS:"twoFingers",CTRL_ZOOM:"ctrlZoom",ERROR:"error",DESCRIPTION:"description"},M={Enter:"Enter",Control:"Control",Escape:"Escape",Space:" ",PageUp:"PageUp",PageDown:"PageDown",ArrowLeft:"ArrowLeft",ArrowUp:"ArrowUp",ArrowRight:"ArrowRight",ArrowDown:"ArrowDown",Delete:"Delete",Plus:"+",Minus:"-"},T={arrow:'<svg xmlns="http://www.w3.org/2000/svg" viewBox="40 40 432 432"><g transform="rotate(0, 256, 256)"><path fill="currentColor" d="M425.23 210.55H227.39a5 5 0 01-3.53-8.53l56.56-56.57a45.5 45.5 0 000-64.28 45.15 45.15 0 00-32.13-13.3 45.15 45.15 0 00-32.14 13.3L41.32 256l174.83 174.83a45.15 45.15 0 0032.14 13.3 45.15 45.15 0 0032.13-13.3 45.5 45.5 0 000-64.28l-56.57-56.57a5 5 0 013.54-8.53h197.84c25.06 0 45.45-20.39 45.45-45.45s-20.4-45.45-45.45-45.45z"/></g>\x3c!-- Created by Flatart from the Noun Project --\x3e</svg>\n',close:'<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><g fill="currentColor" transform=" translate(50, 50) rotate(45)"><rect x="-5" y="-65" width="10" height="130"/><rect x="-65" y="-5" width="130" height="10"/></g></svg>',download:'<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><path fill="currentColor" d="M83.3 35.6h-17V3H32.2v32.6H16.6l33.6 32.7 33-32.7z"/><path fill="currentColor" d="M83.3 64.2v16.3H16.6V64.2H-.1v32.6H100V64.2H83.3z"/>\x3c!--Created by Michael Zenaty from the Noun Project--\x3e</svg>\n',fullscreenIn:'<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><path fill="currentColor" d="M100 40H87.1V18.8h-21V6H100zM100 93.2H66V80.3h21.1v-21H100zM34 93.2H0v-34h12.9v21.1h21zM12.9 40H0V6h34v12.9H12.8z"/>\x3c!--Created by Garrett Knoll from the Noun Project--\x3e</svg>\n',fullscreenOut:'<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><path fill="currentColor" d="M66 7h13v21h21v13H66zM66 60.3h34v12.9H79v21H66zM0 60.3h34v34H21V73.1H0zM21 7h13v34H0V28h21z"/>\x3c!--Created by Garrett Knoll from the Noun Project--\x3e</svg>\n',info:'<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 64 64"><path fill="currentColor" d="M28.3 26.1c-1 2.6-1.9 4.8-2.6 7-2.5 7.4-5 14.7-7.2 22-1.3 4.4.5 7.2 4.3 7.8 1.3.2 2.8.2 4.2-.1 8.2-2 11.9-8.6 15.7-15.2l-2.2 2a18.8 18.8 0 0 1-7.4 5.2 2 2 0 0 1-1.6-.2c-.2-.1 0-1 0-1.4l.8-1.8L41.9 28c.5-1.4.9-3 .7-4.4-.2-2.6-3-4.4-6.3-4.4-8.8.2-15 4.5-19.5 11.8-.2.3-.2.6-.3 1.3 3.7-2.8 6.8-6.1 11.8-6.2z"/><circle fill="currentColor" cx="39.3" cy="9.2" r="8.2"/>\x3c!--Created by Arafat Uddin from the Noun Project--\x3e</svg>\n',menu:'<svg xmlns="http://www.w3.org/2000/svg" viewBox="10 10 80 80"><g fill="currentColor"><circle r="10" cx="20" cy="20"/><circle r="10" cx="50" cy="20"/><circle r="10" cx="80" cy="20"/><circle r="10" cx="20" cy="50"/><circle r="10" cx="50" cy="50"/><circle r="10" cx="80" cy="50"/><circle r="10" cx="20" cy="80"/><circle r="10" cx="50" cy="80"/><circle r="10" cx="80" cy="80"/></g>\x3c!-- Created by Richard Kunák from the Noun Project--\x3e</svg>\n',zoomIn:'<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"><path fill="currentColor" d="M14.043 12.22a7.738 7.738 0 1 0-1.823 1.822l4.985 4.985c.503.504 1.32.504 1.822 0a1.285 1.285 0 0 0 0-1.822l-4.984-4.985zm-6.305 1.043a5.527 5.527 0 1 1 0-11.053 5.527 5.527 0 0 1 0 11.053z"/><path fill="currentColor" d="M8.728 4.009H6.744v2.737H4.006V8.73h2.738v2.736h1.984V8.73h2.737V6.746H8.728z"/>\x3c!--Created by Ryan Canning from the Noun Project--\x3e</svg>\n',zoomOut:'<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"><path fill="currentColor" d="M14.043 12.22a7.738 7.738 0 1 0-1.823 1.822l4.985 4.985c.503.504 1.32.504 1.822 0a1.285 1.285 0 0 0 0-1.822l-4.984-4.985zm-6.305 1.043a5.527 5.527 0 1 1 0-11.053 5.527 5.527 0 0 1 0 11.053z"/><path fill="currentColor" d="M4.006 6.746h7.459V8.73H4.006z"/>\x3c!--Created by Ryan Canning from the Noun Project--\x3e</svg>\n'},O={linear:e=>e,inQuad:e=>e*e,outQuad:e=>e*(2-e),inOutQuad:e=>e<.5?2*e*e:(4-2*e)*e-1,inCubic:e=>e*e*e,outCubic:e=>--e*e*e+1,inOutCubic:e=>e<.5?4*e*e*e:(e-1)*(2*e-2)*(2*e-2)+1,inQuart:e=>e*e*e*e,outQuart:e=>1- --e*e*e*e,inOutQuart:e=>e<.5?8*e*e*e*e:1-8*--e*e*e*e,inQuint:e=>e*e*e*e*e,outQuint:e=>1+--e*e*e*e*e,inOutQuint:e=>e<.5?16*e*e*e*e*e:1+16*--e*e*e*e*e,inSine:e=>1-Math.cos(e*(Math.PI/2)),outSine:e=>Math.sin(e*(Math.PI/2)),inOutSine:e=>.5-.5*Math.cos(Math.PI*e),inExpo:e=>Math.pow(2,10*(e-1)),outExpo:e=>1-Math.pow(2,-10*e),inOutExpo:e=>(e=2*e-1)<0?.5*Math.pow(2,10*e):1-.5*Math.pow(2,-10*e),inCirc:e=>1-Math.sqrt(1-e*e),outCirc:e=>Math.sqrt(1-(e-1)*(e-1)),inOutCirc:e=>(e*=2)<1?.5-.5*Math.sqrt(1-e*e):.5+.5*Math.sqrt(1-(e-=2)*e)},C={};function L(e,t){let i=e%t;return i<0&&(i+=t),i}function I(e){return e.reduce(((e,t)=>e+t),0)}function k(e,t){return Math.sqrt(Math.pow(e.x-t.x,2)+Math.pow(e.y-t.y,2))}function P(e,t){return Math.atan2(t.y-e.y,t.x-e.x)}function S(e,t){return[0,2*Math.PI,2*-Math.PI].reduce(((i,s)=>{const o=t-e+s;return Math.abs(o)<Math.abs(i)?o:i}),1/0)}function H(e,t){return Math.acos(Math.cos(e.pitch)*Math.cos(t.pitch)*Math.cos(e.yaw-t.yaw)+Math.sin(e.pitch)*Math.sin(t.pitch))}function R([e,t],[i,s]){e-i>Math.PI?e-=2*Math.PI:e-i<-Math.PI&&(e+=2*Math.PI);const o=(i-e)*Math.cos((t+s)/2),n=s-t;return Math.sqrt(o*o+n*n)}function z(e){return"string"==typeof e?e.match(/^[a-z]/i)?document.getElementById(e):document.querySelector(e):e}function A(e,t,i){void 0===i?e.classList.toggle(t):i?e.classList.add(t):i||e.classList.remove(t)}function D(e,t){e.classList.add(...t.split(" "))}function U(e,t){e.classList.remove(...t.split(" "))}function N(e,t){let i=e;do{if(i===t)return!0;i=i.parentElement}while(i);return!1}function V(e,t){if(!e?.matches)return null;let i=e;do{if(i.matches(t))return i;i=i.parentElement}while(i);return null}function F(e){let t=0,i=0,s=e;for(;s;)t+=s.offsetLeft-s.scrollLeft+s.clientLeft,i+=s.offsetTop-s.scrollTop+s.clientTop,s=s.offsetParent;return{x:t,y:i}}function W(e,t){return window.getComputedStyle(e,null)[t]}function j(e,t){return window.getComputedStyle(e).getPropertyValue(t)}function Y(e){if(e.touches.length<2)return null;const t={x:e.touches[0].clientX,y:e.touches[0].clientY},i={x:e.touches[1].clientX,y:e.touches[1].clientY};return{distance:k(t,i),angle:P(t,i),center:{x:(t.x+i.x)/2,y:(t.y+i.y)/2}}}function X(e){return(document.fullscreenElement||document.webkitFullscreenElement)===e}function $(e){(e.requestFullscreen||e.webkitRequestFullscreen).call(e)}function Z(){(document.exitFullscreen||document.webkitExitFullscreen).call(document)}function B(e){return e.replace(/[A-Z](?:(?=[^A-Z])|[A-Z]*(?=[A-Z][^A-Z]|$))/g,((e,t)=>(t>0?"-":"")+e.toLowerCase()))}function G(e,t){let i=!1;return function(...s){i||(i=!0,setTimeout((()=>{e.apply(this,s),i=!1}),t))}}function q(e){if("object"!=typeof e||null===e||"[object Object]"!==Object.prototype.toString.call(e))return!1;if(null===Object.getPrototypeOf(e))return!0;let t=e;for(;null!==Object.getPrototypeOf(t);)t=Object.getPrototypeOf(t);return Object.getPrototypeOf(e)===t}function K(e,t){const i=t;return function e(t,s){return Array.isArray(s)?(t&&Array.isArray(t)?t.length=0:t=[],s.forEach(((i,s)=>{t[s]=e(null,i)}))):"object"==typeof s?(t&&!Array.isArray(t)||(t={}),Object.keys(s).forEach((o=>{"object"==typeof s[o]&&s[o]&&q(s[o])?s[o]!==i&&(t[o]?e(t[o],s[o]):t[o]=e(null,s[o])):t[o]=s[o]}))):t=s,t}(e,t)}function Q(e){return K(null,e)}function J(e){return!e||0===Object.keys(e).length&&e.constructor===Object}function ee(e){return null==e}function te(...e){for(const t of e)if(!ee(t))return t;return null}function ie(e,t){if(e===t)return!0;if(se(e)&&se(t)){if(Object.keys(e).length!==Object.keys(t).length)return!1;for(const i of Object.keys(e))if(!ie(e[i],t[i]))return!1;return!0}return!1}function se(e){return"object"==typeof e&&null!==e}r(C,{Animation:()=>ke,Dynamic:()=>Se,MultiDynamic:()=>He,PressHandler:()=>Re,Slider:()=>Ae,SliderDirection:()=>ze,addClasses:()=>D,angle:()=>P,applyEulerInverse:()=>Oe,checkStylesheet:()=>Le,checkVersion:()=>Ie,cleanCssPosition:()=>ye,clone:()=>Q,createTexture:()=>Me,cssPositionIsOrdered:()=>be,dasherize:()=>B,deepEqual:()=>ie,deepmerge:()=>K,distance:()=>k,exitFullscreen:()=>Z,firstNonNull:()=>te,getAbortError:()=>he,getAngle:()=>H,getClosest:()=>V,getConfigParser:()=>Ce,getElement:()=>z,getPosition:()=>F,getShortestArc:()=>S,getStyle:()=>W,getStyleProperty:()=>j,getTouchData:()=>Y,getXMPValue:()=>pe,greatArcDistance:()=>R,hasParent:()=>N,invertResolvableBoolean:()=>ae,isAbortError:()=>ce,isEmpty:()=>J,isExtendedPosition:()=>de,isFullscreenEnabled:()=>X,isNil:()=>ee,isPlainObject:()=>q,logWarn:()=>le,parseAngle:()=>xe,parsePoint:()=>fe,parseSpeed:()=>Ee,removeClasses:()=>U,requestFullscreen:()=>$,resolveBoolean:()=>re,speedToDuration:()=>_e,sum:()=>I,throttle:()=>G,toggleClass:()=>A,wrap:()=>L});var oe=a(),ne=class e extends Error{constructor(t){super(t),this.name="PSVError",Error.captureStackTrace?.(this,e)}};function re(e,t){q(e)?(t(e.initial,!0),e.promise.then((e=>t(e,!1)))):t(e,!0)}function ae(e){return{initial:!e.initial,promise:e.promise.then((e=>!e))}}function he(){const e=new Error("Loading was aborted.");return e.name="AbortError",e}function ce(e){return"AbortError"===e?.name}function le(e){console.warn(`PhotoSphereViewer: ${e}`)}function de(e){return!!e&&[["textureX","textureY"],["yaw","pitch"]].some((([t,i])=>void 0!==e[t]&&void 0!==e[i]))}function pe(e,t){let i=e.match("<GPano:"+t+">(.*)</GPano:"+t+">");if(null!==i){const e=parseInt(i[1],10);return isNaN(e)?null:e}if(i=e.match("GPano:"+t+'="(.*?)"'),null!==i){const e=parseInt(i[1],10);return isNaN(e)?null:e}return null}var ue={top:"0%",bottom:"100%",left:"0%",right:"100%",center:"50%"},ve=["left","center","right"],me=["top","center","bottom"],we=[...ve,...me],ge="center";function fe(e){if(!e)return{x:.5,y:.5};if("object"==typeof e)return e;let t=e.toLocaleLowerCase().split(" ").slice(0,2);1===t.length&&(t=ue[t[0]]?[t[0],ge]:[t[0],t[0]]);const i="left"!==t[1]&&"right"!==t[1]&&"top"!==t[0]&&"bottom"!==t[0];t=t.map((e=>ue[e]||e)),i||t.reverse();const s=t.join(" ").match(/^([0-9.]+)% ([0-9.]+)%$/);return s?{x:parseFloat(s[1])/100,y:parseFloat(s[2])/100}:{x:.5,y:.5}}function ye(e,{allowCenter:t,cssOrder:i}={allowCenter:!0,cssOrder:!0}){return e?("string"==typeof e&&(e=e.split(" ")),1===e.length&&(e[0]===ge?e=[ge,ge]:-1!==ve.indexOf(e[0])?e=[ge,e[0]]:-1!==me.indexOf(e[0])&&(e=[e[0],ge])),2!==e.length||-1===we.indexOf(e[0])||-1===we.indexOf(e[1])?(le(`Unparsable position ${e}`),null):t||e[0]!==ge||e[1]!==ge?(i&&!be(e)&&(e=[e[1],e[0]]),e[1]===ge&&-1!==ve.indexOf(e[0])&&(e=[ge,e[0]]),e[0]===ge&&-1!==me.indexOf(e[1])&&(e=[e[1],ge]),e):(le("Invalid position center center"),null)):null}function be(e){return-1!==me.indexOf(e[0])&&-1!==ve.indexOf(e[1])}function Ee(e){let t;if("string"==typeof e){const i=e.toString().trim();let s=parseFloat(i.replace(/^(-?[0-9]+(?:\.[0-9]*)?).*$/,"$1"));const o=i.replace(/^-?[0-9]+(?:\.[0-9]*)?(.*)$/,"$1").trim();switch(o.match(/(pm|per minute)$/)&&(s/=60),o){case"dpm":case"degrees per minute":case"dps":case"degrees per second":t=oe.MathUtils.degToRad(s);break;case"rdpm":case"radians per minute":case"rdps":case"radians per second":t=s;break;case"rpm":case"revolutions per minute":case"rps":case"revolutions per second":t=s*Math.PI*2;break;default:throw new ne(`Unknown speed unit "${o}"`)}}else t=e;return t}function _e(e,t){if("number"!=typeof e){const i=Ee(e);return t/Math.abs(i)*1e3}return Math.abs(e)}function xe(e,t=!1,i=t){let s;if("string"==typeof e){const t=e.toLowerCase().trim().match(/^(-?[0-9]+(?:\.[0-9]*)?)(.*)$/);if(!t)throw new ne(`Unknown angle "${e}"`);const i=parseFloat(t[1]),o=t[2];if(o)switch(o){case"deg":case"degs":s=oe.MathUtils.degToRad(i);break;case"rad":case"rads":s=i;break;default:throw new ne(`Unknown angle unit "${o}"`)}else s=i}else{if("number"!=typeof e||isNaN(e))throw new ne(`Unknown angle "${e}"`);s=e}return s=L(t?s+Math.PI:s,2*Math.PI),t?oe.MathUtils.clamp(s-Math.PI,-Math.PI/(i?2:1),Math.PI/(i?2:1)):s}function Me(e,t=!1){const i=new oe.Texture(e);return i.needsUpdate=!0,i.minFilter=t?oe.LinearMipmapLinearFilter:oe.LinearFilter,i.generateMipmaps=t,i.anisotropy=t?2:1,i}var Te=new oe.Quaternion;function Oe(e,t){Te.setFromEuler(t).invert(),e.applyQuaternion(Te)}function Ce(e,t){const i=function(i){if(!i)return Q(e);const s=Q({...e,...i}),o={};for(let[i,n]of Object.entries(s)){if(t&&i in t)n=t[i](n,{rawConfig:s,defValue:e[i]});else if(!(i in e)){le(`Unknown option ${i}`);continue}o[i]=n}return o};return i.defaults=e,i.parsers=t||{},i}function Le(e,t){"true"!==j(e,`--psv-${t}-loaded`)&&console.error(`PhotoSphereViewer: stylesheet "@photo-sphere-viewer/${t}/index.css" is not loaded`)}function Ie(e,t,i){t&&t!==i&&console.error(`PhotoSphereViewer: @photo-sphere-viewer/${e} is in version ${t} but @photo-sphere-viewer/core is in version ${i}`)}var ke=class{constructor(e){this.easing=O.linear,this.callbacks=[],this.resolved=!1,this.cancelled=!1,this.options=e,e?(e.easing&&(this.easing="function"==typeof e.easing?e.easing:O[e.easing]||O.linear),this.delayTimeout=setTimeout((()=>{this.delayTimeout=void 0,this.animationFrame=window.requestAnimationFrame((e=>this.__run(e)))}),e.delay||0)):this.resolved=!0}__run(e){if(this.cancelled)return;this.start||(this.start=e);const t=(e-this.start)/this.options.duration,i={};if(t<1){for(const[e,s]of Object.entries(this.options.properties))if(s){const o=s.start+(s.end-s.start)*this.easing(t);i[e]=o}this.options.onTick(i,t),this.animationFrame=window.requestAnimationFrame((e=>this.__run(e)))}else{for(const[e,t]of Object.entries(this.options.properties))t&&(i[e]=t.end);this.options.onTick(i,1),this.__resolve(!0),this.animationFrame=void 0}}__resolve(e){e?this.resolved=!0:this.cancelled=!0,this.callbacks.forEach((t=>t(e))),this.callbacks.length=0}then(e){return this.resolved||this.cancelled?Promise.resolve(this.resolved).then(e):new Promise((e=>{this.callbacks.push(e)})).then(e)}cancel(){this.cancelled||this.resolved||(this.__resolve(!1),this.delayTimeout&&(window.clearTimeout(this.delayTimeout),this.delayTimeout=void 0),this.animationFrame&&(window.cancelAnimationFrame(this.animationFrame),this.animationFrame=void 0))}},Pe=a(),Se=class{constructor(e,t){if(this.fn=e,this.mode=0,this.speed=0,this.speedMult=0,this.currentSpeed=0,this.target=0,this.__current=0,this.min=t.min,this.max=t.max,this.wrap=t.wrap,this.current=t.defaultValue,this.wrap&&0!==this.min)throw new ne("invalid config");this.fn&&this.fn(this.current)}get current(){return this.__current}set current(e){this.__current=e}setSpeed(e){this.speed=e}goto(e,t=1){this.mode=2,this.target=this.wrap?L(e,this.max):Pe.MathUtils.clamp(e,this.min,this.max),this.speedMult=t}step(e,t=1){0===t?this.setValue(this.current+e):(2!==this.mode&&(this.target=this.current),this.goto(this.target+e,t))}roll(e=!1,t=1){this.mode=1,this.target=e?-1/0:1/0,this.speedMult=t}stop(){this.mode=0}setValue(e){return this.target=this.wrap?L(e,this.max):Pe.MathUtils.clamp(e,this.min,this.max),this.mode=0,this.currentSpeed=0,this.target!==this.current&&(this.current=this.target,this.fn&&this.fn(this.current),!0)}update(e){if(2===this.mode){this.wrap&&Math.abs(this.target-this.current)>this.max/2&&(this.current=this.current<this.target?this.current+this.max:this.current-this.max);const e=this.currentSpeed*this.currentSpeed/(this.speed*this.speedMult*4);Math.abs(this.target-this.current)<=e&&(this.mode=0)}let t=0===this.mode?0:this.speed*this.speedMult;this.target<this.current&&(t=-t),this.currentSpeed<t?this.currentSpeed=Math.min(t,this.currentSpeed+e/1e3*this.speed*this.speedMult*2):this.currentSpeed>t&&(this.currentSpeed=Math.max(t,this.currentSpeed-e/1e3*this.speed*this.speedMult*2));let i=null;return this.current>this.target&&this.currentSpeed?i=Math.max(this.target,this.current+this.currentSpeed*e/1e3):this.current<this.target&&this.currentSpeed&&(i=Math.min(this.target,this.current+this.currentSpeed*e/1e3)),null!==i&&(i=this.wrap?L(i,this.max):Pe.MathUtils.clamp(i,this.min,this.max),i!==this.current)&&(this.current=i,this.fn&&this.fn(this.current),!0)}},He=class{constructor(e,t){this.fn=e,this.dynamics=t,this.fn&&this.fn(this.current)}get current(){return Object.entries(this.dynamics).reduce(((e,[t,i])=>(e[t]=i.current,e)),{})}setSpeed(e){for(const t of Object.values(this.dynamics))t.setSpeed(e)}goto(e,t=1){for(const[i,s]of Object.entries(e))this.dynamics[i].goto(s,t)}step(e,t=1){if(0===t)this.setValue(Object.keys(e).reduce(((t,i)=>(t[i]=e[i]+this.dynamics[i].current,t)),{}));else for(const[i,s]of Object.entries(e))this.dynamics[i].step(s,t)}roll(e,t=1){for(const[i,s]of Object.entries(e))this.dynamics[i].roll(s,t)}stop(){for(const e of Object.values(this.dynamics))e.stop()}setValue(e){let t=!1;for(const[i,s]of Object.entries(e))t=this.dynamics[i].setValue(s)||t;return t&&this.fn&&this.fn(this.current),t}update(e){let t=!1;for(const i of Object.values(this.dynamics))t=i.update(e)||t;return t&&this.fn&&this.fn(this.current),t}},Re=class{constructor(e=200){this.delay=e,this.time=0,this.delay=e}get pending(){return 0!==this.time}down(){this.timeout&&(clearTimeout(this.timeout),this.timeout=void 0),this.time=(new Date).getTime()}up(e){if(!this.time)return;Date.now()-this.time<this.delay?this.timeout=setTimeout((()=>{e(),this.timeout=void 0,this.time=0}),this.delay):(e(),this.time=0)}},ze=(e=>(e.VERTICAL="VERTICAL",e.HORIZONTAL="HORIZONTAL",e))(ze||{}),Ae=class{constructor(e,t,i){this.container=e,this.direction=t,this.listener=i,this.mousedown=!1,this.mouseover=!1,this.container.addEventListener("click",this),this.container.addEventListener("mousedown",this),this.container.addEventListener("mouseenter",this),this.container.addEventListener("mouseleave",this),this.container.addEventListener("touchstart",this),this.container.addEventListener("mousemove",this,!0),this.container.addEventListener("touchmove",this,!0),window.addEventListener("mouseup",this),window.addEventListener("touchend",this)}get isVertical(){return"VERTICAL"===this.direction}get isHorizontal(){return"HORIZONTAL"===this.direction}destroy(){window.removeEventListener("mouseup",this),window.removeEventListener("touchend",this)}handleEvent(e){switch(e.type){case"click":e.stopPropagation();break;case"mousedown":this.__onMouseDown(e);break;case"mouseenter":this.__onMouseEnter(e);break;case"mouseleave":this.__onMouseLeave(e);break;case"touchstart":this.__onTouchStart(e);break;case"mousemove":this.__onMouseMove(e);break;case"touchmove":this.__onTouchMove(e);break;case"mouseup":this.__onMouseUp(e);break;case"touchend":this.__onTouchEnd(e)}}__onMouseDown(e){this.mousedown=!0,this.__update(e.clientX,e.clientY,!0)}__onMouseEnter(e){this.mouseover=!0,this.__update(e.clientX,e.clientY,!0)}__onTouchStart(e){this.mouseover=!0,this.mousedown=!0;const t=e.changedTouches[0];this.__update(t.clientX,t.clientY,!0)}__onMouseMove(e){(this.mousedown||this.mouseover)&&(e.stopPropagation(),this.__update(e.clientX,e.clientY,!0))}__onTouchMove(e){if(this.mousedown||this.mouseover){e.stopPropagation();const t=e.changedTouches[0];this.__update(t.clientX,t.clientY,!0)}}__onMouseUp(e){this.mousedown&&(this.mousedown=!1,this.__update(e.clientX,e.clientY,!1))}__onMouseLeave(e){this.mouseover&&(this.mouseover=!1,this.__update(e.clientX,e.clientY,!0))}__onTouchEnd(e){if(this.mousedown){this.mouseover=!1,this.mousedown=!1;const t=e.changedTouches[0];this.__update(t.clientX,t.clientY,!1)}}__update(e,t,i){const s=this.container.getBoundingClientRect(),o=this.isVertical?t:e,n=s[this.isVertical?"bottom":"left"],r=s[this.isVertical?"height":"width"],a=Math.abs((n-o)/r);this.listener({value:a,click:!i,mousedown:this.mousedown,mouseover:this.mouseover,cursor:{clientX:e,clientY:t}})}},De={};r(De,{BeforeAnimateEvent:()=>We,BeforeRenderEvent:()=>Ye,BeforeRotateEvent:()=>$e,ClickEvent:()=>Be,ConfigChangedEvent:()=>qe,DoubleClickEvent:()=>Qe,FullscreenEvent:()=>et,HideNotificationEvent:()=>it,HideOverlayEvent:()=>ot,HidePanelEvent:()=>rt,HideTooltipEvent:()=>ht,KeypressEvent:()=>lt,LoadProgressEvent:()=>pt,ObjectEnterEvent:()=>Ft,ObjectEvent:()=>Nt,ObjectHoverEvent:()=>Xt,ObjectLeaveEvent:()=>jt,PanoramaErrorEvent:()=>ft,PanoramaLoadEvent:()=>vt,PanoramaLoadedEvent:()=>wt,PositionUpdatedEvent:()=>bt,ReadyEvent:()=>_t,RenderEvent:()=>Mt,ShowNotificationEvent:()=>Ot,ShowOverlayEvent:()=>Lt,ShowPanelEvent:()=>kt,ShowTooltipEvent:()=>St,SizeUpdatedEvent:()=>Rt,StopAllEvent:()=>At,ViewerEvent:()=>Ve,ZoomUpdatedEvent:()=>Ut});var Ue=class extends Event{constructor(e,t=!1){super(e,{cancelable:t})}},Ne=class extends EventTarget{dispatchEvent(e){return super.dispatchEvent(e)}addEventListener(e,t,i){super.addEventListener(e,t,i)}removeEventListener(e,t,i){super.removeEventListener(e,t,i)}},Ve=class extends Ue{},Fe=class e extends Ve{constructor(t,i){super(e.type,!0),this.position=t,this.zoomLevel=i}};Fe.type="before-animate";var We=Fe,je=class e extends Ve{constructor(t,i){super(e.type),this.timestamp=t,this.elapsed=i}};je.type="before-render";var Ye=je,Xe=class e extends Ve{constructor(t){super(e.type,!0),this.position=t}};Xe.type="before-rotate";var $e=Xe,Ze=class e extends Ve{constructor(t){super(e.type),this.data=t}};Ze.type="click";var Be=Ze,Ge=class e extends Ve{constructor(t){super(e.type),this.options=t}containsOptions(...e){return e.some((e=>this.options.includes(e)))}};Ge.type="config-changed";var qe=Ge,Ke=class e extends Ve{constructor(t){super(e.type),this.data=t}};Ke.type="dblclick";var Qe=Ke,Je=class e extends Ve{constructor(t){super(e.type),this.fullscreenEnabled=t}};Je.type="fullscreen";var et=Je,tt=class e extends Ve{constructor(t){super(e.type),this.notificationId=t}};tt.type="hide-notification";var it=tt,st=class e extends Ve{constructor(t){super(e.type),this.overlayId=t}};st.type="hide-overlay";var ot=st,nt=class e extends Ve{constructor(t){super(e.type),this.panelId=t}};nt.type="hide-panel";var rt=nt,at=class e extends Ve{constructor(t){super(e.type),this.tooltipData=t}};at.type="hide-tooltip";var ht=at,ct=class e extends Ve{constructor(t){super(e.type,!0),this.key=t}};ct.type="key-press";var lt=ct,dt=class e extends Ve{constructor(t){super(e.type),this.progress=t}};dt.type="load-progress";var pt=dt,ut=class e extends Ve{constructor(t){super(e.type),this.panorama=t}};ut.type="panorama-load";var vt=ut,mt=class e extends Ve{constructor(t){super(e.type),this.data=t}};mt.type="panorama-loaded";var wt=mt,gt=class e extends Ve{constructor(t,i){super(e.type),this.panorama=t,this.error=i}};gt.type="panorama-error";var ft=gt,yt=class e extends Ve{constructor(t){super(e.type),this.position=t}};yt.type="position-updated";var bt=yt,Et=class e extends Ve{constructor(){super(e.type)}};Et.type="ready";var _t=Et,xt=class e extends Ve{constructor(){super(e.type)}};xt.type="render";var Mt=xt,Tt=class e extends Ve{constructor(t){super(e.type),this.notificationId=t}};Tt.type="show-notification";var Ot=Tt,Ct=class e extends Ve{constructor(t){super(e.type),this.overlayId=t}};Ct.type="show-overlay";var Lt=Ct,It=class e extends Ve{constructor(t){super(e.type),this.panelId=t}};It.type="show-panel";var kt=It,Pt=class e extends Ve{constructor(t,i){super(e.type),this.tooltip=t,this.tooltipData=i}};Pt.type="show-tooltip";var St=Pt,Ht=class e extends Ve{constructor(t){super(e.type),this.size=t}};Ht.type="size-updated";var Rt=Ht,zt=class e extends Ve{constructor(){super(e.type)}};zt.type="stop-all";var At=zt,Dt=class e extends Ve{constructor(t){super(e.type),this.zoomLevel=t}};Dt.type="zoom-updated";var Ut=Dt,Nt=class extends Ve{constructor(e,t,i,s,o){super(e),this.originalEvent=t,this.object=i,this.viewerPoint=s,this.userDataKey=o}},Vt=class e extends Nt{constructor(t,i,s,o){super(e.type,t,i,s,o)}};Vt.type="enter-object";var Ft=Vt,Wt=class e extends Nt{constructor(t,i,s,o){super(e.type,t,i,s,o)}};Wt.type="leave-object";var jt=Wt,Yt=class e extends Nt{constructor(t,i,s,o){super(e.type,t,i,s,o)}};Yt.type="hover-object";var Xt=Yt,$t=a(),Zt=class e{constructor(e){this.viewer=e}init(){}destroy(){}supportsTransition(e){return!1}supportsPreload(e){return!1}textureCoordsToSphericalCoords(e,t){throw new ne("Current adapter does not support texture coordinates.")}sphericalCoordsToTextureCoords(e,t){throw new ne("Current adapter does not support texture coordinates.")}setOverlay(e,t,i){throw new ne("Current adapter does not support overlay")}static createOverlayMaterial({additionalUniforms:t,overrideVertexShader:i}={}){return new $t.ShaderMaterial({uniforms:{...t,[e.OVERLAY_UNIFORMS.panorama]:{value:null},[e.OVERLAY_UNIFORMS.overlay]:{value:null},[e.OVERLAY_UNIFORMS.globalOpacity]:{value:1},[e.OVERLAY_UNIFORMS.overlayOpacity]:{value:0}},vertexShader:i||"\nvarying vec2 vUv;\n\nvoid main() {\n  vUv = uv;\n  gl_Position = projectionMatrix *  modelViewMatrix * vec4( position, 1.0 );\n}",fragmentShader:`\nuniform sampler2D ${e.OVERLAY_UNIFORMS.panorama};\nuniform sampler2D ${e.OVERLAY_UNIFORMS.overlay};\nuniform float ${e.OVERLAY_UNIFORMS.globalOpacity};\nuniform float ${e.OVERLAY_UNIFORMS.overlayOpacity};\n\nvarying vec2 vUv;\n\nvoid main() {\n  vec4 tColor1 = texture2D( ${e.OVERLAY_UNIFORMS.panorama}, vUv );\n  vec4 tColor2 = texture2D( ${e.OVERLAY_UNIFORMS.overlay}, vUv );\n  gl_FragColor = vec4(\n    mix( tColor1.rgb, tColor2.rgb, tColor2.a * ${e.OVERLAY_UNIFORMS.overlayOpacity} ),\n    ${e.OVERLAY_UNIFORMS.globalOpacity}\n  );\n}`})}};Zt.supportsDownload=!1,Zt.supportsOverlay=!1,Zt.OVERLAY_UNIFORMS={panorama:"panorama",overlay:"overlay",globalOpacity:"globalOpacity",overlayOpacity:"overlayOpacity"};var Bt=Zt;function Gt(e){if(e)for(const[,t]of[["_",e],...Object.entries(e)])if(t.prototype instanceof Bt)return Ie(t.id,t.VERSION,"5.5.0"),t;return null}var qt=a(),Kt=`${b}_touchSupport`,Qt={loaded:!1,pixelRatio:1,isWebGLSupported:!1,maxTextureWidth:0,isTouchEnabled:null,fullscreenEvent:null,__maxCanvasWidth:null,get maxCanvasWidth(){return null===this.__maxCanvasWidth&&(this.__maxCanvasWidth=function(e){const t=document.createElement("canvas"),i=t.getContext("2d");t.width=e,t.height=e/2;for(;t.width>1024;){i.fillStyle="white",i.fillRect(0,0,1,1);try{if(i.getImageData(0,0,1,1).data[0]>0)return t.width}catch(e){}t.width/=2,t.height/=2}throw new ne("Unable to detect system capabilities")}(this.maxTextureWidth)),this.__maxCanvasWidth},load(){if(!this.loaded){const e=function(){const e=document.createElement("canvas"),t=["webgl2","webgl","experimental-webgl","moz-webgl","webkit-3d"];let i=null;if(!e.getContext)return null;return t.some((t=>{try{return i=e.getContext(t),null!==i}catch(e){return!1}}))?i:null}();this.pixelRatio=window.devicePixelRatio||1,this.isWebGLSupported=null!==e,this.maxTextureWidth=e?e.getParameter(e.MAX_TEXTURE_SIZE):0,this.isTouchEnabled=function(){let e="ontouchstart"in window||navigator.maxTouchPoints>0;Kt in localStorage&&(e="true"===localStorage[Kt]);const t=new Promise((t=>{const i=()=>{window.removeEventListener("mousedown",s),window.removeEventListener("touchstart",o),clearTimeout(r)},s=()=>{i(),localStorage[Kt]=!1,t(!1)},o=()=>{i(),localStorage[Kt]=!0,t(!0)},n=()=>{i(),localStorage[Kt]=e,t(e)};window.addEventListener("mousedown",s,!1),window.addEventListener("touchstart",o,!1);const r=setTimeout(n,1e4)}));return{initial:e,promise:t}}(),this.fullscreenEvent=function(){if("exitFullscreen"in document)return"fullscreenchange";if("webkitExitFullscreen"in document)return"webkitfullscreenchange";return null}(),this.loaded=!0}if(!Qt.isWebGLSupported)throw new ne("WebGL is not supported.");if(0===Qt.maxTextureWidth)throw new ne("Unable to detect system capabilities")}};var Jt=URL.createObjectURL(new Blob(["(",function(){function e(e){return`rgb(${e.r}, ${e.g}, ${e.b})`}function t(e,t){return{r:Math.round(e.r/2+t.r/2),g:Math.round(e.g/2+t.g/2),b:Math.round(e.b/2+t.b/2)}}function i(t,i,s,o,n){const r=t.createLinearGradient(i,0,s,0);return r.addColorStop(0,e(o)),r.addColorStop(1,e(n)),r}function s(e,t,i,s,o,n){n=Math.round(n);let r=0,a=0,h=0,c=0;const l=e.getImageData(t,i,s,o);for(let e=0;e<o;e+=n)for(let t=0;t<s;t+=n){const i=4*(e*s+t);r+=l.data[i],a+=l.data[i+1],h+=l.data[i+2],c++}return r=Math.round(r/c),a=Math.round(a/c),h=Math.round(h/c),{r:r,g:a,b:h}}self.onmessage=o=>{const n=o.data.panoData,r=new OffscreenCanvas(n.fullWidth,n.fullHeight),a=r.getContext("2d"),h=new OffscreenCanvas(n.croppedWidth,n.croppedHeight);h.getContext("2d").putImageData(o.data.image,0,0),function(o,n,r){const a=r.fullHeight-r.croppedHeight-r.croppedY,h=r.fullWidth-r.croppedWidth-r.croppedX,c=r.croppedY+r.croppedHeight/2,l=o.width/32,d=l,p=10,u=`blur(${l}px)`,v=o.getContext("2d");if(v.drawImage(n,r.croppedX,r.croppedY,r.croppedWidth,r.croppedHeight),r.croppedY>0){if(r.croppedX>0||h>0){v.filter="none";const e=s(v,r.croppedX,r.croppedY,p,p,2),n=s(v,o.width-h-11,r.croppedY,p,p,2),a=t(e,n);r.croppedX>0&&(v.fillStyle=i(v,0,r.croppedX,a,e),v.fillRect(-d,-d,r.croppedX+2*d,c+d)),h>0&&(v.fillStyle=i(v,o.width-h,o.width,n,a),v.fillRect(o.width-h-d,-d,h+2*d,c+d))}v.filter=u,v.drawImage(n,0,0,n.width,p,r.croppedX,-d,r.croppedWidth,r.croppedY+2*d),v.fillStyle=e(s(v,0,0,o.width,p,p)),v.fillRect(-d,-d,o.width+2*d,2*d)}if(a>0){if(r.croppedX>0||h>0){v.filter="none";const e=s(v,r.croppedX,o.height-a-1-p,p,p,2),n=s(v,o.width-h-1-p,o.height-a-1-p,p,p,2),l=t(e,n);r.croppedX>0&&(v.fillStyle=i(v,0,r.croppedX,l,e),v.fillRect(-d,c,r.croppedX+2*d,o.height-c+d)),h>0&&(v.fillStyle=i(v,o.width-h,o.width,n,l),v.fillRect(o.width-h-d,c,h+2*d,o.height-c+d))}v.filter=u,v.drawImage(n,0,n.height-p,n.width,p,r.croppedX,o.height-a-d,r.croppedWidth,a+2*d),v.fillStyle=e(s(v,0,o.height-1-p,o.width,p,p)),v.fillRect(-d,o.height-d,o.width+2*d,2*d)}r.croppedX>0&&(v.filter=u,v.drawImage(n,n.width-p,0,p,n.height,-d,r.croppedY,2*d,r.croppedHeight),v.drawImage(n,0,0,p,n.height,0,r.croppedY,r.croppedX+d,r.croppedHeight));h>0&&(v.filter=u,v.drawImage(n,0,0,p,n.height,o.width-d,r.croppedY,2*d,r.croppedHeight),v.drawImage(n,n.width-p,0,p,n.height,o.width-h-d,r.croppedY,h+d,r.croppedHeight));v.filter="none",v.drawImage(n,r.croppedX,r.croppedY,r.croppedWidth,r.croppedHeight)}(r,h,n),postMessage(a.getImageData(0,0,r.width,r.height))}}.toString(),")()"],{type:"application/javascript"})),ei=Ce({backgroundColor:"#000",interpolateBackground:!1,resolution:64,useXmpData:!0,blur:!1},{resolution:e=>{if(!e||!qt.MathUtils.isPowerOfTwo(e))throw new ne("EquirectangularAdapter resolution must be power of two");return e}}),ti=class extends Bt{constructor(e,t){super(e),this.config=ei(t),ee(this.viewer.config.useXmpData)||(this.config.useXmpData=this.viewer.config.useXmpData),ee(this.viewer.config.canvasBackground)||(this.config.backgroundColor=this.viewer.config.canvasBackground),this.config.interpolateBackground&&(window.Worker?this.interpolationWorker=new Worker(Jt):(le("Web Worker API not available"),this.config.interpolateBackground=!1)),this.SPHERE_SEGMENTS=this.config.resolution,this.SPHERE_HORIZONTAL_SEGMENTS=this.SPHERE_SEGMENTS/2}supportsTransition(){return!0}supportsPreload(){return!0}destroy(){this.interpolationWorker?.terminate(),super.destroy()}textureCoordsToSphericalCoords(e,t){if(ee(e.textureX)||ee(e.textureY))throw new ne("Texture position is missing 'textureX' or 'textureY'");const i=(e.textureX+t.croppedX)/t.fullWidth*Math.PI*2,s=(e.textureY+t.croppedY)/t.fullHeight*Math.PI;return{yaw:i>=Math.PI?i-Math.PI:i+Math.PI,pitch:Math.PI/2-s}}sphericalCoordsToTextureCoords(e,t){const i=e.yaw/Math.PI/2*t.fullWidth,s=e.pitch/Math.PI*t.fullHeight;return{textureX:Math.round(e.yaw<Math.PI?i+t.fullWidth/2:i-t.fullWidth/2)-t.croppedX,textureY:Math.round(t.fullHeight/2-s)-t.croppedY}}async loadTexture(e,t,i=!0,s=this.config.useXmpData){if("string"!=typeof e)return Promise.reject(new ne("Invalid panorama url, are you using the right adapter?"));const o=await this.viewer.textureLoader.loadFile(e,i?e=>this.viewer.loader.setProgress(e):null,e),n=s?await this.loadXMP(o):null,r=await this.viewer.textureLoader.blobToImage(o);"function"==typeof t&&(t=t(r,n)),t||n||(t=this.__defaultPanoData(r));const a={isEquirectangular:!0,fullWidth:te(t?.fullWidth,n?.fullWidth,r.width),fullHeight:te(t?.fullHeight,n?.fullHeight,r.height),croppedWidth:te(t?.croppedWidth,n?.croppedWidth,r.width),croppedHeight:te(t?.croppedHeight,n?.croppedHeight,r.height),croppedX:te(t?.croppedX,n?.croppedX,0),croppedY:te(t?.croppedY,n?.croppedY,0),poseHeading:te(t?.poseHeading,n?.poseHeading,0),posePitch:te(t?.posePitch,n?.posePitch,0),poseRoll:te(t?.poseRoll,n?.poseRoll,0)};a.croppedWidth===r.width&&a.croppedHeight===r.height||le(`Invalid panoData, croppedWidth/croppedHeight is not coherent with the loaded image.\n            panoData: ${a.croppedWidth}x${a.croppedHeight}, image: ${r.width}x${r.height}`),Math.abs(a.fullWidth-2*a.fullHeight)>1&&(le("Invalid panoData, fullWidth should be twice fullHeight"),a.fullWidth=2*a.fullHeight),a.croppedX+a.croppedWidth>a.fullWidth&&(le("Invalid panoData, croppedX + croppedWidth > fullWidth"),a.croppedX=a.fullWidth-a.croppedWidth),a.croppedY+a.croppedHeight>a.fullHeight&&(le("Invalid panoData, croppedY + croppedHeight > fullHeight"),a.croppedY=a.fullHeight-a.croppedHeight);return{panorama:e,texture:this.createEquirectangularTexture(r,a),panoData:a,cacheKey:e}}async loadXMP(e){const t=await this.loadBlobAsString(e),i=t.indexOf("<x:xmpmeta"),s=t.indexOf("</x:xmpmeta>"),o=t.substring(i,s);return-1!==i&&-1!==s&&o.includes("GPano:")?{isEquirectangular:!0,fullWidth:pe(o,"FullPanoWidthPixels"),fullHeight:pe(o,"FullPanoHeightPixels"),croppedWidth:pe(o,"CroppedAreaImageWidthPixels"),croppedHeight:pe(o,"CroppedAreaImageHeightPixels"),croppedX:pe(o,"CroppedAreaLeftPixels"),croppedY:pe(o,"CroppedAreaTopPixels"),poseHeading:pe(o,"PoseHeadingDegrees"),posePitch:pe(o,"PosePitchDegrees"),poseRoll:pe(o,"PoseRollDegrees")}:null}loadBlobAsString(e){return new Promise(((t,i)=>{const s=new FileReader;s.onload=()=>t(s.result),s.onerror=i,s.readAsText(e)}))}createEquirectangularTexture(e,t){if(this.config.blur||t.fullWidth>Qt.maxTextureWidth||t.croppedWidth!==t.fullWidth||t.croppedHeight!==t.fullHeight){const i=Math.min(1,Qt.maxCanvasWidth/t.fullWidth),s={fullWidth:t.fullWidth*i,fullHeight:t.fullHeight*i,croppedWidth:t.croppedWidth*i,croppedHeight:t.croppedHeight*i,croppedX:t.croppedX*i,croppedY:t.croppedY*i},o=document.createElement("canvas");o.width=s.fullWidth,o.height=s.fullHeight;const n=o.getContext("2d");this.config.backgroundColor&&(n.fillStyle=this.config.backgroundColor,n.fillRect(0,0,o.width,o.height)),this.config.blur&&(n.filter=`blur(${o.width/2048}px)`),n.drawImage(e,s.croppedX,s.croppedY,s.croppedWidth,s.croppedHeight);const r=Me(o);return!this.config.interpolateBackground||t.croppedWidth===t.fullWidth&&t.croppedHeight===t.fullHeight||(this.interpolationWorker.postMessage({image:n.getImageData(s.croppedX,s.croppedY,s.croppedWidth,s.croppedHeight),panoData:s}),this.interpolationWorker.onmessage=e=>{n.putImageData(e.data,0,0),r.needsUpdate=!0,this.viewer.needsUpdate()}),r}return Me(e)}createMesh(e=1){const t=new qt.SphereGeometry(y*e,this.SPHERE_SEGMENTS,this.SPHERE_HORIZONTAL_SEGMENTS,-Math.PI/2).scale(-1,1,1),i=Bt.createOverlayMaterial();return new qt.Mesh(t,i)}setTexture(e,t){this.__setUniform(e,Bt.OVERLAY_UNIFORMS.panorama,t.texture)}setOverlay(e,t,i){this.__setUniform(e,Bt.OVERLAY_UNIFORMS.overlayOpacity,i),t?this.__setUniform(e,Bt.OVERLAY_UNIFORMS.overlay,t.texture):this.__setUniform(e,Bt.OVERLAY_UNIFORMS.overlay,null)}setTextureOpacity(e,t){this.__setUniform(e,Bt.OVERLAY_UNIFORMS.globalOpacity,t),e.material.transparent=t<1}disposeTexture(e){e.texture?.dispose()}__setUniform(e,t,i){e.material.uniforms[t].value=i}__defaultPanoData(e){const t=Math.max(e.width,2*e.height),i=Math.round(t/2),s=Math.round((t-e.width)/2),o=Math.round((i-e.height)/2);return{isEquirectangular:!0,fullWidth:t,fullHeight:i,croppedWidth:e.width,croppedHeight:e.height,croppedX:s,croppedY:o}}};ti.id="equirectangular",ti.VERSION="5.5.0",ti.supportsDownload=!0,ti.supportsOverlay=!0;var ii=class e{constructor(t,i){this.parent=t,this.children=[],this.container=document.createElement("div"),this.state={visible:!0},this.viewer=t instanceof e?t.viewer:t,this.container.className=i.className||"",this.parent.children.push(this),this.parent.container.appendChild(this.container)}destroy(){this.parent.container.removeChild(this.container);const e=this.parent.children.indexOf(this);-1!==e&&this.parent.children.splice(e,1),this.children.slice().forEach((e=>e.destroy())),this.children.length=0}toggle(e=!this.isVisible()){e?this.show():this.hide()}hide(e){this.container.style.display="none",this.state.visible=!1}show(e){this.container.style.display="",this.state.visible=!0}isVisible(){return this.state.visible}},si=Ce({id:null,className:null,title:null,hoverScale:!1,collapsable:!1,tabbable:!0,icon:null,iconActive:null}),oi=class extends ii{constructor(e,t){super(e,{className:`psv-button ${t.hoverScale?"psv-button--hover-scale":""} ${t.className||""}`}),this.state={visible:!0,enabled:!0,supported:!0,collapsed:!1,active:!1,width:0},this.config=si(t),this.config.id=this.constructor.id,t.icon&&this.__setIcon(t.icon),this.state.width=this.container.offsetWidth,this.config.title?this.container.title=this.config.title:this.id&&this.id in this.viewer.config.lang&&(this.container.title=this.viewer.config.lang[this.id]),t.tabbable&&(this.container.tabIndex=0),this.container.addEventListener("click",(e=>{this.state.enabled&&this.onClick(),e.stopPropagation()})),this.container.addEventListener("keydown",(e=>{e.key===M.Enter&&this.state.enabled&&(this.onClick(),e.stopPropagation())}))}get id(){return this.config.id}get title(){return this.container.title}get content(){return this.container.innerHTML}get width(){return this.state.width}get collapsable(){return this.config.collapsable}show(e=!0){this.isVisible()||(this.state.visible=!0,this.state.collapsed||(this.container.style.display=""),e&&this.viewer.navbar.autoSize())}hide(e=!0){this.isVisible()&&(this.state.visible=!1,this.container.style.display="none",e&&this.viewer.navbar.autoSize())}checkSupported(){re(this.isSupported(),((e,t)=>{this.state&&(this.state.supported=e,t?e||this.hide():this.toggle(e))}))}autoSize(){}isSupported(){return!0}toggleActive(e=!this.state.active){e!==this.state.active&&(this.state.active=e,A(this.container,"psv-button--active",this.state.active),this.config.iconActive&&this.__setIcon(this.state.active?this.config.iconActive:this.config.icon))}disable(){this.container.classList.add("psv-button--disabled"),this.state.enabled=!1}enable(){this.container.classList.remove("psv-button--disabled"),this.state.enabled=!0}collapse(){this.state.collapsed=!0,this.container.style.display="none"}uncollapse(){this.state.collapsed=!1,this.state.visible&&(this.container.style.display="")}__setIcon(e){this.container.innerHTML=e,D(this.container.querySelector("svg"),"psv-button-svg")}},ni=class extends oi{constructor(e,t){super(e,{className:`psv-custom-button ${t.className||""}`,hoverScale:!1,collapsable:!1!==t.collapsable,tabbable:!1!==t.tabbable,title:t.title}),this.customOnClick=t.onClick,t.id?this.config.id=t.id:this.config.id="psvButton-"+Math.random().toString(36).substring(2),t.content&&(this.container.innerHTML=t.content),this.state.width=this.container.offsetWidth,t.disabled&&this.disable(),!1===t.visible&&this.hide()}onClick(){this.customOnClick?.(this.viewer)}},ri=class extends oi{constructor(e){super(e,{className:"psv-description-button",hoverScale:!0,collapsable:!1,tabbable:!0,icon:T.info}),this.mode=0,this.viewer.addEventListener(it.type,this),this.viewer.addEventListener(Ot.type,this),this.viewer.addEventListener(rt.type,this),this.viewer.addEventListener(kt.type,this),this.viewer.addEventListener(qe.type,this)}destroy(){this.viewer.removeEventListener(it.type,this),this.viewer.removeEventListener(Ot.type,this),this.viewer.removeEventListener(rt.type,this),this.viewer.removeEventListener(kt.type,this),this.viewer.removeEventListener(qe.type,this),super.destroy()}handleEvent(e){if(e instanceof qe)return void(e.containsOptions("description")&&this.autoSize(!0));if(!this.mode)return;let t=!1;e instanceof it?t=1===this.mode:e instanceof Ot?t=1===this.mode&&e.notificationId!==x.DESCRIPTION:e instanceof rt?t=2===this.mode:e instanceof kt&&(t=2===this.mode&&e.panelId!==x.DESCRIPTION),t&&(this.toggleActive(!1),this.mode=0)}onClick(){this.mode?this.__close():this.__open()}hide(e){super.hide(e),this.mode&&this.__close()}autoSize(e=!1){if(e){const e=this.viewer.navbar.getButton("caption",!1),t=e&&!e.isVisible(),i=!!this.viewer.config.description;t||i?this.show(!1):this.hide(!1)}}__close(){switch(this.mode){case 1:this.viewer.notification.hide(x.DESCRIPTION);break;case 2:this.viewer.panel.hide(x.DESCRIPTION)}}__open(){this.toggleActive(!0),this.viewer.config.description?(this.mode=2,this.viewer.panel.show({id:x.DESCRIPTION,content:(this.viewer.config.caption?`<p>${this.viewer.config.caption}</p>`:"")+this.viewer.config.description})):(this.mode=1,this.viewer.notification.show({id:x.DESCRIPTION,content:this.viewer.config.caption}))}};ri.id="description";var ai=class extends oi{constructor(e){super(e,{className:"psv-download-button",hoverScale:!0,collapsable:!0,tabbable:!0,icon:T.download}),this.viewer.addEventListener(qe.type,this)}destroy(){this.viewer.removeEventListener(qe.type,this),super.destroy()}handleEvent(e){e instanceof qe&&e.containsOptions("downloadUrl")&&this.checkSupported()}onClick(){const e=document.createElement("a");e.href=this.viewer.config.downloadUrl||this.viewer.config.panorama,e.href.startsWith("data:")&&!this.viewer.config.downloadName?e.download="panorama."+e.href.substring(0,e.href.indexOf(";")).split("/").pop():e.download=this.viewer.config.downloadName||e.href.split("/").pop(),e.target="_blank",this.viewer.container.appendChild(e),e.click(),setTimeout((()=>{this.viewer.container.removeChild(e)}),100)}checkSupported(){this.viewer.adapter.constructor.supportsDownload||this.viewer.config.downloadUrl?this.show():this.hide()}};ai.id="download";var hi=class extends oi{constructor(e){super(e,{className:"psv-fullscreen-button",hoverScale:!0,collapsable:!1,tabbable:!0,icon:T.fullscreenIn,iconActive:T.fullscreenOut}),this.viewer.addEventListener(et.type,this)}destroy(){this.viewer.removeEventListener(et.type,this),super.destroy()}handleEvent(e){e instanceof et&&this.toggleActive(e.fullscreenEnabled)}onClick(){this.viewer.toggleFullscreen()}};hi.id="fullscreen";var ci=class extends oi{constructor(e){super(e,{className:"psv-menu-button",hoverScale:!0,collapsable:!1,tabbable:!0,icon:T.menu}),this.viewer.addEventListener(kt.type,this),this.viewer.addEventListener(rt.type,this),super.hide()}destroy(){this.viewer.removeEventListener(kt.type,this),this.viewer.removeEventListener(rt.type,this),super.destroy()}handleEvent(e){e instanceof kt?this.toggleActive(e.panelId===x.MENU):e instanceof rt&&this.toggleActive(!1)}onClick(){this.state.active?this.__hideMenu():this.__showMenu()}hide(e){super.hide(e),this.__hideMenu()}show(e){super.show(e),this.state.active&&this.__showMenu()}__showMenu(){var e,t;this.viewer.panel.show({id:x.MENU,content:(e=this.viewer.navbar.collapsed,t=this.viewer.config.lang.menu,`\n<div class="psv-panel-menu psv-panel-menu--stripped">\n  <h1 class="psv-panel-menu-title">${T.menu} ${t}</h1>\n  <ul class="psv-panel-menu-list">\n    ${e.map((e=>`\n    <li data-psv-button="${e.id}" class="psv-panel-menu-item" tabindex="0">\n      <span class="psv-panel-menu-item-icon">${e.content}</span>\n      <span class="psv-panel-menu-item-label">${e.title}</span>\n    </li>\n    `)).join("")}\n  </ul>\n</div>\n`),noMargin:!0,clickHandler:e=>{const t=e?V(e,"li"):void 0,i=t?t.dataset.psvButton:void 0;i&&(this.viewer.navbar.getButton(i).onClick(),this.__hideMenu())}})}__hideMenu(){this.viewer.panel.hide(x.MENU)}};function li(e){let t=0;switch(e){case 0:t=90;break;case 1:t=-90;break;case 3:t=180;break;default:t=0}return T.arrow.replace("rotate(0",`rotate(${t}`)}ci.id="menu";var di=class extends oi{constructor(e,t){super(e,{className:"psv-move-button",hoverScale:!0,collapsable:!1,tabbable:!0,icon:li(t)}),this.direction=t,this.handler=new Re,this.container.addEventListener("mousedown",this),this.container.addEventListener("keydown",this),this.container.addEventListener("keyup",this),this.viewer.container.addEventListener("mouseup",this),this.viewer.container.addEventListener("touchend",this)}destroy(){this.__onMouseUp(),this.viewer.container.removeEventListener("mouseup",this),this.viewer.container.removeEventListener("touchend",this),super.destroy()}handleEvent(e){switch(e.type){case"mousedown":this.__onMouseDown();break;case"mouseup":case"touchend":this.__onMouseUp();break;case"keydown":e.key===M.Enter&&this.__onMouseDown();break;case"keyup":e.key===M.Enter&&this.__onMouseUp()}}onClick(){}isSupported(){return ae(Qt.isTouchEnabled)}__onMouseDown(){if(!this.state.enabled)return;const e={};switch(this.direction){case 0:e.pitch=!1;break;case 1:e.pitch=!0;break;case 3:e.yaw=!1;break;default:e.yaw=!0}this.viewer.stopAll(),this.viewer.dynamics.position.roll(e),this.handler.down()}__onMouseUp(){this.state.enabled&&this.handler.up((()=>{this.viewer.dynamics.position.stop(),this.viewer.resetIdleTimer()}))}};di.groupId="move";var pi=class extends di{constructor(e){super(e,1)}};pi.id="moveDown";var ui=class extends di{constructor(e){super(e,2)}};ui.id="moveLeft";var vi=class extends di{constructor(e){super(e,3)}};vi.id="moveRight";var mi=class extends di{constructor(e){super(e,0)}};mi.id="moveUp";var wi=class extends oi{constructor(e,t,i){super(e,{className:"psv-zoom-button",hoverScale:!0,collapsable:!1,tabbable:!0,icon:t}),this.direction=i,this.handler=new Re,this.container.addEventListener("mousedown",this),this.container.addEventListener("keydown",this),this.container.addEventListener("keyup",this),this.viewer.container.addEventListener("mouseup",this),this.viewer.container.addEventListener("touchend",this)}destroy(){this.__onMouseUp(),this.viewer.container.removeEventListener("mouseup",this),this.viewer.container.removeEventListener("touchend",this),super.destroy()}handleEvent(e){switch(e.type){case"mousedown":this.__onMouseDown();break;case"mouseup":case"touchend":this.__onMouseUp();break;case"keydown":e.key===M.Enter&&this.__onMouseDown();break;case"keyup":e.key===M.Enter&&this.__onMouseUp()}}onClick(){}isSupported(){return ae(Qt.isTouchEnabled)}__onMouseDown(){this.state.enabled&&(this.viewer.dynamics.zoom.roll(1===this.direction),this.handler.down())}__onMouseUp(){this.state.enabled&&this.handler.up((()=>this.viewer.dynamics.zoom.stop()))}};wi.groupId="zoom";var gi=class extends wi{constructor(e){super(e,T.zoomIn,0)}};gi.id="zoomIn";var fi=class extends wi{constructor(e){super(e,T.zoomOut,1)}};fi.id="zoomOut";var yi=class extends oi{constructor(e){super(e,{className:"psv-zoom-range",hoverScale:!1,collapsable:!1,tabbable:!1}),this.zoomRange=document.createElement("div"),this.zoomRange.className="psv-zoom-range-line",this.container.appendChild(this.zoomRange),this.zoomValue=document.createElement("div"),this.zoomValue.className="psv-zoom-range-handle",this.zoomRange.appendChild(this.zoomValue),this.slider=new Ae(this.container,"HORIZONTAL",(e=>this.__onSliderUpdate(e))),this.mediaMinWidth=parseInt(j(this.container,"max-width"),10),this.viewer.addEventListener(Ut.type,this),this.viewer.state.ready?this.__moveZoomValue(this.viewer.getZoomLevel()):this.viewer.addEventListener(_t.type,this)}destroy(){this.slider.destroy(),this.viewer.removeEventListener(Ut.type,this),this.viewer.removeEventListener(_t.type,this),super.destroy()}handleEvent(e){e instanceof Ut?this.__moveZoomValue(e.zoomLevel):e instanceof _t&&this.__moveZoomValue(this.viewer.getZoomLevel())}onClick(){}isSupported(){return ae(Qt.isTouchEnabled)}autoSize(){this.state.supported&&(this.viewer.state.size.width<=this.mediaMinWidth&&this.state.visible?this.hide(!1):this.viewer.state.size.width>this.mediaMinWidth&&!this.state.visible&&this.show(!1))}__moveZoomValue(e){this.zoomValue.style.left=e/100*this.zoomRange.offsetWidth-this.zoomValue.offsetWidth/2+"px"}__onSliderUpdate(e){e.mousedown&&this.viewer.zoom(100*e.value)}};yi.id="zoomRange",yi.groupId="zoom";var bi=a(),Ei=class extends Ne{constructor(e){super(),this.viewer=e}init(){}destroy(){}},_i=class extends Ei{constructor(e,t){super(e),this.config=this.constructor.configParser(t)}setOption(e,t){this.setOptions({[e]:t})}setOptions(e){const t={...this.config,...e},i=this.constructor,s=i.configParser,o=i.readonlyOptions,n=i.id;for(let[i,r]of Object.entries(e))i in s.defaults?o.includes(i)?le(`${n}: Option "${i}" cannot be updated`):(i in s.parsers&&(r=s.parsers[i](r,{rawConfig:t,defValue:s.defaults[i]})),this.config[i]=r):le(`${n}: Unknown option "${i}"`)}};function xi(e){if(e)for(const[,t]of[["_",e],...Object.entries(e)])if(t.prototype instanceof Ei)return Ie(t.id,t.VERSION,"5.5.0"),t;return null}_i.readonlyOptions=[];var Mi={panorama:null,overlay:null,overlayOpacity:1,container:null,adapter:[ti,null],plugins:[],caption:null,description:null,downloadUrl:null,downloadName:null,loadingImg:null,loadingTxt:"Loading...",size:null,fisheye:0,minFov:30,maxFov:90,defaultZoomLvl:50,defaultYaw:0,defaultPitch:0,sphereCorrection:null,moveSpeed:1,zoomSpeed:1,moveInertia:!0,mousewheel:!0,mousemove:!0,mousewheelCtrlKey:!1,touchmoveTwoFingers:!1,useXmpData:null,panoData:null,requestHeaders:null,canvasBackground:null,rendererParameters:{alpha:!0,antialias:!0},withCredentials:!1,navbar:["zoom","move","download","description","caption","fullscreen"],lang:{zoom:"Zoom",zoomOut:"Zoom out",zoomIn:"Zoom in",moveUp:"Move up",moveDown:"Move down",moveLeft:"Move left",moveRight:"Move right",download:"Download",fullscreen:"Fullscreen",menu:"Menu",close:"Close",twoFingers:"Use two fingers to navigate",ctrlZoom:"Use ctrl + scroll to zoom the image",loadError:"The panorama can't be loaded"},keyboard:"fullscreen",keyboardActions:{[M.ArrowUp]:"ROTATE_UP",[M.ArrowDown]:"ROTATE_DOWN",[M.ArrowRight]:"ROTATE_RIGHT",[M.ArrowLeft]:"ROTATE_LEFT",[M.PageUp]:"ZOOM_IN",[M.PageDown]:"ZOOM_OUT",[M.Plus]:"ZOOM_IN",[M.Minus]:"ZOOM_OUT"}},Ti={panorama:"Use setPanorama method to change the panorama",panoData:"Use setPanorama method to change the panorama",overlay:"Use setOverlay method to changer the overlay",overlayOpacity:"Use setOverlay method to changer the overlay",container:"Cannot change viewer container",adapter:"Cannot change adapter",plugins:"Cannot change plugins"},Oi={container:e=>{if(!e)throw new ne("No value given for container.");return e},adapter:(e,{defValue:t})=>{if(!(e=e?Array.isArray(e)?[Gt(e[0]),e[1]]:[Gt(e),null]:t)[0])throw new ne("An undefined value was given for adapter.");if(!e[0].id)throw new ne("Adapter has no id.");return e},overlayOpacity:e=>bi.MathUtils.clamp(e,0,1),defaultYaw:e=>xe(e),defaultPitch:e=>xe(e,!0),defaultZoomLvl:e=>bi.MathUtils.clamp(e,0,100),minFov:(e,{rawConfig:t})=>(t.maxFov<e&&(le("maxFov cannot be lower than minFov"),e=t.maxFov),bi.MathUtils.clamp(e,1,179)),maxFov:(e,{rawConfig:t})=>(e<t.minFov&&(e=t.minFov),bi.MathUtils.clamp(e,1,179)),lang:e=>(Array.isArray(e.twoFingers)&&(le("lang.twoFingers must not be an array"),e.twoFingers=e.twoFingers[0]),{...Mi.lang,...e}),keyboard:e=>!!e&&("object"==typeof e?(le("Use keyboardActions to configure the keyboard actions, keyboard option must be either true, false, 'fullscreen' or 'always'"),"fullscreen"):"always"===e?"always":"fullscreen"),keyboardActions:(e,{rawConfig:t})=>t.keyboard&&"object"==typeof t.keyboard?t.keyboard:e,fisheye:e=>!0===e?1:!1===e?0:e,requestHeaders:e=>e&&"object"==typeof e?()=>e:"function"==typeof e?e:null,rendererParameters:(e,{defValue:t})=>({...e,...t}),plugins:e=>e.map(((e,t)=>{if(!(e=Array.isArray(e)?[xi(e[0]),e[1]]:[xi(e),null])[0])throw new ne(`An undefined value was given for plugin ${t}.`);if(!e[0].id)throw new ne(`Plugin ${t} has no id.`);return e})),navbar:e=>!1===e?null:!0===e?Q(Mi.navbar):"string"==typeof e?e.split(/[ ,]/):e,useXmpData:e=>(null!==e&&le("Global useXmpData is deprecated, it is now configured on the adapter."),e),canvasBackground:e=>(null!==e&&le("Global canvasBackground is deprecated, it is now configured on the adapter."),e),overlay:e=>(null!==e&&le('"overlay" option is deprecated, use "@photo-sphere-viewer/overlay-plugin" instead.'),e)},Ci=Ce(Mi,Oi),Li=class extends oi{constructor(e){super(e,{className:"psv-caption",hoverScale:!1,collapsable:!1,tabbable:!0}),this.contentWidth=0,this.state.width=0,this.contentElt=document.createElement("div"),this.contentElt.className="psv-caption-content",this.container.appendChild(this.contentElt),this.setCaption(this.viewer.config.caption)}hide(){this.contentElt.style.display="none",this.state.visible=!1}show(){this.contentElt.style.display="",this.state.visible=!0}onClick(){}setCaption(e){this.show(),this.contentElt.innerHTML=e??"",this.contentElt.innerHTML?this.contentWidth=this.contentElt.offsetWidth:this.contentWidth=0,this.autoSize()}autoSize(){this.toggle(this.container.offsetWidth>=this.contentWidth),this.__refreshButton()}__refreshButton(){this.viewer.navbar.getButton(ri.id,!1)?.autoSize(!0)}};Li.id="caption";var Ii={},ki={};function Pi(e,t){if(!e.id)throw new ne("Button id is required");if(Ii[e.id]=e,e.groupId&&(ki[e.groupId]=ki[e.groupId]||[]).push(e),t){const i=Mi.navbar;switch(t){case"start":i.unshift(e.id);break;case"end":i.push(e.id);break;default:{const[s,o]=t.split(":"),n=i.indexOf(s);if(!s||!o||-1===n)throw new ne(`Invalid defaultPosition ${t}`);i.splice(n+("right"===o?1:0),0,e.id)}}}}[fi,yi,gi,ri,Li,ai,hi,ui,vi,mi,pi].forEach((e=>Pi(e)));var Si=class extends ii{constructor(e){super(e,{className:`psv-navbar ${E}`}),this.collapsed=[],this.state.visible=!1}show(){this.viewer.container.classList.add("psv--has-navbar"),this.container.classList.add("psv-navbar--open"),this.state.visible=!0}hide(){this.viewer.container.classList.remove("psv--has-navbar"),this.container.classList.remove("psv-navbar--open"),this.state.visible=!1}setButtons(e){this.children.slice().forEach((e=>e.destroy())),this.children.length=0,-1!==e.indexOf(Li.id)&&-1===e.indexOf(ri.id)&&e.splice(e.indexOf(Li.id),0,ri.id),e.forEach((e=>{"object"==typeof e?new ni(this,e):Ii[e]?new Ii[e](this):ki[e]?ki[e].forEach((e=>{new e(this)})):le(`Unknown button ${e}`)})),new ci(this),this.children.forEach((e=>{e instanceof oi&&e.checkSupported()})),this.autoSize()}setCaption(e){this.children.some((t=>t instanceof Li&&(t.setCaption(e),!0)))}getButton(e,t=!0){const i=this.children.find((t=>t instanceof oi&&t.id===e));return!i&&t&&le(`button "${e}" not found in the navbar`),i}autoSize(){this.children.forEach((e=>{e instanceof oi&&e.autoSize()}));const e=this.container.offsetWidth;let t=0;const i=[];this.children.forEach((e=>{e.isVisible()&&e instanceof oi&&(t+=e.width,e.collapsable&&i.push(e))})),0!==t&&(e<t&&i.length>0?(i.forEach((e=>e.collapse())),this.collapsed=i,this.getButton(ci.id).show(!1)):e>=t&&this.collapsed.length>0&&(this.collapsed.forEach((e=>e.uncollapse())),this.collapsed=[],this.getButton(ci.id).hide(!1)),this.getButton(Li.id,!1)?.autoSize())}},Hi=class extends ii{constructor(e){super(e,{className:"psv-loader-container"}),this.loader=document.createElement("div"),this.loader.className="psv-loader",this.container.appendChild(this.loader),this.size=this.loader.offsetWidth,this.canvas=document.createElementNS("http://www.w3.org/2000/svg","svg"),this.canvas.setAttribute("class","psv-loader-canvas"),this.canvas.setAttribute("viewBox",`0 0 ${this.size} ${this.size}`),this.loader.appendChild(this.canvas),this.textColor=j(this.loader,"color"),this.color=j(this.canvas,"color"),this.border=parseInt(j(this.loader,"--psv-loader-border"),10),this.thickness=parseInt(j(this.loader,"--psv-loader-tickness"),10),this.viewer.addEventListener(qe.type,this),this.__updateContent(),this.hide()}destroy(){this.viewer.removeEventListener(qe.type,this),super.destroy()}handleEvent(e){e instanceof qe&&e.containsOptions("loadingImg","loadingTxt")&&this.__updateContent()}setProgress(e){const t=Math.min(e,99.999)/100*Math.PI*2,i=this.size/2,s=i,o=this.thickness/2+this.border,n=(this.size-this.thickness)/2-this.border,r=Math.sin(t)*n+i,a=-Math.cos(t)*n+i,h=e>50?"1":"0";this.canvas.innerHTML=`\n            <circle cx="${i}" cy="${i}" r="${i}" fill="${this.color}"/>\n            <path d="M ${s} ${o} A ${n} ${n} 0 ${h} 1 ${r} ${a}" \n                  fill="none" stroke="${this.textColor}" stroke-width="${this.thickness}" stroke-linecap="round"/>\n        `,this.viewer.dispatchEvent(new pt(Math.round(e)))}__updateContent(){const e=this.loader.querySelector(".psv-loader-image, .psv-loader-text");let t;if(e&&this.loader.removeChild(e),this.viewer.config.loadingImg?(t=document.createElement("img"),t.className="psv-loader-image",t.src=this.viewer.config.loadingImg):this.viewer.config.loadingTxt&&(t=document.createElement("div"),t.className="psv-loader-text",t.innerHTML=this.viewer.config.loadingTxt),t){const e=Math.round(Math.sqrt(2*Math.pow(this.size/2-this.thickness/2-this.border,2)));t.style.maxWidth=e+"px",t.style.maxHeight=e+"px",this.loader.appendChild(t)}}},Ri=class extends ii{constructor(e){super(e,{className:"psv-notification"}),this.state={visible:!1,contentId:null,timeout:null},this.content=document.createElement("div"),this.content.className="psv-notification-content",this.container.appendChild(this.content),this.content.addEventListener("click",(()=>this.hide()))}isVisible(e){return this.state.visible&&(!e||!this.state.contentId||this.state.contentId===e)}toggle(){throw new ne("Notification cannot be toggled")}show(e){this.state.timeout&&(clearTimeout(this.state.timeout),this.state.timeout=null),"string"==typeof e&&(e={content:e}),this.state.contentId=e.id||null,this.content.innerHTML=e.content,this.container.classList.add("psv-notification--visible"),this.state.visible=!0,this.viewer.dispatchEvent(new Ot(e.id)),e.timeout&&(this.state.timeout=setTimeout((()=>this.hide(this.state.contentId)),e.timeout))}hide(e){if(this.isVisible(e)){const e=this.state.contentId;this.container.classList.remove("psv-notification--visible"),this.state.visible=!1,this.state.contentId=null,this.viewer.dispatchEvent(new it(e))}}},zi=class extends ii{constructor(e){super(e,{className:`psv-overlay ${E}`}),this.state={visible:!1,contentId:null,dissmisable:!0},this.image=document.createElement("div"),this.image.className="psv-overlay-image",this.container.appendChild(this.image),this.title=document.createElement("div"),this.title.className="psv-overlay-title",this.container.appendChild(this.title),this.text=document.createElement("div"),this.text.className="psv-overlay-text",this.container.appendChild(this.text),this.container.addEventListener("click",this),this.viewer.addEventListener(lt.type,this),super.hide()}destroy(){this.viewer.removeEventListener(lt.type,this),super.destroy()}handleEvent(e){"click"===e.type?this.isVisible()&&this.state.dissmisable&&(this.hide(),e.stopPropagation()):e instanceof lt&&this.isVisible()&&this.state.dissmisable&&e.key===M.Escape&&(this.hide(),e.preventDefault())}isVisible(e){return this.state.visible&&(!e||!this.state.contentId||this.state.contentId===e)}toggle(){throw new ne("Overlay cannot be toggled")}show(e){"string"==typeof e&&(e={title:e}),this.state.contentId=e.id||null,this.state.dissmisable=!1!==e.dissmisable,this.image.innerHTML=e.image||"",this.title.innerHTML=e.title||"",this.text.innerHTML=e.text||"",super.show(),this.viewer.dispatchEvent(new Lt(e.id))}hide(e){if(this.isVisible(e)){const e=this.state.contentId;super.hide(),this.state.contentId=null,this.viewer.dispatchEvent(new ot(e))}}},Ai="psv-panel-content--no-interaction",Di=class extends ii{constructor(e){super(e,{className:`psv-panel ${E}`}),this.state={visible:!1,contentId:null,mouseX:0,mouseY:0,mousedown:!1,clickHandler:null,keyHandler:null,width:{}};const t=document.createElement("div");t.className="psv-panel-resizer",this.container.appendChild(t);const i=document.createElement("div");i.className="psv-panel-close-button",i.innerHTML=T.close,i.title=e.config.lang.close,this.container.appendChild(i),this.content=document.createElement("div"),this.content.className="psv-panel-content",this.container.appendChild(this.content),this.container.addEventListener("wheel",(e=>e.stopPropagation())),i.addEventListener("click",(()=>this.hide())),t.addEventListener("mousedown",this),t.addEventListener("touchstart",this),this.viewer.container.addEventListener("mouseup",this),this.viewer.container.addEventListener("touchend",this),this.viewer.container.addEventListener("mousemove",this),this.viewer.container.addEventListener("touchmove",this),this.viewer.addEventListener(lt.type,this)}destroy(){this.viewer.removeEventListener(lt.type,this),this.viewer.container.removeEventListener("mousemove",this),this.viewer.container.removeEventListener("touchmove",this),this.viewer.container.removeEventListener("mouseup",this),this.viewer.container.removeEventListener("touchend",this),super.destroy()}handleEvent(e){switch(e.type){case"mousedown":this.__onMouseDown(e);break;case"touchstart":this.__onTouchStart(e);break;case"mousemove":this.__onMouseMove(e);break;case"touchmove":this.__onTouchMove(e);break;case"mouseup":this.__onMouseUp(e);break;case"touchend":this.__onTouchEnd(e);break;case lt.type:this.__onKeyPress(e)}}isVisible(e){return this.state.visible&&(!e||!this.state.contentId||this.state.contentId===e)}toggle(){throw new ne("Panel cannot be toggled")}show(e){"string"==typeof e&&(e={content:e});const t=this.isVisible(e.id);this.state.contentId=e.id||null,this.state.visible=!0,this.state.clickHandler&&(this.content.removeEventListener("click",this.state.clickHandler),this.content.removeEventListener("keydown",this.state.keyHandler),this.state.clickHandler=null,this.state.keyHandler=null),e.id&&this.state.width[e.id]?this.container.style.width=this.state.width[e.id]:e.width?this.container.style.width=e.width:this.container.style.width=null,this.content.innerHTML=e.content,this.content.scrollTop=0,this.container.classList.add("psv-panel--open"),A(this.content,"psv-panel-content--no-margin",!0===e.noMargin),e.clickHandler&&(this.state.clickHandler=t=>{e.clickHandler(t.target)},this.state.keyHandler=t=>{t.key===M.Enter&&e.clickHandler(t.target)},this.content.addEventListener("click",this.state.clickHandler),this.content.addEventListener("keydown",this.state.keyHandler),t||setTimeout((()=>{this.content.querySelector("a,button,[tabindex]")?.focus()}),300)),this.viewer.dispatchEvent(new kt(e.id))}hide(e){if(this.isVisible(e)){const e=this.state.contentId;this.state.visible=!1,this.state.contentId=null,this.content.innerHTML=null,this.container.classList.remove("psv-panel--open"),this.state.clickHandler&&(this.content.removeEventListener("click",this.state.clickHandler),this.state.clickHandler=null),this.viewer.dispatchEvent(new rt(e))}}__onMouseDown(e){e.stopPropagation(),this.__startResize(e.clientX,e.clientY)}__onTouchStart(e){if(e.stopPropagation(),1===e.touches.length){const t=e.touches[0];this.__startResize(t.clientX,t.clientY)}}__onMouseUp(e){this.state.mousedown&&(e.stopPropagation(),this.state.mousedown=!1,this.content.classList.remove(Ai))}__onTouchEnd(e){this.state.mousedown&&(e.stopPropagation(),0===e.touches.length&&(this.state.mousedown=!1,this.content.classList.remove(Ai)))}__onMouseMove(e){this.state.mousedown&&(e.stopPropagation(),this.__resize(e.clientX,e.clientY))}__onTouchMove(e){if(this.state.mousedown){const t=e.touches[0];this.__resize(t.clientX,t.clientY)}}__onKeyPress(e){this.isVisible()&&e.key===M.Escape&&(this.hide(),e.preventDefault())}__startResize(e,t){this.state.mouseX=e,this.state.mouseY=t,this.state.mousedown=!0,this.content.classList.add(Ai)}__resize(e,t){const i=e,s=t,o=Math.max(200,this.container.offsetWidth-(i-this.state.mouseX))+"px";this.state.contentId&&(this.state.width[this.state.contentId]=o),this.container.style.width=o,this.state.mouseX=i,this.state.mouseY=s}},Ui=class extends ii{constructor(e,t){super(e,{className:"psv-tooltip"}),this.state={visible:!0,arrow:0,border:0,state:0,width:0,height:0,pos:"",config:null,data:null},this.content=document.createElement("div"),this.content.className="psv-tooltip-content",this.container.appendChild(this.content),this.arrow=document.createElement("div"),this.arrow.className="psv-tooltip-arrow",this.container.appendChild(this.arrow),this.container.addEventListener("transitionend",this),this.container.addEventListener("touchdown",(e=>e.stopPropagation())),this.container.addEventListener("mousedown",(e=>e.stopPropagation())),this.container.style.top="-1000px",this.container.style.left="-1000px",this.show(t)}handleEvent(e){"transitionend"===e.type&&this.__onTransitionEnd(e)}destroy(){delete this.state.data,super.destroy()}toggle(){throw new ne("Tooltip cannot be toggled")}show(e){if(0!==this.state.state)throw new ne("Initialized tooltip cannot be re-initialized");e.className&&D(this.container,e.className),e.style&&Object.assign(this.container.style,e.style),this.state.state=3,this.update(e.content,e),this.state.data=e.data,this.state.state=1,this.viewer.dispatchEvent(new St(this,this.state.data)),this.__waitImages()}update(e,t){this.content.innerHTML=e;const i=this.container.getBoundingClientRect();this.state.width=i.right-i.left,this.state.height=i.bottom-i.top,this.state.arrow=parseInt(j(this.arrow,"border-top-width"),10),this.state.border=parseInt(j(this.container,"border-top-left-radius"),10),this.move(t??this.state.config)}move(e){if(1!==this.state.state&&3!==this.state.state)throw new ne("Uninitialized tooltip cannot be moved");e.box=e.box??this.state.config?.box??{width:0,height:0},this.state.config=e;const t=this.container,i=this.arrow,s={posClass:ye(e.position,{allowCenter:!1,cssOrder:!1})||["top","center"],width:this.state.width,height:this.state.height,top:0,left:0,arrowTop:0,arrowLeft:0};this.__computeTooltipPosition(s,e);let o=null,n=null;if(s.top<0?o="bottom":s.top+s.height>this.viewer.state.size.height&&(o="top"),s.left<0?n="right":s.left+s.width>this.viewer.state.size.width&&(n="left"),n||o){const t=be(s.posClass);o&&(s.posClass[t?0:1]=o),n&&(s.posClass[t?1:0]=n),this.__computeTooltipPosition(s,e)}t.style.top=s.top+"px",t.style.left=s.left+"px",i.style.top=s.arrowTop+"px",i.style.left=s.arrowLeft+"px";const r=s.posClass.join("-");r!==this.state.pos&&(t.classList.remove(`psv-tooltip--${this.state.pos}`),this.state.pos=r,t.classList.add(`psv-tooltip--${this.state.pos}`))}hide(){this.container.classList.remove("psv-tooltip--visible"),this.state.state=2,this.viewer.dispatchEvent(new ht(this.state.data))}__onTransitionEnd(e){if("transform"===e.propertyName)switch(this.state.state){case 1:this.container.classList.add("psv-tooltip--visible"),this.state.state=3;break;case 2:this.state.state=0,this.destroy()}}__computeTooltipPosition(e,t){const i=this.state.arrow,s=t.top,o=e.height,n=t.left,r=e.width,a=i+this.state.border,h=t.box.width/2+2*i,c=t.box.height/2+2*i;switch(e.posClass.join("-")){case"top-left":e.top=s-c-o,e.left=n+a-r,e.arrowTop=o,e.arrowLeft=r-a-i;break;case"top-center":e.top=s-c-o,e.left=n-r/2,e.arrowTop=o,e.arrowLeft=r/2-i;break;case"top-right":e.top=s-c-o,e.left=n-a,e.arrowTop=o,e.arrowLeft=i;break;case"bottom-left":e.top=s+c,e.left=n+a-r,e.arrowTop=2*-i,e.arrowLeft=r-a-i;break;case"bottom-center":e.top=s+c,e.left=n-r/2,e.arrowTop=2*-i,e.arrowLeft=r/2-i;break;case"bottom-right":e.top=s+c,e.left=n-a,e.arrowTop=2*-i,e.arrowLeft=i;break;case"left-top":e.top=s+a-o,e.left=n-h-r,e.arrowTop=o-a-i,e.arrowLeft=r;break;case"center-left":e.top=s-o/2,e.left=n-h-r,e.arrowTop=o/2-i,e.arrowLeft=r;break;case"left-bottom":e.top=s-a,e.left=n-h-r,e.arrowTop=i,e.arrowLeft=r;break;case"right-top":e.top=s+a-o,e.left=n+h,e.arrowTop=o-a-i,e.arrowLeft=2*-i;break;case"center-right":e.top=s-o/2,e.left=n+h,e.arrowTop=o/2-i,e.arrowLeft=2*-i;break;case"right-bottom":e.top=s-a,e.left=n+h,e.arrowTop=i,e.arrowLeft=2*-i}}__waitImages(){const e=this.content.querySelectorAll("img");if(e.length>0){const t=[];e.forEach((e=>{t.push(new Promise((t=>{e.onload=t,e.onerror=t})))})),Promise.all(t).then((()=>{if(1===this.state.state||3===this.state.state){const e=this.container.getBoundingClientRect();this.state.width=e.right-e.left,this.state.height=e.bottom-e.top,this.move(this.state.config)}}))}}},Ni=a(),Vi={enabled:!0,maxItems:10,ttl:600,items:{},purgeInterval:null,init(){Ni.Cache.enabled&&(le("ThreeJS cache should be disabled"),Ni.Cache.enabled=!1),!this.purgeInterval&&this.enabled&&(this.purgeInterval=setInterval((()=>this.purge()),6e4))},add(e,t,i){this.enabled&&t&&(this.items[t]=this.items[t]??{files:{},lastAccess:null},this.items[t].files[e]=i,this.items[t].lastAccess=Date.now())},get(e,t){if(this.enabled&&t&&this.items[t])return this.items[t].lastAccess=Date.now(),this.items[t].files[e]},remove(e,t){this.enabled&&t&&this.items[t]&&(delete this.items[t].files[e],0===Object.keys(this.items[t].files).length&&delete this.items[t])},purge(){Object.entries(this.items).sort((([,e],[,t])=>t.lastAccess-e.lastAccess)).forEach((([e,{lastAccess:t}],i)=>{i>0&&(Date.now()-t>=1e3*this.ttl||i>=this.maxItems)&&delete this.items[e]}))}},Fi=a(),Wi=class{constructor(e){this.viewer=e,this.config=e.config,this.state=e.state}destroy(){}},ji=new Fi.Vector3,Yi=new Fi.Euler(0,0,0,"ZXY"),Xi=class extends Wi{constructor(e){super(e)}fovToZoomLevel(e){const t=Math.round((e-this.config.minFov)/(this.config.maxFov-this.config.minFov)*100);return t-2*(t-50)}zoomLevelToFov(e){return this.config.maxFov+e/100*(this.config.minFov-this.config.maxFov)}vFovToHFov(e){return Fi.MathUtils.radToDeg(2*Math.atan(Math.tan(Fi.MathUtils.degToRad(e)/2)*this.state.aspect))}getAnimationProperties(e,t,i){const s=!ee(t),o=!ee(i),n={};let r;if(s){const i=this.viewer.getPosition(),s=S(i.yaw,t.yaw);n.yaw={start:i.yaw,end:i.yaw+s},n.pitch={start:i.pitch,end:t.pitch},r=_e(e,H(i,t))}if(o){const t=this.viewer.getZoomLevel(),s=Math.abs(i-t);n.zoom={start:t,end:i},r||(r=_e(e,Math.PI/4*s/100))}return r=Math.max(p,r),{duration:r,properties:n}}textureCoordsToSphericalCoords(e){if(!this.state.textureData?.panoData)throw new ne("Current adapter does not support texture coordinates or no texture has been loaded");const t=this.viewer.adapter.textureCoordsToSphericalCoords(e,this.state.textureData.panoData);return Yi.equals(this.viewer.renderer.panoramaPose)&&Yi.equals(this.viewer.renderer.sphereCorrection)?t:(this.sphericalCoordsToVector3(t,ji),ji.applyEuler(this.viewer.renderer.panoramaPose),ji.applyEuler(this.viewer.renderer.sphereCorrection),this.vector3ToSphericalCoords(ji))}sphericalCoordsToTextureCoords(e){if(!this.state.textureData?.panoData)throw new ne("Current adapter does not support texture coordinates or no texture has been loaded");return Yi.equals(this.viewer.renderer.panoramaPose)&&Yi.equals(this.viewer.renderer.sphereCorrection)||(this.sphericalCoordsToVector3(e,ji),Oe(ji,this.viewer.renderer.sphereCorrection),Oe(ji,this.viewer.renderer.panoramaPose),e=this.vector3ToSphericalCoords(ji)),this.viewer.adapter.sphericalCoordsToTextureCoords(e,this.state.textureData.panoData)}sphericalCoordsToVector3(e,t,i=y){return t||(t=new Fi.Vector3),t.x=i*-Math.cos(e.pitch)*Math.sin(e.yaw),t.y=i*Math.sin(e.pitch),t.z=i*Math.cos(e.pitch)*Math.cos(e.yaw),t}vector3ToSphericalCoords(e){const t=Math.acos(e.y/Math.sqrt(e.x*e.x+e.y*e.y+e.z*e.z)),i=Math.atan2(e.x,e.z);return{yaw:i<0?-i:2*Math.PI-i,pitch:Math.PI/2-t}}viewerCoordsToVector3(e){const t=this.viewer.renderer.getIntersections(e).filter((e=>e.object.userData[b]));return t.length?t[0].point:null}viewerCoordsToSphericalCoords(e){const t=this.viewerCoordsToVector3(e);return t?this.vector3ToSphericalCoords(t):null}vector3ToViewerCoords(e){const t=e.clone();return t.project(this.viewer.renderer.camera),{x:Math.round((t.x+1)/2*this.state.size.width),y:Math.round((1-t.y)/2*this.state.size.height)}}sphericalCoordsToViewerCoords(e){return this.sphericalCoordsToVector3(e,ji),this.vector3ToViewerCoords(ji)}isPointVisible(e){let t,i;if(e instanceof Fi.Vector3)t=e,i=this.vector3ToViewerCoords(e);else{if(!de(e))return!1;t=this.sphericalCoordsToVector3(e,ji),i=this.vector3ToViewerCoords(t)}return t.dot(this.viewer.state.direction)>0&&i.x>=0&&i.x<=this.viewer.state.size.width&&i.y>=0&&i.y<=this.viewer.state.size.height}cleanPosition(e){return"yaw"in e&&"pitch"in e?{yaw:xe(e.yaw),pitch:xe(e.pitch,!this.state.littlePlanet)}:this.textureCoordsToSphericalCoords(e)}cleanSphereCorrection(e){return{pan:xe(e?.pan||0),tilt:xe(e?.tilt||0,!0),roll:xe(e?.roll||0,!0,!1)}}cleanPanoramaPose(e){return{pan:Fi.MathUtils.degToRad(e?.poseHeading||0),tilt:Fi.MathUtils.degToRad(e?.posePitch||0),roll:Fi.MathUtils.degToRad(e?.poseRoll||0)}}},$i=a(),Zi=class e{constructor(){this.$=e.IDLE}is(...e){return e.some((e=>this.$&e))}set(e){this.$=e}add(e){this.$|=e}remove(e){this.$&=~e}};Zi.IDLE=0,Zi.CLICK=1,Zi.MOVING=2,Zi.INERTIA=4;var Bi=Zi,Gi=class extends Wi{constructor(e){super(e),this.data={startMouseX:0,startMouseY:0,mouseX:0,mouseY:0,mouseHistory:[],pinchDist:0,ctrlKeyDown:!1,dblclickData:null,dblclickTimeout:null,longtouchTimeout:null,twofingersTimeout:null,ctrlZoomTimeout:null},this.step=new Bi,this.keyHandler=new Re,this.resizeObserver=new ResizeObserver(G((()=>this.viewer.autoSize()),50)),this.moveThreshold=u*Qt.pixelRatio}init(){window.addEventListener("keydown",this,{passive:!1}),window.addEventListener("keyup",this),this.viewer.container.addEventListener("mousedown",this),window.addEventListener("mousemove",this,{passive:!1}),window.addEventListener("mouseup",this),this.viewer.container.addEventListener("touchstart",this,{passive:!1}),window.addEventListener("touchmove",this,{passive:!1}),window.addEventListener("touchend",this,{passive:!1}),this.viewer.container.addEventListener("wheel",this,{passive:!1}),document.addEventListener(Qt.fullscreenEvent,this),this.resizeObserver.observe(this.viewer.container)}destroy(){window.removeEventListener("keydown",this),window.removeEventListener("keyup",this),this.viewer.container.removeEventListener("mousedown",this),window.removeEventListener("mousemove",this),window.removeEventListener("mouseup",this),this.viewer.container.removeEventListener("touchstart",this),window.removeEventListener("touchmove",this),window.removeEventListener("touchend",this),this.viewer.container.removeEventListener("wheel",this),document.removeEventListener(Qt.fullscreenEvent,this),this.resizeObserver.disconnect(),clearTimeout(this.data.dblclickTimeout),clearTimeout(this.data.longtouchTimeout),clearTimeout(this.data.twofingersTimeout),clearTimeout(this.data.ctrlZoomTimeout),super.destroy()}handleEvent(e){switch(e.type){case"keydown":this.__onKeyDown(e);break;case"keyup":this.__onKeyUp();break;case"mousemove":this.__onMouseMove(e);break;case"mouseup":this.__onMouseUp(e);break;case"touchmove":this.__onTouchMove(e);break;case"touchend":this.__onTouchEnd(e);break;case Qt.fullscreenEvent:this.__onFullscreenChange()}if(!V(e.target,"."+E))switch(e.type){case"mousedown":this.__onMouseDown(e);break;case"touchstart":this.__onTouchStart(e);break;case"wheel":this.__onMouseWheel(e)}}__onKeyDown(e){if(this.config.mousewheelCtrlKey&&(this.data.ctrlKeyDown=e.key===M.Control,this.data.ctrlKeyDown&&(clearTimeout(this.data.ctrlZoomTimeout),this.viewer.overlay.hide(x.CTRL_ZOOM))),!this.viewer.dispatchEvent(new lt(e.key)))return;if(!this.state.keyboardEnabled)return;const t=this.config.keyboardActions?.[e.key];if("function"==typeof t)t(this.viewer),e.preventDefault();else if(t&&!this.keyHandler.pending){switch("ZOOM_IN"!==t&&"ZOOM_OUT"!==t&&this.viewer.stopAll(),t){case"ROTATE_UP":this.viewer.dynamics.position.roll({pitch:!1});break;case"ROTATE_DOWN":this.viewer.dynamics.position.roll({pitch:!0});break;case"ROTATE_RIGHT":this.viewer.dynamics.position.roll({yaw:!1});break;case"ROTATE_LEFT":this.viewer.dynamics.position.roll({yaw:!0});break;case"ZOOM_IN":this.viewer.dynamics.zoom.roll(!1);break;case"ZOOM_OUT":this.viewer.dynamics.zoom.roll(!0)}this.keyHandler.down(),e.preventDefault()}}__onKeyUp(){this.data.ctrlKeyDown=!1,this.state.keyboardEnabled&&this.keyHandler.up((()=>{this.viewer.dynamics.position.stop(),this.viewer.dynamics.zoom.stop(),this.viewer.resetIdleTimer()}))}__onMouseDown(e){this.step.add(Bi.CLICK),this.data.startMouseX=e.clientX,this.data.startMouseY=e.clientY}__onMouseUp(e){this.step.is(Bi.CLICK,Bi.MOVING)&&this.__stopMove(e.clientX,e.clientY,e.target,2===e.button)}__onMouseMove(e){this.config.mousemove&&this.step.is(Bi.CLICK,Bi.MOVING)&&(e.preventDefault(),this.__doMove(e.clientX,e.clientY)),this.__handleObjectsEvents(e)}__onTouchStart(e){1===e.touches.length?(this.step.add(Bi.CLICK),this.data.startMouseX=e.touches[0].clientX,this.data.startMouseY=e.touches[0].clientY,this.data.longtouchTimeout||(this.data.longtouchTimeout=setTimeout((()=>{const t=e.touches[0];this.__stopMove(t.clientX,t.clientY,t.target,!0),this.data.longtouchTimeout=null}),m))):2===e.touches.length&&(this.step.set(Bi.IDLE),this.__cancelLongTouch(),this.config.mousemove&&(this.__cancelTwoFingersOverlay(),this.__startMoveZoom(e),e.preventDefault()))}__onTouchEnd(e){if(this.__cancelLongTouch(),this.step.is(Bi.CLICK,Bi.MOVING))if(e.preventDefault(),this.__cancelTwoFingersOverlay(),1===e.touches.length)this.__stopMove(this.data.mouseX,this.data.mouseY);else if(0===e.touches.length){const t=e.changedTouches[0];this.__stopMove(t.clientX,t.clientY,t.target)}}__onTouchMove(e){if(this.__cancelLongTouch(),this.config.mousemove)if(1===e.touches.length){if(this.config.touchmoveTwoFingers)this.step.is(Bi.CLICK)&&!this.data.twofingersTimeout&&(this.data.twofingersTimeout=setTimeout((()=>{this.viewer.overlay.show({id:x.TWO_FINGERS,image:'<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><path fill="currentColor" d="M33.38 33.2a1.96 1.96 0 0 0 1.5-3.23 10.61 10.61 0 0 1 7.18-17.51c.7-.06 1.31-.49 1.61-1.12a13.02 13.02 0 0 1 11.74-7.43c7.14 0 12.96 5.8 12.96 12.9 0 3.07-1.1 6.05-3.1 8.38-.7.82-.61 2.05.21 2.76.83.7 2.07.6 2.78-.22a16.77 16.77 0 0 0 4.04-10.91C72.3 7.54 64.72 0 55.4 0a16.98 16.98 0 0 0-14.79 8.7 14.6 14.6 0 0 0-12.23 14.36c0 3.46 1.25 6.82 3.5 9.45.4.45.94.69 1.5.69m45.74 43.55a22.13 22.13 0 0 1-5.23 12.4c-4 4.55-9.53 6.86-16.42 6.86-12.6 0-20.1-10.8-20.17-10.91a1.82 1.82 0 0 0-.08-.1c-5.3-6.83-14.55-23.82-17.27-28.87-.05-.1 0-.21.02-.23a6.3 6.3 0 0 1 8.24 1.85l9.38 12.59a1.97 1.97 0 0 0 3.54-1.17V25.34a4 4 0 0 1 1.19-2.87 3.32 3.32 0 0 1 2.4-.95c1.88.05 3.4 1.82 3.4 3.94v24.32a1.96 1.96 0 0 0 3.93 0v-33.1a3.5 3.5 0 0 1 7 0v35.39a1.96 1.96 0 0 0 3.93 0v-.44c.05-2.05 1.6-3.7 3.49-3.7 1.93 0 3.5 1.7 3.5 3.82v5.63c0 .24.04.48.13.71l.1.26a1.97 1.97 0 0 0 3.76-.37c.33-1.78 1.77-3.07 3.43-3.07 1.9 0 3.45 1.67 3.5 3.74l-1.77 18.1zM77.39 51c-1.25 0-2.45.32-3.5.9v-.15c0-4.27-3.33-7.74-7.42-7.74-1.26 0-2.45.33-3.5.9V16.69a7.42 7.42 0 0 0-14.85 0v1.86a7 7 0 0 0-3.28-.94 7.21 7.21 0 0 0-5.26 2.07 7.92 7.92 0 0 0-2.38 5.67v37.9l-5.83-7.82a10.2 10.2 0 0 0-13.35-2.92 4.1 4.1 0 0 0-1.53 5.48C20 64.52 28.74 80.45 34.07 87.34c.72 1.04 9.02 12.59 23.4 12.59 7.96 0 14.66-2.84 19.38-8.2a26.06 26.06 0 0 0 6.18-14.6l1.78-18.2v-.2c0-4.26-3.32-7.73-7.42-7.73z"/>\x3c!--Created by AomAm from the Noun Project--\x3e</svg>\n',title:this.config.lang.twoFingers})}),w));else if(this.step.is(Bi.CLICK,Bi.MOVING)){e.preventDefault();const t=e.touches[0];this.__doMove(t.clientX,t.clientY)}}else this.__doMoveZoom(e),this.__cancelTwoFingersOverlay()}__cancelLongTouch(){this.data.longtouchTimeout&&(clearTimeout(this.data.longtouchTimeout),this.data.longtouchTimeout=null)}__cancelTwoFingersOverlay(){this.config.touchmoveTwoFingers&&(this.data.twofingersTimeout&&(clearTimeout(this.data.twofingersTimeout),this.data.twofingersTimeout=null),this.viewer.overlay.hide(x.TWO_FINGERS))}__onMouseWheel(e){if(!this.config.mousewheel||!e.deltaY)return;if(this.config.mousewheelCtrlKey&&!this.data.ctrlKeyDown)return this.viewer.overlay.show({id:x.CTRL_ZOOM,image:'<svg xmlns="http://www.w3.org/2000/svg" viewBox="10 17 79 79"><path fill="currentColor" d="M38.1 29.27c-.24 0-.44.2-.44.45v10.7a.45.45 0 00.9 0v-10.7c0-.25-.2-.45-.45-.45zm10.2 26.66a11.54 11.54 0 01-8.48-6.14.45.45 0 10-.8.41 12.45 12.45 0 009.22 6.62.45.45 0 00.07-.9zm24.55-13.08a23.04 23.04 0 00-22.56-23v7.07l-.01.05a2.83 2.83 0 012.39 2.78v14.03l.09-.02h8.84v-9.22a.45.45 0 11.9 0v9.22h10.35v-.9zm0 27.33V44.66H62.5c-.02 2.01-.52 4-1.47 5.76a.45.45 0 01-.61.18.45.45 0 01-.19-.61 11.54 11.54 0 001.36-5.33h-8.83l-.1-.01a2.83 2.83 0 01-2.83 2.84h-.04-.04a2.83 2.83 0 01-2.83-2.83v-14.9a2.82 2.82 0 012.47-2.8v-7.11a23.04 23.04 0 00-22.57 23v.91h14.72V29.88a8.2 8.2 0 015.02-7.57c.22-.1.5.01.59.24.1.23-.01.5-.24.6a7.3 7.3 0 00-4.47 6.73v13.88h3.9a.45.45 0 110 .9h-3.9v.15a7.32 7.32 0 0011.23 6.17.45.45 0 01.49.76 8.22 8.22 0 01-12.62-6.93v-.15H26.82v25.52a23.04 23.04 0 0023.01 23.01 23.04 23.04 0 0023.02-23.01zm1.8-27.33v27.33A24.85 24.85 0 0149.84 95a24.85 24.85 0 01-24.82-24.82V42.85a24.85 24.85 0 0124.82-24.82 24.85 24.85 0 0124.83 24.82zM57.98 29.88v9.36a.45.45 0 11-.9 0v-9.36a7.28 7.28 0 00-3.4-6.17.45.45 0 01.49-.76 8.18 8.18 0 013.8 6.93z"/>\x3c!-- Created by Icon Island from the Noun Project --\x3e</svg>\n',title:this.config.lang.ctrlZoom}),clearTimeout(this.data.ctrlZoomTimeout),void(this.data.ctrlZoomTimeout=setTimeout((()=>this.viewer.overlay.hide(x.CTRL_ZOOM)),g));e.preventDefault(),e.stopPropagation();const t=e.deltaY/Math.abs(e.deltaY)*5*this.config.zoomSpeed;0!==t&&this.viewer.dynamics.zoom.step(-t,5)}__onFullscreenChange(){const e=this.viewer.isFullscreenEnabled();"fullscreen"===this.config.keyboard&&(e?this.viewer.startKeyboardControl():this.viewer.stopKeyboardControl()),this.viewer.dispatchEvent(new et(e))}__resetMove(){this.step.set(Bi.IDLE),this.data.mouseX=0,this.data.mouseY=0,this.data.startMouseX=0,this.data.startMouseY=0,this.data.mouseHistory.length=0}__startMoveZoom(e){this.viewer.stopAll(),this.__resetMove();const t=Y(e);this.step.set(Bi.MOVING),({distance:this.data.pinchDist,center:{x:this.data.mouseX,y:this.data.mouseY}}=t),this.__logMouseMove(this.data.mouseX,this.data.mouseY)}__stopMove(e,t,i,s=!1){this.step.is(Bi.MOVING)?this.config.moveInertia?(this.__logMouseMove(e,t),this.__stopMoveInertia(e,t)):(this.__resetMove(),this.viewer.resetIdleTimer()):(this.step.is(Bi.CLICK)&&!this.__moveThresholdReached(e,t)&&this.__doClick(e,t,i,s),this.step.remove(Bi.CLICK),this.step.is(Bi.INERTIA)||(this.__resetMove(),this.viewer.resetIdleTimer()))}__stopMoveInertia(e,t){const i=new $i.SplineCurve(this.data.mouseHistory.map((([,e,t])=>new $i.Vector2(e,t)))).getTangent(1),s=this.data.mouseHistory.reduce((({total:e,prev:t},i)=>({total:t?e+k({x:t[1],y:t[2]},{x:i[1],y:i[2]})/(i[0]-t[0]):0,prev:i})),{total:0,prev:null}).total/this.data.mouseHistory.length;if(!s)return this.__resetMove(),void this.viewer.resetIdleTimer();this.step.set(Bi.INERTIA);let o=e,n=t;this.state.animation=new ke({properties:{speed:{start:s,end:0}},duration:1e3,easing:"outQuad",onTick:e=>{o+=e.speed*i.x*3*Qt.pixelRatio,n+=e.speed*i.y*3*Qt.pixelRatio,this.__applyMove(o,n)}}),this.state.animation.then((e=>{this.state.animation=null,e&&(this.__resetMove(),this.viewer.resetIdleTimer())}))}__doClick(e,t,i,s=!1){const o=this.viewer.container.getBoundingClientRect(),n=e-o.left,r=t-o.top,a=this.viewer.renderer.getIntersections({x:n,y:r}),h=a.find((e=>e.object.userData[b]));if(h){const o=this.viewer.dataHelper.vector3ToSphericalCoords(h.point),c={rightclick:s,target:i,clientX:e,clientY:t,viewerX:n,viewerY:r,yaw:o.yaw,pitch:o.pitch,objects:a.map((e=>e.object)).filter((e=>!e.userData[b]))};try{const e=this.viewer.dataHelper.sphericalCoordsToTextureCoords(c);Object.assign(c,e)}catch(e){}this.data.dblclickTimeout?(Math.abs(this.data.dblclickData.clientX-c.clientX)<this.moveThreshold&&Math.abs(this.data.dblclickData.clientY-c.clientY)<this.moveThreshold&&this.viewer.dispatchEvent(new Qe(this.data.dblclickData)),clearTimeout(this.data.dblclickTimeout),this.data.dblclickTimeout=null,this.data.dblclickData=null):(this.viewer.dispatchEvent(new Be(c)),this.data.dblclickData=Q(c),this.data.dblclickTimeout=setTimeout((()=>{this.data.dblclickTimeout=null,this.data.dblclickData=null}),v))}}__handleObjectsEvents(e){if(!J(this.state.objectsObservers)&&N(e.target,this.viewer.container)){const t=F(this.viewer.container),i={x:e.clientX-t.x,y:e.clientY-t.y},s=this.viewer.renderer.getIntersections(i),o=(t,s,o)=>{this.viewer.dispatchEvent(new o(e,t,i,s))};for(const[e,t]of Object.entries(this.state.objectsObservers)){const i=s.find((t=>t.object.userData[e]));i?(t&&i.object!==t&&(o(t,e,jt),this.state.objectsObservers[e]=null),t?o(i.object,e,Xt):(this.state.objectsObservers[e]=i.object,o(i.object,e,Ft))):t&&(o(t,e,jt),this.state.objectsObservers[e]=null)}}}__doMove(e,t){this.step.is(Bi.CLICK)&&this.__moveThresholdReached(e,t)?(this.viewer.stopAll(),this.__resetMove(),this.step.set(Bi.MOVING),this.data.mouseX=e,this.data.mouseY=t,this.__logMouseMove(e,t)):this.step.is(Bi.MOVING)&&(this.__applyMove(e,t),this.__logMouseMove(e,t))}__moveThresholdReached(e,t){return Math.abs(e-this.data.startMouseX)>=this.moveThreshold||Math.abs(t-this.data.startMouseY)>=this.moveThreshold}__applyMove(e,t){const i=this.config.moveSpeed*((e-this.data.mouseX)/this.state.size.width)*$i.MathUtils.degToRad(this.state.littlePlanet?90:this.state.hFov),s=this.config.moveSpeed*((t-this.data.mouseY)/this.state.size.height)*$i.MathUtils.degToRad(this.state.littlePlanet?90:this.state.vFov),o=this.viewer.getPosition();this.viewer.rotate({yaw:o.yaw-i,pitch:o.pitch+s}),this.data.mouseX=e,this.data.mouseY=t}__doMoveZoom(e){if(this.step.is(Bi.MOVING)){e.preventDefault();const t=Y(e),i=(t.distance-this.data.pinchDist)/Qt.pixelRatio*this.config.zoomSpeed;this.viewer.zoom(this.viewer.getZoomLevel()+i),this.__doMove(t.center.x,t.center.y),this.data.pinchDist=t.distance}}__logMouseMove(e,t){const i=Date.now(),s=this.data.mouseHistory.length?this.data.mouseHistory[this.data.mouseHistory.length-1]:[0,-1,-1];s[1]===e&&s[2]===t?s[0]=i:i===s[0]?(s[1]=e,s[2]=t):this.data.mouseHistory.push([i,e,t]);let o=null;for(let e=0;e<this.data.mouseHistory.length;)this.data.mouseHistory[e][0]<i-f?this.data.mouseHistory.splice(e,1):o&&this.data.mouseHistory[e][0]-o>f/10?(this.data.mouseHistory.splice(0,e),e=0,o=this.data.mouseHistory[e][0]):(o=this.data.mouseHistory[e][0],e++)}},qi=a(),Ki=new qi.Vector2,Qi=new qi.Matrix4,Ji=new qi.Box3,es=class extends Wi{constructor(e){super(e),this.frustumNeedsUpdate=!0,this.renderer=new qi.WebGLRenderer(this.config.rendererParameters),this.renderer.setPixelRatio(Qt.pixelRatio),this.renderer.outputColorSpace=qi.LinearSRGBColorSpace,this.renderer.domElement.className="psv-canvas",this.scene=new qi.Scene,this.camera=new qi.PerspectiveCamera(50,16/9,.1,2*y),this.camera.matrixWorldAutoUpdate=!1,this.mesh=this.viewer.adapter.createMesh(),this.mesh.userData={[b]:!0},this.meshContainer=new qi.Group,this.meshContainer.add(this.mesh),this.scene.add(this.meshContainer),this.raycaster=new qi.Raycaster,this.frustum=new qi.Frustum,this.container=document.createElement("div"),this.container.className="psv-canvas-container",this.container.appendChild(this.renderer.domElement),this.viewer.container.appendChild(this.container),this.viewer.addEventListener(Rt.type,this),this.viewer.addEventListener(Ut.type,this),this.viewer.addEventListener(bt.type,this),this.viewer.addEventListener(qe.type,this),this.hide()}get panoramaPose(){return this.mesh.rotation}get sphereCorrection(){return this.meshContainer.rotation}init(){this.show(),this.renderer.setAnimationLoop((e=>this.__renderLoop(e)))}destroy(){this.renderer.setAnimationLoop(null),this.cleanScene(this.scene),this.viewer.container.removeChild(this.container),this.viewer.removeEventListener(Rt.type,this),this.viewer.removeEventListener(Ut.type,this),this.viewer.removeEventListener(bt.type,this),this.viewer.removeEventListener(qe.type,this),super.destroy()}handleEvent(e){switch(e.type){case Rt.type:this.__onSizeUpdated();break;case Ut.type:this.__onZoomUpdated();break;case bt.type:this.__onPositionUpdated();break;case qe.type:e.containsOptions("fisheye")&&this.__onPositionUpdated(),e.containsOptions("canvasBackground")&&(this.container.style.background=this.config.canvasBackground)}}hide(){this.container.style.opacity="0"}show(){this.container.style.opacity="1"}setCustomRenderer(e){this.customRenderer=e?e(this.renderer):null,this.viewer.needsUpdate()}__onSizeUpdated(){this.renderer.setSize(this.state.size.width,this.state.size.height),this.camera.aspect=this.state.aspect,this.camera.updateProjectionMatrix(),this.viewer.needsUpdate(),this.frustumNeedsUpdate=!0}__onZoomUpdated(){this.camera.fov=this.state.vFov,this.camera.updateProjectionMatrix(),this.viewer.needsUpdate(),this.frustumNeedsUpdate=!0}__onPositionUpdated(){this.camera.position.set(0,0,0),this.camera.lookAt(this.state.direction),this.config.fisheye&&this.camera.position.copy(this.state.direction).multiplyScalar(this.config.fisheye/2).negate(),this.camera.updateMatrixWorld(),this.viewer.needsUpdate(),this.frustumNeedsUpdate=!0}__renderLoop(e){const t=this.timestamp?e-this.timestamp:0;this.timestamp=e,this.viewer.dispatchEvent(new Ye(e,t)),this.viewer.dynamics.update(t),(this.state.needsUpdate||this.state.continuousUpdateCount>0)&&((this.customRenderer||this.renderer).render(this.scene,this.camera),this.viewer.dispatchEvent(new Mt),this.state.needsUpdate=!1)}setTexture(e){this.viewer.adapter.constructor.supportsOverlay&&this.setOverlay(null,0),this.state.textureData&&this.viewer.adapter.disposeTexture(this.state.textureData),this.state.textureData=e,this.viewer.adapter.setTexture(this.mesh,e),this.viewer.needsUpdate()}setOverlay(e,t){this.state.overlayData&&this.viewer.adapter.disposeTexture(this.state.overlayData),this.state.overlayData=e,this.viewer.adapter.setOverlay(this.mesh,e,t),this.viewer.needsUpdate()}setPanoramaPose(e,t=this.mesh){const i=this.viewer.dataHelper.cleanPanoramaPose(e);t.rotation.set(-i.tilt,-i.pan,-i.roll,"ZXY")}setSphereCorrection(e,t=this.meshContainer){const i=this.viewer.dataHelper.cleanSphereCorrection(e);t.rotation.set(i.tilt,i.pan,i.roll,"ZXY")}transition(e,t){const i=!ee(t.position),s=!ee(t.zoom),o=new We(i?this.viewer.dataHelper.cleanPosition(t.position):void 0,t.zoom);this.viewer.dispatchEvent(o);const n=new qi.Group,r=this.viewer.adapter.createMesh(.5);if(this.viewer.adapter.setTexture(r,e,!0),this.viewer.adapter.setTextureOpacity(r,0),this.setPanoramaPose(e.panoData,r),this.setSphereCorrection(t.sphereCorrection,n),i&&"fade-only"===t.transition){const e=this.viewer.getPosition(),t=new qi.Vector3(0,1,0);n.rotateOnWorldAxis(t,o.position.yaw-e.yaw);const i=new qi.Vector3(0,1,0).cross(this.camera.getWorldDirection(new qi.Vector3)).normalize();n.rotateOnWorldAxis(i,o.position.pitch-e.pitch)}n.add(r),this.scene.add(n),this.renderer.setRenderTarget(new qi.WebGLRenderTarget),this.renderer.render(this.scene,this.camera),this.renderer.setRenderTarget(null);const{duration:a,properties:h}=this.viewer.dataHelper.getAnimationProperties(t.transition,!0===t.transition?o.position:null,o.zoomLevel),c=new ke({properties:{...h,opacity:{start:0,end:1}},duration:a,easing:"inOutCubic",onTick:e=>{this.viewer.adapter.setTextureOpacity(r,e.opacity),i&&!0===t.transition&&this.viewer.dynamics.position.setValue({yaw:e.yaw,pitch:e.pitch}),s&&this.viewer.dynamics.zoom.setValue(e.zoom),this.viewer.needsUpdate()}});return c.then((s=>{s?(this.setTexture(e),this.viewer.adapter.setTextureOpacity(this.mesh,1),this.setPanoramaPose(e.panoData),this.setSphereCorrection(t.sphereCorrection),i&&"fade-only"===t.transition&&this.viewer.rotate(t.position)):this.viewer.adapter.disposeTexture(e),this.scene.remove(n),r.geometry.dispose(),r.geometry=null})),c}getIntersections(e){Ki.x=2*e.x/this.state.size.width-1,Ki.y=-2*e.y/this.state.size.height+1,this.raycaster.setFromCamera(Ki,this.camera);const t=this.raycaster.intersectObjects(this.scene.children,!0).filter((e=>e.object.isMesh&&!!e.object.userData));return this.customRenderer?.getIntersections&&t.push(...this.customRenderer.getIntersections(this.raycaster,Ki)),t}isObjectVisible(e){if(!e)return!1;if(this.frustumNeedsUpdate&&(Qi.multiplyMatrices(this.camera.projectionMatrix,this.camera.matrixWorldInverse),this.frustum.setFromProjectionMatrix(Qi),this.frustumNeedsUpdate=!1),e.isVector3)return this.frustum.containsPoint(e);if(e.isMesh&&e.geometry){const t=e;return t.geometry.boundingBox||t.geometry.computeBoundingBox(),Ji.copy(t.geometry.boundingBox).applyMatrix4(t.matrixWorld),this.frustum.intersectsBox(Ji)}return!!e.isObject3D&&this.frustum.intersectsObject(e)}addObject(e){this.scene.add(e)}removeObject(e){this.scene.remove(e)}cleanScene(e){const t=e=>{e.map?.dispose(),e.uniforms&&Object.values(e.uniforms).forEach((e=>{e.value?.dispose?.()})),e.dispose()};e.traverse((i=>{i.geometry?.dispose(),i.material&&(Array.isArray(i.material)?i.material.forEach((e=>{t(e)})):t(i.material)),i instanceof qi.Scene||i.dispose?.(),i!==e&&this.cleanScene(i)}))}},ts=a(),is=class extends Wi{constructor(e){super(e),this.fileLoader=new ts.FileLoader,this.fileLoader.setResponseType("blob"),this.imageLoader=new ts.ImageLoader,this.config.withCredentials&&(this.fileLoader.setWithCredentials(!0),this.imageLoader.setCrossOrigin("use-credentials"))}destroy(){this.abortLoading(),super.destroy()}abortLoading(){}loadFile(e,t,i){const s=Vi.get(e,i);if(s){if(s instanceof Blob)return t?.(100),Promise.resolve(s);Vi.remove(e,i)}return this.config.requestHeaders&&this.fileLoader.setRequestHeader(this.config.requestHeaders(e)),new Promise(((s,o)=>{let n=0;t?.(n),this.fileLoader.load(e,(o=>{n=100,t?.(n),Vi.add(e,i,o),s(o)}),(e=>{if(e.lengthComputable){const i=e.loaded/e.total*100;i>n&&(n=i,t?.(n))}}),(e=>{o(e)}))}))}loadImage(e,t,i){const s=Vi.get(e,i);return s?(t?.(100),s instanceof Blob?this.blobToImage(s):Promise.resolve(s)):t||this.config.requestHeaders?this.loadFile(e,t,i).then((e=>this.blobToImage(e))):this.imageLoader.loadAsync(e).then((t=>(Vi.add(e,i,t),t)))}blobToImage(e){return new Promise(((t,i)=>{const s=document.createElement("img");s.onload=()=>{URL.revokeObjectURL(s.src),t(s)},s.onerror=i,s.src=URL.createObjectURL(e)}))}preloadPanorama(e){return this.viewer.adapter.supportsPreload(e)?this.viewer.adapter.loadTexture(e):Promise.reject(new ne("Current adapter does not support preload"))}},ss=a(),os=class extends Wi{constructor(e){super(e),this.zoom=new Se((e=>{this.viewer.state.vFov=this.viewer.dataHelper.zoomLevelToFov(e),this.viewer.state.hFov=this.viewer.dataHelper.vFovToHFov(this.viewer.state.vFov),this.viewer.dispatchEvent(new Ut(e))}),{defaultValue:this.viewer.config.defaultZoomLvl,min:0,max:100,wrap:!1}),this.position=new He((e=>{this.viewer.dataHelper.sphericalCoordsToVector3(e,this.viewer.state.direction),this.viewer.dispatchEvent(new bt(e))}),{yaw:new Se(null,{defaultValue:this.config.defaultYaw,min:0,max:2*Math.PI,wrap:!0}),pitch:new Se(null,{defaultValue:this.config.defaultPitch,min:this.viewer.state.littlePlanet?0:-Math.PI/2,max:this.viewer.state.littlePlanet?2*Math.PI:Math.PI/2,wrap:this.viewer.state.littlePlanet})}),this.updateSpeeds()}updateSpeeds(){this.zoom.setSpeed(50*this.config.zoomSpeed),this.position.setSpeed(ss.MathUtils.degToRad(50*this.config.moveSpeed))}update(e){this.zoom.update(e),this.position.update(e)}},ns=a(),rs=class{constructor(){this.ready=!1,this.needsUpdate=!1,this.continuousUpdateCount=0,this.keyboardEnabled=!1,this.direction=new ns.Vector3(0,0,y),this.vFov=60,this.hFov=60,this.aspect=1,this.animation=null,this.transitionAnimation=null,this.loadingPromise=null,this.littlePlanet=!1,this.idleTime=-1,this.objectsObservers={},this.size={width:0,height:0}}get panoData(){return le("ViewerState.panoData is deprecated, use ViewerState.textureData.panoData instead"),this.textureData?.panoData}},as=class extends Ne{constructor(e){super(),this.plugins={},this.children=[],this.onResize=G((()=>this.navbar.autoSize()),500),Vi.init(),Qt.load(),this.state=new rs,this.config=Ci(e),this.parent=z(e.container),this.parent[b]=this,this.container=document.createElement("div"),this.container.classList.add("psv-container"),this.parent.appendChild(this.container),Le(this.container,"core"),this.adapter=new this.config.adapter[0](this,this.config.adapter[1]),this.renderer=new es(this),this.textureLoader=new is(this),this.eventsHandler=new Gi(this),this.dataHelper=new Xi(this),this.dynamics=new os(this),this.adapter.init?.(),this.loader=new Hi(this),this.navbar=new Si(this),this.panel=new Di(this),this.notification=new Ri(this),this.overlay=new zi(this),this.resize(this.config.size),this.setCursor(null),re(Qt.isTouchEnabled,(e=>{A(this.container,"psv--is-touch",e)})),this.config.plugins.forEach((([e,t])=>{this.plugins[e.id]=new e(this,t)}));for(const e of Object.values(this.plugins))e.init?.();this.config.navbar&&this.navbar.setButtons(this.config.navbar),this.state.loadingPromise||(this.config.panorama?this.setPanorama(this.config.panorama):this.loader.show())}destroy(){this.stopAll(),this.stopKeyboardControl(),this.exitFullscreen();for(const[e,t]of Object.entries(this.plugins))t.destroy(),delete this.plugins[e];this.children.slice().forEach((e=>e.destroy())),this.children.length=0,this.eventsHandler.destroy(),this.renderer.destroy(),this.textureLoader.destroy(),this.dataHelper.destroy(),this.adapter.destroy(),this.dynamics.destroy(),this.parent.removeChild(this.container),delete this.parent[b]}init(){this.eventsHandler.init(),this.renderer.init(),this.config.navbar&&this.navbar.show(),"always"===this.config.keyboard&&this.startKeyboardControl(),this.resetIdleTimer(),this.state.ready=!0,this.dispatchEvent(new _t)}resetIdleTimer(){this.state.idleTime=performance.now()}disableIdleTimer(){this.state.idleTime=-1}getPlugin(e){if("string"==typeof e)return this.plugins[e];{const t=xi(e);return t?this.plugins[t.id]:null}}getPosition(){return this.dataHelper.cleanPosition(this.dynamics.position.current)}getZoomLevel(){return this.dynamics.zoom.current}getSize(){return{...this.state.size}}isFullscreenEnabled(){return X(this.parent)}needsUpdate(){this.state.needsUpdate=!0}needsContinuousUpdate(e){e?this.state.continuousUpdateCount++:this.state.continuousUpdateCount>0&&this.state.continuousUpdateCount--}autoSize(){this.container.clientWidth===this.state.size.width&&this.container.clientHeight===this.state.size.height||(this.state.size.width=Math.round(this.container.clientWidth),this.state.size.height=Math.round(this.container.clientHeight),this.state.aspect=this.state.size.width/this.state.size.height,this.state.hFov=this.dataHelper.vFovToHFov(this.state.vFov),this.dispatchEvent(new Rt(this.getSize())),this.onResize())}setPanorama(e,t={}){this.textureLoader.abortLoading(),this.state.transitionAnimation?.cancel(),this.state.ready||["sphereCorrection","panoData","overlay","overlayOpacity"].forEach((e=>{e in t||(t[e]=this.config[e])})),de(t)&&(le("PanoramaOptions.yaw and PanoramaOptions.pitch are deprecated, use PanoramaOptions.position instead"),t.position=this.dataHelper.cleanPosition(t)),"number"==typeof t.transition&&(le("Use PanoramaOptions.speed to define the speed/duration of the transition"),t.speed=t.transition,t.transition=!0),void 0===t.transition&&(t.transition=!0),void 0===t.speed&&(t.speed=d),void 0===t.showLoader&&(t.showLoader=!0),void 0===t.caption&&(t.caption=this.config.caption),void 0===t.description&&(t.description=this.config.description),t.panoData||"function"!=typeof this.config.panoData||(t.panoData=this.config.panoData);const i=!ee(t.position),s=!ee(t.zoom);(i||s)&&this.stopAll(),this.hideError(),this.resetIdleTimer(),this.config.panorama=e,this.config.caption=t.caption,this.config.description=t.description;const o=i=>{if(this.loader.hide(),this.state.loadingPromise=null,ce(i))return!1;if(i)throw this.navbar.setCaption(""),this.showError(this.config.lang.loadError),console.error(i),this.dispatchEvent(new ft(e,i)),i;return this.setOverlay(t.overlay,t.overlayOpacity),this.navbar.setCaption(this.config.caption),!0};this.navbar.setCaption(`<em>${this.config.loadingTxt||""}</em>`),!t.showLoader&&this.state.ready||this.loader.show(),this.dispatchEvent(new vt(e));const n=this.adapter.loadTexture(this.config.panorama,t.panoData).then((e=>{if(e.panorama!==this.config.panorama)throw this.adapter.disposeTexture(e),he();return e}));return t.transition&&this.state.ready&&this.adapter.supportsTransition(this.config.panorama)?this.state.loadingPromise=n.then((e=>(this.loader.hide(),this.dispatchEvent(new wt(e)),this.state.transitionAnimation=this.renderer.transition(e,t),this.state.transitionAnimation))).then((e=>{if(this.state.transitionAnimation=null,!e)throw he()})).then((()=>o()),(e=>o(e))):this.state.loadingPromise=n.then((e=>{this.renderer.show(),this.renderer.setTexture(e),this.renderer.setPanoramaPose(e.panoData),this.renderer.setSphereCorrection(t.sphereCorrection),this.state.ready||this.init(),this.dispatchEvent(new wt(e)),s&&this.zoom(t.zoom),i&&this.rotate(t.position)})).then((()=>o()),(e=>o(e))),this.state.loadingPromise}setOverlay(e,t=this.config.overlayOpacity){const i=this.adapter.constructor.supportsOverlay;return e?i?this.adapter.loadTexture(e,(e=>{if(this.state.textureData.panoData.isEquirectangular){const t=this.state.textureData.panoData,i=e.width/t.croppedWidth;return{isEquirectangular:!0,fullWidth:i*t.fullWidth,fullHeight:i*t.fullHeight,croppedWidth:i*t.croppedWidth,croppedHeight:i*t.croppedHeight,croppedX:i*t.croppedX,croppedY:i*t.croppedY}}}),!1,!1).then((e=>{this.renderer.setOverlay(e,t)})):Promise.reject(new ne("Current adapter does not supports overlay")):(i&&this.renderer.setOverlay(null,0),Promise.resolve())}setOptions(e){const t={...this.config,...e};for(let[i,s]of Object.entries(e))if(i in Mi)if(i in Ti)le(Ti[i]);else switch(i in Oi&&(s=Oi[i](s,{rawConfig:t,defValue:Mi[i]})),this.config[i]=s,i){case"mousemove":this.state.cursorOverride||this.setCursor(null);break;case"caption":this.navbar.setCaption(this.config.caption);break;case"size":this.resize(this.config.size);break;case"sphereCorrection":this.renderer.setSphereCorrection(this.config.sphereCorrection);break;case"navbar":case"lang":this.navbar.setButtons(this.config.navbar);break;case"moveSpeed":case"zoomSpeed":this.dynamics.updateSpeeds();break;case"minFov":case"maxFov":this.dynamics.zoom.setValue(this.dataHelper.fovToZoomLevel(this.state.vFov)),this.dispatchEvent(new Ut(this.getZoomLevel()));break;case"keyboard":"always"===this.config.keyboard?this.startKeyboardControl():this.stopKeyboardControl()}else le(`Unknown option ${i}`);this.needsUpdate(),this.dispatchEvent(new qe(Object.keys(e)))}setOption(e,t){this.setOptions({[e]:t})}showError(e){this.overlay.show({id:x.ERROR,image:'<svg xmlns="http://www.w3.org/2000/svg" viewBox="15 15 70 70"><path fill="currentColor" d="M50,16.2c-18.6,0-33.8,15.1-33.8,33.8S31.4,83.7,50,83.7S83.8,68.6,83.8,50S68.6,16.2,50,16.2z M50,80.2c-16.7,0-30.2-13.6-30.2-30.2S33.3,19.7,50,19.7S80.3,33.3,80.3,50S66.7,80.2,50,80.2z"/><rect fill="currentColor" x="48" y="31.7" width="4" height="28"/><rect fill="currentColor" x="48" y="63.2" width="4" height="5"/>\x3c!--Created by Shastry from the Noun Project--\x3e</svg>\n',title:e,dissmisable:!1})}hideError(){this.overlay.hide(x.ERROR)}rotate(e){const t=new $e(this.dataHelper.cleanPosition(e));this.dispatchEvent(t),t.defaultPrevented||this.dynamics.position.setValue(t.position)}zoom(e){this.dynamics.zoom.setValue(e)}zoomIn(e=1){this.dynamics.zoom.step(e)}zoomOut(e=1){this.dynamics.zoom.step(-e)}animate(e){const t=de(e),i=!ee(e.zoom),s=new We(t?this.dataHelper.cleanPosition(e):void 0,e.zoom);if(this.dispatchEvent(s),s.defaultPrevented)return;this.stopAll();const{duration:o,properties:n}=this.dataHelper.getAnimationProperties(e.speed,s.position,s.zoomLevel);return o?(this.state.animation=new ke({properties:n,duration:o,easing:"inOutSine",onTick:e=>{t&&this.dynamics.position.setValue({yaw:e.yaw,pitch:e.pitch}),i&&this.dynamics.zoom.setValue(e.zoom)}}),this.state.animation.then((()=>{this.state.animation=null,this.resetIdleTimer()})),this.state.animation):(t&&this.rotate(s.position),i&&this.zoom(s.zoomLevel),new ke(null))}stopAnimation(){return this.state.animation?(this.state.animation.cancel(),this.state.animation):Promise.resolve()}resize(e){const t=e;["width","height"].forEach((i=>{e&&t[i]&&(/^[0-9.]+$/.test(t[i])&&(t[i]+="px"),this.parent.style[i]=t[i])})),this.autoSize()}enterFullscreen(){this.isFullscreenEnabled()||$(this.parent)}exitFullscreen(){this.isFullscreenEnabled()&&Z()}toggleFullscreen(){this.isFullscreenEnabled()?this.exitFullscreen():this.enterFullscreen()}startKeyboardControl(){this.state.keyboardEnabled=!0}stopKeyboardControl(){this.state.keyboardEnabled=!1}createTooltip(e){return new Ui(this,e)}setCursor(e){this.state.cursorOverride=e,this.container.style.cursor=e||(this.config.mousemove?"move":"default")}observeObjects(e){this.state.objectsObservers[e]||(this.state.objectsObservers[e]=null)}unobserveObjects(e){delete this.state.objectsObservers[e]}stopAll(){return this.dispatchEvent(new At),this.disableIdleTimer(),this.stopAnimation()}};c.Cache.enabled=!1,c.ColorManagement.enabled=!1;var hs="5.5.0";((e,t,r,a)=>{if(t&&"object"==typeof t||"function"==typeof t)for(let h of o(t))n.call(e,h)||h===r||i(e,h,{get:()=>t[h],enumerable:!(a=s(t,h))||a.enumerable})})(i(e,"__esModule",{value:!0}),h)}));
