/*!
 * Photo Sphere Viewer 3.4.0
 * Copyright (c) 2014-2015 Jérémy Heleine
 * Copyright (c) 2015-2018 Damien "Mistic" Sorel
 * Licensed under MIT (https://opensource.org/licenses/MIT)
 */
!function(t,e){"function"==typeof define&&define.amd?define(["three","d.js","uevent","dot/doT"],e):"object"==typeof module&&module.exports?module.exports=e(require("three"),require("d.js"),require("uevent"),require("dot/doT")):t.PhotoSphereViewer=e(t.THREE,t.D,t.uEvent,t.doT)}(this,function(t,e,i,o){"use strict";function n(e){if(!(this instanceof n))return new n(e);if(n.SYSTEM.loaded||n._loadSystem(),this.config=x.clone(n.DEFAULTS),x.deepmerge(this.config,e),!e.container)throw new E("No value given for container.");if(!n.SYSTEM.isCanvasSupported)throw new E("Canvas is not supported.");if(!(n.SYSTEM.isWebGLSupported&&this.config.webgl||x.checkTHREE("CanvasRenderer","Projector")))throw new E("Missing Three.js components: CanvasRenderer, Projector. Get them from three.js-examples package.");if(this.config.longitude_range&&2!==this.config.longitude_range.length&&(this.config.longitude_range=null,console.warn("PhotoSphereViewer: longitude_range must have exactly two elements.")),this.config.latitude_range?2!==this.config.latitude_range.length?(this.config.latitude_range=null,console.warn("PhotoSphereViewer: latitude_range must have exactly two elements.")):this.config.latitude_range[0]>this.config.latitude_range[1]&&(this.config.latitude_range=[this.config.latitude_range[1],this.config.latitude_range[0]],console.warn("PhotoSphereViewer: latitude_range values must be ordered.")):void 0===this.config.tilt_up_max&&void 0===this.config.tilt_down_max||(this.config.latitude_range=[void 0!==this.config.tilt_down_max?this.config.tilt_down_max-Math.PI/4:-x.HalfPI,void 0!==this.config.tilt_up_max?this.config.tilt_up_max+Math.PI/4:x.HalfPI],console.warn("PhotoSphereViewer: tilt_up_max and tilt_down_max are deprecated, use latitude_range instead.")),this.config.max_fov<this.config.min_fov){var i=this.config.max_fov;this.config.max_fov=this.config.min_fov,this.config.min_fov=i,console.warn("PhotoSphereViewer: max_fov cannot be lower than min_fov.")}this.config.cache_texture&&(!x.isInteger(this.config.cache_texture)||this.config.cache_texture<0)&&(this.config.cache_texture=n.DEFAULTS.cache_texture,console.warn("PhotoSphereViewer: invalid value for cache_texture")),"panorama_roll"in this.config&&(this.config.sphere_correction.roll=this.config.panorama_roll,console.warn("PhotoSphereViewer: panorama_roll is deprecated, use sphere_correction.roll instead")),"gyroscope"in this.config&&console.warn("PhotoSphereViewer: gyroscope is deprecated, the control is automatically created if DeviceOrientationControls.js is loaded"),this.config.min_fov=x.bound(this.config.min_fov,1,179),this.config.max_fov=x.bound(this.config.max_fov,1,179),null===this.config.default_fov?this.config.default_fov=this.config.max_fov/2+this.config.min_fov/2:this.config.default_fov=x.bound(this.config.default_fov,this.config.min_fov,this.config.max_fov),this.config.default_long=x.parseAngle(this.config.default_long),this.config.default_lat=x.parseAngle(this.config.default_lat,!0),this.config.sphere_correction.pan=x.parseAngle(this.config.sphere_correction.pan,!0),this.config.sphere_correction.tilt=x.parseAngle(this.config.sphere_correction.tilt,!0),this.config.sphere_correction.roll=x.parseAngle(this.config.sphere_correction.roll,!0),null===this.config.anim_lat?this.config.anim_lat=this.config.default_lat:this.config.anim_lat=x.parseAngle(this.config.anim_lat,!0),this.config.longitude_range&&(this.config.longitude_range=this.config.longitude_range.map(function(t){return x.parseAngle(t)})),this.config.latitude_range&&(this.config.latitude_range=this.config.latitude_range.map(function(t){return x.parseAngle(t,!0)})),this.config.anim_speed=x.parseSpeed(this.config.anim_speed),this.config.caption&&!this.config.navbar&&(this.config.navbar=["caption"]),!0===this.config.fisheye?this.config.fisheye=1:!1===this.config.fisheye&&(this.config.fisheye=0),this.parent="string"==typeof e.container?document.getElementById(e.container):e.container,this.container=null,this.loader=null,this.navbar=null,this.hud=null,this.panel=null,this.tooltip=null,this.notification=null,this.pleaseRotate=null,this.canvas_container=null,this.renderer=null,this.stereoEffect=null,this.noSleep=null,this.scene=null,this.camera=null,this.mesh=null,this.raycaster=null,this.doControls=null,this.prop={needsUpdate:!0,isCubemap:void 0,position:{longitude:0,latitude:0},ready:!1,direction:null,anim_speed:0,zoom_lvl:0,vFov:0,hFov:0,aspect:0,move_speed:.1,moving:!1,zooming:!1,start_mouse_x:0,start_mouse_y:0,mouse_x:0,mouse_y:0,mouse_history:[],gyro_alpha_offset:0,pinch_dist:0,main_reqid:null,orientation_cb:null,autorotate_cb:null,animation_promise:null,loading_promise:null,start_timeout:null,dblclick_data:null,dblclick_timeout:null,cache:[],size:{width:0,height:0},pano_data:{full_width:0,full_height:0,cropped_width:0,cropped_height:0,cropped_x:0,cropped_y:0}},Object.keys(n.TEMPLATES).forEach(function(t){this.config.templates[t]||(this.config.templates[t]=n.TEMPLATES[t]),"string"==typeof this.config.templates[t]&&(this.config.templates[t]=o.template(this.config.templates[t]))},this),this.parent.photoSphereViewer=this,this.container=document.createElement("div"),this.container.classList.add("psv-container"),this.parent.appendChild(this.container),null!==this.config.size&&this._setViewerSize(this.config.size),this._onResize();var s=Math.round((this.config.default_fov-this.config.min_fov)/(this.config.max_fov-this.config.min_fov)*100);this.zoom(s-2*(s-50)),this.prop.move_speed=t.Math.degToRad(this.config.move_speed/n.SYSTEM.pixelRatio),this.rotate({longitude:this.config.default_long,latitude:this.config.default_lat}),this.loader=new a(this),this.loader.hide(),this.navbar=new h(this),this.navbar.hide(),this.hud=new r(this),this.hud.hide(),this.panel=new l(this),this.tooltip=new d(this.hud),this.notification=new c(this),this._bindEvents(),this.config.panorama&&this.setPanorama(this.config.panorama),this.once("render",function(){this.config.navbar&&(this.container.classList.add("psv-container--has-navbar"),this.navbar.show()),this.hud.show(),this.config.markers&&(this.config.markers.forEach(function(t){this.hud.addMarker(t,!1)},this),this.hud.renderMarkers()),!1!==this.config.time_anim&&(this.prop.start_timeout=window.setTimeout(this.startAutorotate.bind(this),this.config.time_anim)),setTimeout(function(){this._run(),this.trigger("ready")}.bind(this),0)}.bind(this)),n.SYSTEM.touchEnabled.then(function(){this.container.classList.add("psv-is-touch")}.bind(this))}i.mixin(n),n.prototype._run=function(t){this.trigger("before-render",t||+new Date),this.prop.needsUpdate&&(this._render(),this.prop.needsUpdate=!1),this.prop.main_reqid=window.requestAnimationFrame(this._run.bind(this))},n.prototype._render=function(){this.prop.direction=this.sphericalCoordsToVector3(this.prop.position),this.camera.position.set(0,0,0),this.camera.lookAt(this.prop.direction),this.config.fisheye&&this.camera.position.copy(this.prop.direction).multiplyScalar(this.config.fisheye/2).negate(),this.camera.aspect=this.prop.aspect,this.camera.fov=this.prop.vFov,this.camera.updateProjectionMatrix(),(this.stereoEffect||this.renderer).render(this.scene,this.camera),this.trigger("render")},n.prototype._loadXMP=function(t){if(!this.config.usexmpdata)return e.resolved(null);var i=e(),o=new XMLHttpRequest;this.config.with_credentials&&(o.withCredentials=!0);var n=0;return o.onreadystatechange=function(){if(4===o.readyState){if(200!==o.status&&201!==o.status&&202!==o.status&&0!==o.status)throw this.container.textContent="Cannot load image",new E("Cannot load image");this.loader.setProgress(100);var t=o.responseText,e=t.indexOf("<x:xmpmeta"),s=t.indexOf("</x:xmpmeta>"),r=t.substring(e,s);if(-1===e||-1===s||-1===r.indexOf("GPano:"))i.resolve(null);else{var a={full_width:parseInt(x.getXMPValue(r,"FullPanoWidthPixels")),full_height:parseInt(x.getXMPValue(r,"FullPanoHeightPixels")),cropped_width:parseInt(x.getXMPValue(r,"CroppedAreaImageWidthPixels")),cropped_height:parseInt(x.getXMPValue(r,"CroppedAreaImageHeightPixels")),cropped_x:parseInt(x.getXMPValue(r,"CroppedAreaLeftPixels")),cropped_y:parseInt(x.getXMPValue(r,"CroppedAreaTopPixels"))};a.full_width&&a.full_height&&a.cropped_width&&a.cropped_height?i.resolve(a):(console.warn("PhotoSphereViewer: invalid XMP data"),i.resolve(null))}}else 3===o.readyState&&this.loader.setProgress(n+=10)}.bind(this),o.onprogress=function(t){if(t.lengthComputable){var e=parseInt(t.loaded/t.total*100);e>n&&(n=e,this.loader.setProgress(n))}}.bind(this),o.onerror=function(){throw this.container.textContent="Cannot load image",new E("Cannot load image")}.bind(this),o.open("GET",t,!0),o.send(null),i.promise},n.prototype._loadTexture=function(t){var e=[];if(Array.isArray(t)){if(6!==t.length)throw new E("Must provide exactly 6 image paths when using cubemap.");for(var i=0;i<6;i++)e[i]=t[n.CUBE_MAP[i]];t=e}else if("object"==typeof t){if(!n.CUBE_HASHMAP.every(function(e){return!!t[e]}))throw new E("Must provide exactly left, front, right, back, top, bottom when using cubemap.");n.CUBE_HASHMAP.forEach(function(i,o){e[o]=t[i]}),t=e}if(Array.isArray(t)){if(!1===this.prop.isCubemap)throw new E("The viewer was initialized with an equirectangular panorama, cannot switch to cubemap.");return this.config.fisheye&&console.warn("PhotoSphereViewer: fisheye effect with cubemap texture can generate distorsions."),this.config.cache_texture===n.DEFAULTS.cache_texture&&(this.config.cache_texture*=6),this.prop.isCubemap=!0,this._loadCubemapTexture(t)}if(!0===this.prop.isCubemap)throw new E("The viewer was initialized with an cubemap, cannot switch to equirectangular panorama.");return this.prop.isCubemap=!1,this._loadEquirectangularTexture(t)},n.prototype._loadEquirectangularTexture=function(i){if(this.config.cache_texture){var o=this.getPanoramaCache(i);if(o)return this.prop.pano_data=o.pano_data,e.resolved(o.image)}return this._loadXMP(i).then(function(o){var s=e(),r=new t.ImageLoader,a=o?100:0;this.config.with_credentials?r.setCrossOrigin("use-credentials"):r.setCrossOrigin("anonymous");return r.load(i,function(e){a=100,this.loader.setProgress(a),this.trigger("panorama-load-progress",i,a),!o&&this.config.pano_data&&(o=x.clone(this.config.pano_data)),o||(o={full_width:e.width,full_height:e.height,cropped_width:e.width,cropped_height:e.height,cropped_x:0,cropped_y:0}),this.prop.pano_data=o;var r,h=Math.min(o.full_width,n.SYSTEM.maxTextureWidth)/o.full_width;if(1!==h||o.cropped_width!==o.full_width||o.cropped_height!==o.full_height){var p=x.clone(o);p.full_width*=h,p.full_height*=h,p.cropped_width*=h,p.cropped_height*=h,p.cropped_x*=h,p.cropped_y*=h,e.width=p.cropped_width,e.height=p.cropped_height;var c=document.createElement("canvas");c.width=p.full_width,c.height=p.full_height,c.getContext("2d").drawImage(e,p.cropped_x,p.cropped_y,p.cropped_width,p.cropped_height),r=new t.Texture(c)}else r=new t.Texture(e);r.needsUpdate=!0,r.minFilter=t.LinearFilter,r.generateMipmaps=!1,this.config.cache_texture&&this._putPanoramaCache({panorama:i,image:r,pano_data:o}),s.resolve(r)}.bind(this),function(t){if(t.lengthComputable){var e=parseInt(t.loaded/t.total*100);e>a&&(a=e,this.loader.setProgress(a),this.trigger("panorama-load-progress",i,a))}}.bind(this),function(t){throw this.container.textContent="Cannot load image",s.reject(t),new E("Cannot load image")}.bind(this)),s.promise}.bind(this))},n.prototype._loadCubemapTexture=function(i){var o=e(),s=new t.ImageLoader,r=[0,0,0,0,0,0],a=[],h=0;this.config.with_credentials?s.setCrossOrigin("use-credentials"):s.setCrossOrigin("anonymous");for(var p=function(e,s){h++,r[e]=100,this.loader.setProgress(x.sum(r)/6),this.trigger("panorama-load-progress",i[e],r[e]);var p=Math.min(s.width,n.SYSTEM.maxTextureWidth/2)/s.width;if(1!==p){var c=document.createElement("canvas");c.width=s.width*p,c.height=s.height*p;c.getContext("2d").drawImage(s,0,0,c.width,c.height),a[e]=new t.Texture(c)}else a[e]=new t.Texture(s);this.config.cache_texture&&this._putPanoramaCache({panorama:i[e],image:a[e]}),6===h&&(a.forEach(function(e){e.needsUpdate=!0,e.minFilter=t.LinearFilter,e.generateMipmaps=!1}),o.resolve(a))},c=function(t,e){if(e.lengthComputable){var o=parseInt(e.loaded/e.total*100);o>r[t]&&(r[t]=o,this.loader.setProgress(x.sum(r)/6),this.trigger("panorama-load-progress",i[t],r[t]))}},l=function(t,e){throw this.container.textContent="Cannot load image",o.reject(e),new E("Cannot load image "+t)},u=0;u<6;u++){if(this.config.cache_texture){var d=this.getPanoramaCache(i[u]);if(d){h++,r[u]=100,a[u]=d.image;continue}}s.load(i[u],p.bind(this,u),c.bind(this,u),l.bind(this,u))}return 6===h&&o.resolve(a),o.promise},n.prototype._setTexture=function(t){if(this.scene||this._createScene(),this.prop.isCubemap)for(var e=0;e<6;e++)this.mesh.material[e].map&&this.mesh.material[e].map.dispose(),this.mesh.material[e].map=t[e];else this.mesh.material.map&&this.mesh.material.map.dispose(),this.mesh.material.map=t;this.trigger("panorama-loaded"),this._render()},n.prototype._createScene=function(){this.raycaster=new t.Raycaster,this.renderer=n.SYSTEM.isWebGLSupported&&this.config.webgl?new t.WebGLRenderer:new t.CanvasRenderer,this.renderer.setSize(this.prop.size.width,this.prop.size.height),this.renderer.setPixelRatio(n.SYSTEM.pixelRatio);var e=n.SPHERE_RADIUS;this.prop.isCubemap&&(e*=Math.sqrt(3)),this.config.fisheye&&(e+=n.SPHERE_RADIUS),this.camera=new t.PerspectiveCamera(this.config.default_fov,this.prop.size.width/this.prop.size.height,1,e),this.camera.position.set(0,0,0),this.scene=new t.Scene,this.scene.add(this.camera),this.prop.isCubemap?this.mesh=this._createCubemap():this.mesh=this._createSphere(),this.scene.add(this.mesh),this.canvas_container=document.createElement("div"),this.canvas_container.className="psv-canvas-container",this.renderer.domElement.className="psv-canvas",this.container.appendChild(this.canvas_container),this.canvas_container.appendChild(this.renderer.domElement)},n.prototype._createSphere=function(e){e=e||1;var i=new t.SphereGeometry(n.SPHERE_RADIUS*e,n.SPHERE_VERTICES,n.SPHERE_VERTICES,-x.HalfPI),o=new t.MeshBasicMaterial({side:t.DoubleSide,overdraw:n.SYSTEM.isWebGLSupported&&this.config.webgl?0:1}),s=new t.Mesh(i,o);return s.scale.x=-1,s.rotation.x=this.config.sphere_correction.tilt,s.rotation.y=this.config.sphere_correction.pan,s.rotation.z=this.config.sphere_correction.roll,s},n.prototype._createCubemap=function(e){e=e||1;for(var i=new t.BoxGeometry(2*n.SPHERE_RADIUS*e,2*n.SPHERE_RADIUS*e,2*n.SPHERE_RADIUS*e,n.CUBE_VERTICES,n.CUBE_VERTICES,n.CUBE_VERTICES),o=[],s=0;s<6;s++)o.push(new t.MeshBasicMaterial({side:t.BackSide,overdraw:n.SYSTEM.isWebGLSupported&&this.config.webgl?0:1}));var r=new t.Mesh(i,o);return r.position.x-=n.SPHERE_RADIUS*e,r.position.y-=n.SPHERE_RADIUS*e,r.position.z-=n.SPHERE_RADIUS*e,r.applyMatrix((new t.Matrix4).makeScale(1,1,-1)),r},n.prototype._transition=function(e,i){var o;if(this.prop.isCubemap?(i&&(console.warn("PhotoSphereViewer: cannot perform cubemap transition to different position."),i=void 0),(o=this._createCubemap(.9)).material.forEach(function(t,i){t.map=e[i],t.transparent=!0,t.opacity=0})):((o=this._createSphere(.9)).material.map=e,o.material.transparent=!0,o.material.opacity=0),i){o.rotateY(i.longitude-this.prop.position.longitude);var n=new t.Vector3(0,1,0).cross(this.camera.getWorldDirection()).normalize(),s=(new t.Quaternion).setFromAxisAngle(n,i.latitude-this.prop.position.latitude);o.quaternion.multiplyQuaternions(s,o.quaternion),(this.config.latitude_range||this.config.longitude_range)&&(this.config.longitude_range=this.config.latitude_range=null,console.warn("PhotoSphereViewer: trying to perform transition with longitude_range and/or latitude_range, ranges cleared."))}return this.scene.add(o),this.needsUpdate(),x.animation({properties:{opacity:{start:0,end:1}},duration:this.config.transition.duration,easing:"outCubic",onTick:function(t){if(this.prop.isCubemap)for(var e=0;e<6;e++)o.material[e].opacity=t.opacity;else o.material.opacity=t.opacity;this.needsUpdate()}.bind(this)}).then(function(){this._setTexture(e),this.scene.remove(o),o.geometry.dispose(),o.geometry=null,i&&this.rotate(i)}.bind(this))},n.prototype._reverseAutorotate=function(){var t=this,e=-this.config.anim_speed,i=this.config.longitude_range;this.config.longitude_range=null,x.animation({properties:{speed:{start:this.config.anim_speed,end:0}},duration:300,easing:"inSine",onTick:function(e){t.config.anim_speed=e.speed}}).then(function(){return x.animation({properties:{speed:{start:0,end:e}},duration:300,easing:"outSine",onTick:function(e){t.config.anim_speed=e.speed}})}).then(function(){t.config.longitude_range=i,t.config.anim_speed=e})},n.prototype._putPanoramaCache=function(t){if(!this.config.cache_texture)throw new E("Cannot add panorama to cache, cache_texture is disabled");var e=this.getPanoramaCache(t.panorama);e?(e.image=t.image,e.pano_data=t.pano_data):(this.prop.cache=this.prop.cache.slice(0,this.config.cache_texture-1),this.prop.cache.unshift(t)),this.trigger("panorama-cached",t.panorama)},n.prototype._stopAll=function(){this.stopAutorotate(),this.stopAnimation(),this.stopGyroscopeControl(),this.stopStereoView()},n.MOVE_THRESHOLD=4,n.ANGLE_THRESHOLD=.003,n.DBLCLICK_DELAY=300,n.INERTIA_WINDOW=300,n.SPHERE_RADIUS=100,n.SPHERE_VERTICES=64,n.CUBE_VERTICES=8,n.CUBE_MAP=[0,2,4,5,3,1],n.CUBE_HASHMAP=["left","right","top","bottom","back","front"],n.KEYMAP={33:"PageUp",34:"PageDown",37:"ArrowLeft",38:"ArrowUp",39:"ArrowRight",40:"ArrowDown",107:"+",109:"-"},n.SYSTEM={loaded:!1,pixelRatio:1,isWebGLSupported:!1,isCanvasSupported:!1,deviceOrientationSupported:null,maxTextureWidth:0,mouseWheelEvent:null,fullscreenEvent:null},n.ICONS={},n.DEFAULTS={panorama:null,container:null,caption:null,usexmpdata:!0,pano_data:null,webgl:!0,min_fov:30,max_fov:90,default_fov:null,default_long:0,default_lat:0,sphere_correction:{pan:0,tilt:0,roll:0},longitude_range:null,latitude_range:null,move_speed:1,zoom_speed:2,time_anim:2e3,anim_speed:"2rpm",anim_lat:null,fisheye:!1,navbar:["autorotate","zoom","download","markers","caption","gyroscope","stereo","fullscreen"],tooltip:{offset:5,arrow_size:7,delay:100},lang:{autorotate:"Automatic rotation",zoom:"Zoom",zoomOut:"Zoom out",zoomIn:"Zoom in",download:"Download",fullscreen:"Fullscreen",markers:"Markers",gyroscope:"Gyroscope",stereo:"Stereo view",stereo_notification:"Click anywhere to exit stereo view.",please_rotate:["Please rotate your device","(or tap to continue)"]},mousewheel:!0,mousewheel_factor:1,mousemove:!0,mousemove_hover:!1,keyboard:!0,move_inertia:!0,click_event_on_marker:!1,transition:{duration:1500,loader:!0},loading_img:null,loading_txt:"Loading...",size:null,cache_texture:0,templates:{},markers:[],with_credentials:!1},n.TEMPLATES={markersList:'<div class="psv-markers-list-container">   <h1 class="psv-markers-list-title">{{= it.config.lang.markers }}</h1>   <ul class="psv-markers-list">   {{~ it.markers: marker }}     <li data-psv-marker="{{= marker.id }}" class="psv-markers-list-item {{? marker.className }}{{= marker.className }}{{?}}">       {{? marker.image }}<img class="psv-markers-list-image" src="{{= marker.image }}"/>{{?}}       <p class="psv-markers-list-name">{{? marker.tooltip }}{{= marker.tooltip.content }}{{?? marker.html }}{{= marker.html }}{{??}}{{= marker.id }}{{?}}</p>     </li>   {{~}}   </ul> </div>'},n.prototype._bindEvents=function(){window.addEventListener("resize",this),this.config.mousemove&&(this.hud.container.style.cursor="move",this.config.mousemove_hover?(this.hud.container.addEventListener("mouseenter",this),this.hud.container.addEventListener("mouseleave",this)):(this.hud.container.addEventListener("mousedown",this),window.addEventListener("mouseup",this)),this.hud.container.addEventListener("touchstart",this),window.addEventListener("touchend",this),this.hud.container.addEventListener("mousemove",this),this.hud.container.addEventListener("touchmove",this)),n.SYSTEM.fullscreenEvent&&document.addEventListener(n.SYSTEM.fullscreenEvent,this),this.config.mousewheel&&this.hud.container.addEventListener(n.SYSTEM.mouseWheelEvent,this),this.on("_side-reached",function(t){this.isAutorotateEnabled()&&("left"!==t&&"right"!==t||this._reverseAutorotate())})},n.prototype._unbindEvents=function(){window.removeEventListener("resize",this),this.config.mousemove&&(this.hud.container.removeEventListener("mousedown",this),this.hud.container.removeEventListener("mouseenter",this),this.hud.container.removeEventListener("touchstart",this),window.removeEventListener("mouseup",this),window.removeEventListener("touchend",this),this.hud.container.removeEventListener("mouseleave",this),this.hud.container.removeEventListener("mousemove",this),this.hud.container.removeEventListener("touchmove",this)),n.SYSTEM.fullscreenEvent&&document.removeEventListener(n.SYSTEM.fullscreenEvent,this),this.config.mousewheel&&this.hud.container.removeEventListener(n.SYSTEM.mouseWheelEvent,this),this.off("_side-reached")},n.prototype.handleEvent=function(t){switch(t.type){case"resize":x.throttle(this._onResize(),50);break;case"keydown":this._onKeyDown(t);break;case"mousedown":case"mouseenter":this._onMouseDown(t);break;case"touchstart":this._onTouchStart(t);break;case"mouseup":case"mouseleave":this._onMouseUp(t);break;case"touchend":this._onTouchEnd(t);break;case"mousemove":this._onMouseMove(t);break;case"touchmove":this._onTouchMove(t);break;case n.SYSTEM.fullscreenEvent:this._fullscreenToggled();break;case n.SYSTEM.mouseWheelEvent:this._onMouseWheel(t)}},n.prototype._onResize=function(){this.container.clientWidth===this.prop.size.width&&this.container.clientHeight===this.prop.size.height||(this.prop.size.width=parseInt(this.container.clientWidth),this.prop.size.height=parseInt(this.container.clientHeight),this.prop.aspect=this.prop.size.width/this.prop.size.height,this.needsUpdate(),this.renderer&&(this.stereoEffect||this.renderer).setSize(this.prop.size.width,this.prop.size.height),this.trigger("size-updated",this.getSize()))},n.prototype._onKeyDown=function(t){var e=0,i=0,o=0;switch(t.key||n.KEYMAP[t.keyCode||t.which]){case"ArrowUp":i=.01;break;case"ArrowDown":i=-.01;break;case"ArrowRight":e=.01;break;case"ArrowLeft":e=-.01;break;case"PageUp":case"+":o=1;break;case"PageDown":case"-":o=-1}0!==o?this.zoom(this.prop.zoom_lvl+o*this.config.zoom_speed):0===i&&0===e||this.rotate({longitude:this.prop.position.longitude+e*this.prop.move_speed*this.prop.hFov,latitude:this.prop.position.latitude+i*this.prop.move_speed*this.prop.vFov})},n.prototype._onMouseDown=function(t){this._startMove(t)},n.prototype._onMouseUp=function(t){this._stopMove(t),this.isStereoEnabled()&&this.stopStereoView()},n.prototype._onMouseMove=function(t){0!==t.buttons?(t.preventDefault(),this._move(t)):this.config.mousemove_hover&&this._moveAbsolute(t)},n.prototype._onTouchStart=function(t){1===t.touches.length?this._startMove(t.touches[0]):2===t.touches.length&&this._startZoom(t)},n.prototype._onTouchEnd=function(t){this._stopMove(t.changedTouches[0])},n.prototype._onTouchMove=function(t){1===t.touches.length?(t.preventDefault(),this._move(t.touches[0])):2===t.touches.length&&(t.preventDefault(),this._zoom(t))},n.prototype._startMove=function(t){this.stopAutorotate(),this.stopAnimation(),this.prop.mouse_x=this.prop.start_mouse_x=parseInt(t.clientX),this.prop.mouse_y=this.prop.start_mouse_y=parseInt(t.clientY),this.prop.moving=!0,this.prop.zooming=!1,this.prop.mouse_history.length=0,this._logMouseMove(t)},n.prototype._startZoom=function(t){var e=[{x:parseInt(t.touches[0].clientX),y:parseInt(t.touches[0].clientY)},{x:parseInt(t.touches[1].clientX),y:parseInt(t.touches[1].clientY)}];this.prop.pinch_dist=Math.sqrt(Math.pow(e[0].x-e[1].x,2)+Math.pow(e[0].y-e[1].y,2)),this.prop.moving=!1,this.prop.zooming=!0},n.prototype._stopMove=function(t){x.getClosest(t.target,".psv-hud")&&(this.prop.moving&&(Math.abs(t.clientX-this.prop.start_mouse_x)<n.MOVE_THRESHOLD&&Math.abs(t.clientY-this.prop.start_mouse_y)<n.MOVE_THRESHOLD?(this._click(t),this.prop.moving=!1):this.config.move_inertia&&!this.isGyroscopeEnabled()?(this._logMouseMove(t),this._stopMoveInertia(t)):this.prop.moving=!1,this.prop.mouse_history.length=0),this.prop.zooming=!1)},n.prototype._stopMoveInertia=function(t){var e=t.clientX-this.prop.mouse_history[0][1],i=t.clientY-this.prop.mouse_history[0][2],o=Math.sqrt(e*e+i*i);this.prop.animation_promise=x.animation({properties:{clientX:{start:t.clientX,end:t.clientX+e},clientY:{start:t.clientY,end:t.clientY+i}},duration:o*n.INERTIA_WINDOW/100,easing:"outCirc",onTick:function(t){this._move(t,!1)}.bind(this)}).ensure(function(){this.prop.moving=!1}.bind(this))},n.prototype._click=function(t){var e=this.container.getBoundingClientRect(),i={target:t.target,client_x:t.clientX,client_y:t.clientY,viewer_x:parseInt(t.clientX-e.left),viewer_y:parseInt(t.clientY-e.top)},o=this.viewerCoordsToVector3({x:i.viewer_x,y:i.viewer_y});if(o){var s=this.vector3ToSphericalCoords(o);if(i.longitude=s.longitude,i.latitude=s.latitude,!this.prop.isCubemap){var r=this.sphericalCoordsToTextureCoords({longitude:i.longitude,latitude:i.latitude});i.texture_x=r.x,i.texture_y=r.y}this.prop.dblclick_timeout?(Math.abs(this.prop.dblclick_data.client_x-i.client_x)<n.MOVE_THRESHOLD&&Math.abs(this.prop.dblclick_data.client_y-i.client_y)<n.MOVE_THRESHOLD&&this.trigger("dblclick",this.prop.dblclick_data),clearTimeout(this.prop.dblclick_timeout),this.prop.dblclick_timeout=null,this.prop.dblclick_data=null):(this.trigger("click",i),this.prop.dblclick_data=x.clone(i),this.prop.dblclick_timeout=setTimeout(function(){this.prop.dblclick_timeout=null,this.prop.dblclick_data=null}.bind(this),n.DBLCLICK_DELAY))}},n.prototype._move=function(t,e){if(this.prop.moving){var i=parseInt(t.clientX),o=parseInt(t.clientY),s=(i-this.prop.mouse_x)/this.prop.size.width*this.prop.move_speed*this.prop.hFov*n.SYSTEM.pixelRatio,r=(o-this.prop.mouse_y)/this.prop.size.height*this.prop.move_speed*this.prop.vFov*n.SYSTEM.pixelRatio;this.isGyroscopeEnabled()?this.prop.gyro_alpha_offset+=s:this.rotate({longitude:this.prop.position.longitude-s,latitude:this.prop.position.latitude+r}),this.prop.mouse_x=i,this.prop.mouse_y=o,!1!==e&&this._logMouseMove(t)}},n.prototype._moveAbsolute=function(t){this.prop.moving&&this.rotate({longitude:((t.clientX-this.container.offsetLeft)/this.container.offsetWidth-.5)*x.TwoPI,latitude:-((t.clientY-this.container.offsetTop)/this.container.offsetHeight-.5)*Math.PI})},n.prototype._zoom=function(t){if(this.prop.zooming){var e=[{x:parseInt(t.touches[0].clientX),y:parseInt(t.touches[0].clientY)},{x:parseInt(t.touches[1].clientX),y:parseInt(t.touches[1].clientY)}],i=Math.sqrt(Math.pow(e[0].x-e[1].x,2)+Math.pow(e[0].y-e[1].y,2)),o=80*(i-this.prop.pinch_dist)/this.prop.size.width;this.zoom(this.prop.zoom_lvl+o),this.prop.pinch_dist=i}},n.prototype._onMouseWheel=function(t){t.preventDefault(),t.stopPropagation();var e=5*x.normalizeWheel(t).spinY;0!==e&&this.zoom(this.prop.zoom_lvl-e*this.config.mousewheel_factor)},n.prototype._fullscreenToggled=function(){var t=this.isFullscreenEnabled();this.config.keyboard&&(t?this.startKeyboardControl():this.stopKeyboardControl()),this.trigger("fullscreen-updated",t)},n.prototype._logMouseMove=function(t){var e=Date.now();this.prop.mouse_history.push([e,t.clientX,t.clientY]);for(var i=null,o=0;o<this.prop.mouse_history.length;)this.prop.mouse_history[0][o]<e-n.INERTIA_WINDOW?this.prop.mouse_history.splice(o,1):i&&this.prop.mouse_history[0][o]-i>n.INERTIA_WINDOW/10?(this.prop.mouse_history.splice(0,o),o=0,i=this.prop.mouse_history[0][o]):(o++,i=this.prop.mouse_history[0][o])},n.prototype.load=function(){if(!this.config.panorama)throw new E("No value given for panorama.");return this.setPanorama(this.config.panorama,!1)},n.prototype.getPosition=function(){return{longitude:this.prop.position.longitude,latitude:this.prop.position.latitude}},n.prototype.getZoomLevel=function(){return this.prop.zoom_lvl},n.prototype.getSize=function(){return{width:this.prop.size.width,height:this.prop.size.height}},n.prototype.isAutorotateEnabled=function(){return!!this.prop.autorotate_cb},n.prototype.isGyroscopeEnabled=function(){return!!this.prop.orientation_cb},n.prototype.isStereoEnabled=function(){return!!this.stereoEffect},n.prototype.isFullscreenEnabled=function(){return x.isFullscreenEnabled(this.container)},n.prototype.needsUpdate=function(){this.prop.needsUpdate=!0},n.prototype.render=function(){this._render()},n.prototype.destroy=function(){window.cancelAnimationFrame(this.prop.main_reqid),this._stopAll(),this.stopKeyboardControl(),this.stopNoSleep(),this.exitFullscreen(),this.unlockOrientation(),this._unbindEvents(),this.tooltip&&this.tooltip.destroy(),this.notification&&this.notification.destroy(),this.hud&&this.hud.destroy(),this.loader&&this.loader.destroy(),this.navbar&&this.navbar.destroy(),this.panel&&this.panel.destroy(),this.pleaseRotate&&this.pleaseRotate.destroy(),this.scene&&x.cleanTHREEScene(this.scene),this.canvas_container&&this.container.removeChild(this.canvas_container),this.parent.removeChild(this.container),delete this.parent.photoSphereViewer,delete this.parent,delete this.container,delete this.loader,delete this.navbar,delete this.hud,delete this.panel,delete this.tooltip,delete this.notification,delete this.pleaseRotate,delete this.canvas_container,delete this.renderer,delete this.noSleep,delete this.scene,delete this.camera,delete this.mesh,delete this.raycaster,delete this.passes,delete this.config,this.prop.cache.length=0},n.prototype.setPanorama=function(t,e,i){if(null!==this.prop.loading_promise)throw new E("Loading already in progress");return"boolean"==typeof e&&(i=e,e=void 0),e&&(this.cleanPosition(e),this._stopAll()),this.config.panorama=t,i&&this.config.transition&&this.scene?(this.config.transition.loader&&this.loader.show(),this.prop.loading_promise=this._loadTexture(this.config.panorama).then(function(t){return this.loader.hide(),this._transition(t,e)}.bind(this)).ensure(function(){this.loader.hide(),this.prop.loading_promise=null}.bind(this)).rethrow()):(this.loader.show(),this.canvas_container&&(this.canvas_container.style.opacity=0),this.prop.loading_promise=this._loadTexture(this.config.panorama).then(function(t){this._setTexture(t),e&&this.rotate(e)}.bind(this)).ensure(function(){this.loader.hide(),this.canvas_container.style.opacity=1,this.prop.loading_promise=null}.bind(this)).rethrow()),this.prop.loading_promise},n.prototype.startAutorotate=function(){this._stopAll(),this.prop.autorotate_cb=this._getAutorotateUpdate(),this.on("before-render",this.prop.autorotate_cb),this.trigger("autorotate",!0)},n.prototype._getAutorotateUpdate=function(){var t,e;return function(i){e=void 0===t?0:i-t,t=i,this.rotate({longitude:this.prop.position.longitude+this.config.anim_speed*e/1e3,latitude:this.prop.position.latitude-(this.prop.position.latitude-this.config.anim_lat)/200})}},n.prototype.stopAutorotate=function(){this.prop.start_timeout&&(window.clearTimeout(this.prop.start_timeout),this.prop.start_timeout=null),this.isAutorotateEnabled()&&(this.off("before-render",this.prop.autorotate_cb),this.prop.autorotate_cb=null,this.trigger("autorotate",!1))},n.prototype.toggleAutorotate=function(){this.isAutorotateEnabled()?this.stopAutorotate():this.startAutorotate()},n.prototype.startGyroscopeControl=function(){if(x.checkTHREE("DeviceOrientationControls"))return n.SYSTEM.deviceOrientationSupported.then(function(){this._stopAll(),this.doControls=new t.DeviceOrientationControls(this.camera),this.doControls.alphaOffset=this.prop.position.longitude,this.doControls.update();var e=this.camera.getWorldDirection(new t.Vector3),i=this.vector3ToSphericalCoords(e);this.prop.gyro_alpha_offset=i.longitude,this.prop.orientation_cb=this._getOrientationUpdate(),this.on("before-render",this.prop.orientation_cb),this.trigger("gyroscope-updated",!0)}.bind(this),function(){return console.warn("PhotoSphereViewer: gyroscope not available"),e.rejected()});throw new E("Missing Three.js components: DeviceOrientationControls. Get them from three.js-examples package.")},n.prototype._getOrientationUpdate=function(){return function(){this.doControls.alphaOffset=this.prop.gyro_alpha_offset,this.doControls.update(),this.camera.getWorldDirection(this.prop.direction),this.prop.direction.multiplyScalar(n.SPHERE_RADIUS);var t=this.vector3ToSphericalCoords(this.prop.direction);this.prop.position.longitude=t.longitude,this.prop.position.latitude=t.latitude,this.needsUpdate()}},n.prototype.stopGyroscopeControl=function(){this.isGyroscopeEnabled()&&(this.off("before-render",this.prop.orientation_cb),this.prop.orientation_cb=null,this.doControls.disconnect(),this.doControls=null,this.trigger("gyroscope-updated",!1))},n.prototype.toggleGyroscopeControl=function(){this.isGyroscopeEnabled()?this.stopGyroscopeControl():this.startGyroscopeControl()},n.prototype.startNoSleep=function(){"NoSleep"in window?(this.noSleep||(this.noSleep=new NoSleep),this.noSleep.enable()):console.warn("PhotoSphereViewer: NoSleep is not available")},n.prototype.stopNoSleep=function(){this.noSleep&&this.noSleep.disable()},n.prototype.startStereoView=function(){if(!x.checkTHREE("DeviceOrientationControls","StereoEffect"))throw new E("Missing Three.js components: StereoEffect, DeviceOrientationControls. Get them from three.js-examples package.");this.startNoSleep(),this.enterFullscreen(),this.lockOrientation(),this.startGyroscopeControl().then(function(){this.stereoEffect=new t.StereoEffect(this.renderer),this.needsUpdate(),this.hud.hide(),this.navbar.hide(),this.panel.hidePanel(),this.trigger("stereo-updated",!0),this.notification.showNotification({content:this.config.lang.stereo_notification,timeout:3e3})}.bind(this),function(){this.unlockOrientation(),this.exitFullscreen(),this.stopNoSleep()}.bind(this))},n.prototype.stopStereoView=function(){this.isStereoEnabled()&&(this.stereoEffect=null,this.needsUpdate(),this.hud.show(),this.navbar.show(),this.unlockOrientation(),this.exitFullscreen(),this.stopNoSleep(),this.stopGyroscopeControl(),this.trigger("stereo-updated",!1))},n.prototype.lockOrientation=function(){var t=function(){window.innerHeight>window.innerWidth&&(this.pleaseRotate||(this.pleaseRotate=new u(this)),this.pleaseRotate.show())};window.screen&&window.screen.orientation?window.screen.orientation.lock("landscape").then(null,t.bind(this)):t.apply(this)},n.prototype.unlockOrientation=function(){window.screen&&window.screen.orientation?window.screen.orientation.unlock():this.pleaseRotate&&this.pleaseRotate.hide()},n.prototype.toggleStereoView=function(){this.isStereoEnabled()?this.stopStereoView():this.startStereoView()},n.prototype.rotate=function(t){this.cleanPosition(t),this.applyRanges(t).forEach(this.trigger.bind(this,"_side-reached")),this.prop.position.longitude=t.longitude,this.prop.position.latitude=t.latitude,this.needsUpdate(),this.trigger("position-updated",this.getPosition())},n.prototype.animate=function(t,i){if(this._stopAll(),this.cleanPosition(t),!i||Math.abs(t.longitude-this.prop.position.longitude)<n.ANGLE_THRESHOLD&&Math.abs(t.latitude-this.prop.position.latitude)<n.ANGLE_THRESHOLD)return this.rotate(t),e.resolved();if(this.applyRanges(t).forEach(this.trigger.bind(this,"_side-reached")),!i&&"number"!=typeof i){i=i?x.parseSpeed(i):this.config.anim_speed;i=Math.acos(Math.cos(this.prop.position.latitude)*Math.cos(t.latitude)*Math.cos(this.prop.position.longitude-t.longitude)+Math.sin(this.prop.position.latitude)*Math.sin(t.latitude))/i*1e3}var o=x.getShortestArc(this.prop.position.longitude,t.longitude);return this.prop.animation_promise=x.animation({properties:{longitude:{start:this.prop.position.longitude,end:this.prop.position.longitude+o},latitude:{start:this.prop.position.latitude,end:t.latitude}},duration:i,easing:"inOutSine",onTick:this.rotate.bind(this)}),this.prop.animation_promise},n.prototype.stopAnimation=function(){this.prop.animation_promise&&(this.prop.animation_promise.cancel(),this.prop.animation_promise=null)},n.prototype.zoom=function(e){this.prop.zoom_lvl=x.bound(Math.round(e),0,100),this.prop.vFov=this.config.max_fov+this.prop.zoom_lvl/100*(this.config.min_fov-this.config.max_fov),this.prop.hFov=t.Math.radToDeg(2*Math.atan(Math.tan(t.Math.degToRad(this.prop.vFov)/2)*this.prop.aspect)),this.needsUpdate(),this.trigger("zoom-updated",this.getZoomLevel())},n.prototype.zoomIn=function(){this.prop.zoom_lvl<100&&this.zoom(this.prop.zoom_lvl+this.config.zoom_speed)},n.prototype.zoomOut=function(){this.prop.zoom_lvl>0&&this.zoom(this.prop.zoom_lvl-this.config.zoom_speed)},n.prototype.resize=function(t){t.width&&(this.container.style.width=t.width),t.height&&(this.container.style.height=t.height),this._onResize()},n.prototype.enterFullscreen=function(){x.requestFullscreen(this.container)},n.prototype.exitFullscreen=function(){x.exitFullscreen()},n.prototype.toggleFullscreen=function(){this.isFullscreenEnabled()?this.exitFullscreen():this.enterFullscreen()},n.prototype.startKeyboardControl=function(){window.addEventListener("keydown",this)},n.prototype.stopKeyboardControl=function(){window.removeEventListener("keydown",this)},n.prototype.preloadPanorama=function(t){if(!this.config.cache_texture)throw new E("Cannot preload panorama, cache_texture is disabled");return this._loadTexture(t)},n.prototype.clearPanoramaCache=function(t){if(!this.config.cache_texture)throw new E("Cannot clear cache, cache_texture is disabled");if(t){for(var e=0,i=this.prop.cache.length;e<i;e++)if(this.prop.cache[e].panorama===t){this.prop.cache.splice(e,1);break}}else this.prop.cache.length=0},n.prototype.getPanoramaCache=function(t){if(!this.config.cache_texture)throw new E("Cannot query cache, cache_texture is disabled");return this.prop.cache.filter(function(e){return e.panorama===t}).shift()},n._loadSystem=function(){var t=n.SYSTEM;t.loaded=!0,t.pixelRatio=window.devicePixelRatio||1,t.isWebGLSupported=x.isWebGLSupported(),t.isCanvasSupported=x.isCanvasSupported(),t.maxTextureWidth=t.isWebGLSupported?x.getMaxTextureWidth():4096,t.mouseWheelEvent=x.mouseWheelEvent(),t.fullscreenEvent=x.fullscreenEvent(),t.deviceOrientationSupported=x.isDeviceOrientationSupported(),t.touchEnabled=x.isTouchEnabled()},n.prototype._setViewerSize=function(t){["width","height"].forEach(function(e){t[e]&&(/^[0-9.]+$/.test(t[e])&&(t[e]+="px"),this.parent.style[e]=t[e])},this)},n.prototype.textureCoordsToSphericalCoords=function(t){if(this.prop.isCubemap)throw new E("Unable to use texture coords with cubemap.");var e=(t.x+this.prop.pano_data.cropped_x)/this.prop.pano_data.full_width*x.TwoPI,i=(t.y+this.prop.pano_data.cropped_y)/this.prop.pano_data.full_height*Math.PI;return{longitude:e>=Math.PI?e-Math.PI:e+Math.PI,latitude:x.HalfPI-i}},n.prototype.sphericalCoordsToTextureCoords=function(t){if(this.prop.isCubemap)throw new E("Unable to use texture coords with cubemap.");var e=t.longitude/x.TwoPI*this.prop.pano_data.full_width,i=t.latitude/Math.PI*this.prop.pano_data.full_height;return{x:parseInt(t.longitude<Math.PI?e+this.prop.pano_data.full_width/2:e-this.prop.pano_data.full_width/2)-this.prop.pano_data.cropped_x,y:parseInt(this.prop.pano_data.full_height/2-i)-this.prop.pano_data.cropped_y}},n.prototype.sphericalCoordsToVector3=function(e){return new t.Vector3(n.SPHERE_RADIUS*-Math.cos(e.latitude)*Math.sin(e.longitude),n.SPHERE_RADIUS*Math.sin(e.latitude),n.SPHERE_RADIUS*Math.cos(e.latitude)*Math.cos(e.longitude))},n.prototype.vector3ToSphericalCoords=function(t){var e=Math.acos(t.y/Math.sqrt(t.x*t.x+t.y*t.y+t.z*t.z)),i=Math.atan2(t.x,t.z);return{longitude:i<0?-i:x.TwoPI-i,latitude:x.HalfPI-e}},n.prototype.viewerCoordsToVector3=function(e){var i=new t.Vector2(2*e.x/this.prop.size.width-1,-2*e.y/this.prop.size.height+1);this.raycaster.setFromCamera(i,this.camera);var o=this.raycaster.intersectObjects(this.scene.children);return 1===o.length?o[0].point:null},n.prototype.vector3ToViewerCoords=function(t){return(t=t.clone()).project(this.camera),{x:parseInt((t.x+1)/2*this.prop.size.width),y:parseInt((1-t.y)/2*this.prop.size.height)}},n.prototype.cleanPosition=function(t){t.hasOwnProperty("x")&&t.hasOwnProperty("y")&&x.deepmerge(t,this.textureCoordsToSphericalCoords(t)),t.longitude=x.parseAngle(t.longitude),t.latitude=x.parseAngle(t.latitude,!0)},n.prototype.applyRanges=function(e){var i,o,n=[];return this.config.longitude_range&&(i=x.clone(this.config.longitude_range),o=t.Math.degToRad(this.prop.hFov)/2,i[0]=x.parseAngle(i[0]+o),i[1]=x.parseAngle(i[1]-o),i[0]>i[1]?e.longitude>i[1]&&e.longitude<i[0]&&(e.longitude>i[0]/2+i[1]/2?(e.longitude=i[0],n.push("left")):(e.longitude=i[1],n.push("right"))):e.longitude<i[0]?(e.longitude=i[0],n.push("left")):e.longitude>i[1]&&(e.longitude=i[1],n.push("right"))),this.config.latitude_range&&(i=x.clone(this.config.latitude_range),o=t.Math.degToRad(this.prop.vFov)/2,i[0]=x.parseAngle(Math.min(i[0]+o,i[1]),!0),i[1]=x.parseAngle(Math.max(i[1]-o,i[0]),!0),e.latitude<i[0]?(e.latitude=i[0],n.push("bottom")):e.latitude>i[1]&&(e.latitude=i[1],n.push("top"))),n};function s(t){this.psv=t instanceof n?t:t.psv,this.parent=t,this.container=null,this.visible=!0,this.constructor.publicMethods&&this.constructor.publicMethods.forEach(function(t){this.psv[t]=this[t].bind(this)},this)}s.className=null,s.publicMethods=[],s.prototype.create=function(){this.container=document.createElement("div"),this.constructor.className&&(this.container.className=this.constructor.className),this.parent.container.appendChild(this.container)},s.prototype.destroy=function(){this.parent.container.removeChild(this.container),this.constructor.publicMethods&&this.constructor.publicMethods.forEach(function(t){delete this.psv[t]},this),delete this.container,delete this.psv,delete this.parent},s.prototype.hide=function(){this.container.style.display="none",this.visible=!1},s.prototype.show=function(){this.container.style.display="",this.visible=!0};function r(t){s.call(this,t),this.svgContainer=null,this.markers={},this.currentMarker=null,this.hoveringMarker=null,this.prop={panelOpened:!1,panelOpening:!1,markersButton:this.psv.navbar.getNavbarButton("markers",!0)},this.create()}r.prototype=Object.create(s.prototype),r.prototype.constructor=r,r.className="psv-hud",r.publicMethods=["addMarker","removeMarker","updateMarker","clearMarkers","getMarker","getCurrentMarker","gotoMarker","hideMarker","showMarker","toggleMarker","toggleMarkersList","showMarkersList","hideMarkersList"],r.prototype.create=function(){s.prototype.create.call(this),this.svgContainer=document.createElementNS(x.svgNS,"svg"),this.svgContainer.setAttribute("class","psv-hud-svg-container"),this.container.appendChild(this.svgContainer),this.container.addEventListener("mouseenter",this,!0),this.container.addEventListener("mouseleave",this,!0),this.container.addEventListener("mousemove",this,!0),this.psv.on("click",this),this.psv.on("dblclick",this),this.psv.on("render",this),this.psv.on("open-panel",this),this.psv.on("close-panel",this)},r.prototype.destroy=function(){this.clearMarkers(!1),this.container.removeEventListener("mouseenter",this),this.container.removeEventListener("mouseleave",this),this.container.removeEventListener("mousemove",this),this.psv.off("click",this),this.psv.off("dblclick",this),this.psv.off("render",this),this.psv.off("open-panel",this),this.psv.off("close-panel",this),delete this.svgContainer,s.prototype.destroy.call(this)},r.prototype.handleEvent=function(t){switch(t.type){case"mouseenter":this._onMouseEnter(t);break;case"mouseleave":this._onMouseLeave(t);break;case"mousemove":this._onMouseMove(t);break;case"click":this._onClick(t.args[0],t,!1);break;case"dblclick":this._onClick(t.args[0],t,!0);break;case"render":this.renderMarkers();break;case"open-panel":this._onPanelOpened();break;case"close-panel":this._onPanelClosed()}},r.prototype.addMarker=function(t,e){if(!t.id)throw new E("missing marker id");if(this.markers[t.id])throw new E('marker "'+t.id+'" already exists');var i=new k(t,this.psv);return i.isNormal()?this.container.appendChild(i.$el):this.svgContainer.appendChild(i.$el),this.markers[i.id]=i,!1!==e&&this.renderMarkers(),i},r.prototype.getMarker=function(t){var e="object"==typeof t?t.id:t;if(!this.markers[e])throw new E('cannot find marker "'+e+'"');return this.markers[e]},r.prototype.getCurrentMarker=function(){return this.currentMarker},r.prototype.updateMarker=function(t,e){var i=this.getMarker(t);return i.update(t),!1!==e&&this.renderMarkers(),i},r.prototype.removeMarker=function(t,e){(t=this.getMarker(t)).isNormal()?this.container.removeChild(t.$el):this.svgContainer.removeChild(t.$el),this.hoveringMarker===t&&this.psv.tooltip.hideTooltip(),t.destroy(),delete this.markers[t.id],!1!==e&&this.renderMarkers()},r.prototype.clearMarkers=function(t){Object.keys(this.markers).forEach(function(t){this.removeMarker(t,!1)},this),!1!==t&&this.renderMarkers()},r.prototype.gotoMarker=function(t,e){return t=this.getMarker(t),this.psv.animate(t,e).then(function(){this.psv.trigger("goto-marker-done",t)}.bind(this))},r.prototype.hideMarker=function(t){this.getMarker(t).visible=!1,this.renderMarkers()},r.prototype.showMarker=function(t){this.getMarker(t).visible=!0,this.renderMarkers()},r.prototype.toggleMarker=function(t){this.getMarker(t).visible^=!0,this.renderMarkers()},r.prototype.toggleMarkersList=function(){this.prop.panelOpened?this.hideMarkersList():this.showMarkersList()},r.prototype.showMarkersList=function(){var t=[];x.forEach(this.markers,function(e){t.push(e)});var e=this.psv.config.templates.markersList({markers:this.psv.change("render-markers-list",t),config:this.psv.config});this.prop.panelOpening=!0,this.psv.panel.showPanel(e,!0),this.psv.panel.container.querySelector(".psv-markers-list").addEventListener("click",this._onClickItem.bind(this))},r.prototype.hideMarkersList=function(){this.prop.panelOpened&&this.psv.panel.hidePanel()},r.prototype.renderMarkers=function(){if(this.visible){var e=this.psv.isGyroscopeEnabled()?t.Math.radToDeg(this.psv.camera.rotation.z):0;x.forEach(this.markers,function(t){var i=t.visible;if(i&&t.isPoly()){var o=this._getPolyPositions(t);if(i=o.length>(t.isPolygon()?2:1)){t.position2D=this._getPolyDimensions(t,o);var n=o.map(function(t){return t.x+","+t.y}).join(" ");t.$el.setAttributeNS(null,"points",n)}}else if(i){var s=this._getMarkerPosition(t);if(i=this._isMarkerVisible(t,s)){t.position2D=s;var r=t.getScale(this.psv.getZoomLevel());t.isSvg()?t.$el.setAttributeNS(null,"transform","translate("+s.x+", "+s.y+")"+(1!==r?" scale("+r+", "+r+")":"")+(!t.lockRotation&&e?" rotate("+e+")":"")):t.$el.style.transform="translate3D("+s.x+"px, "+s.y+"px, 0px)"+(1!==r?" scale("+r+", "+r+")":"")+(!t.lockRotation&&e?" rotateZ("+e+"deg)":"")}}x.toggleClass(t.$el,"psv-marker--visible",i)}.bind(this))}},r.prototype._isMarkerVisible=function(t,e){return t.position3D.dot(this.psv.prop.direction)>0&&e.x+t.width>=0&&e.x-t.width<=this.psv.prop.size.width&&e.y+t.height>=0&&e.y-t.height<=this.psv.prop.size.height},r.prototype._getMarkerPosition=function(t){if(t._dynamicSize){x.toggleClass(t.$el,"psv-marker--transparent",!0);var e=t.$el.style.transform;t.$el.style.transform=null;var i=t.$el.getBoundingClientRect();t.$el.style.transform=e,x.toggleClass(t.$el,"psv-marker--transparent",!1),t.width=i.right-i.left,t.height=i.bottom-i.top}var o=this.psv.vector3ToViewerCoords(t.position3D);return o.x-=t.width*t.anchor.left,o.y-=t.height*t.anchor.top,o},r.prototype._getPolyPositions=function(t){var e=t.positions3D.length,i=t.positions3D.map(function(t){return{vector:t,visible:t.dot(this.psv.prop.direction)>0}},this),o=[];return i.forEach(function(t,n){if(!t.visible){[0===n?i[e-1]:i[n-1],n===e-1?i[0]:i[n+1]].forEach(function(e){e.visible&&o.push({visible:e,invisible:t,index:n})})}}),o.reverse().forEach(function(t){i.splice(t.index,0,{vector:this._getPolyIntermediaryPoint(t.visible.vector,t.invisible.vector),visible:!0})},this),i.filter(function(t){return t.visible}).map(function(t){return this.psv.vector3ToViewerCoords(t.vector)},this)},r.prototype._getPolyIntermediaryPoint=function(e,i){var o=this.psv.prop.direction.clone().normalize(),s=(new t.Vector3).crossVectors(e,i).normalize(),r=(new t.Vector3).crossVectors(s,e).normalize(),a=(new t.Vector3).addVectors(e.clone().multiplyScalar(-o.dot(r)),r.clone().multiplyScalar(o.dot(e))).normalize(),h=(new t.Vector3).crossVectors(a,o);return a.applyAxisAngle(h,.01).multiplyScalar(n.SPHERE_RADIUS)},r.prototype._getPolyDimensions=function(t,e){var i=1/0,o=1/0,n=-1/0,s=-1/0;return e.forEach(function(t){i=Math.min(i,t.x),o=Math.min(o,t.y),n=Math.max(n,t.x),s=Math.max(s,t.y)}),t.width=n-i,t.height=s-o,{x:i,y:o}},r.prototype._onMouseEnter=function(t){var e;t.target&&(e=t.target.psvMarker)&&!e.isPoly()&&(this.hoveringMarker=e,this.psv.trigger("over-marker",e),e.tooltip&&this.psv.tooltip.showTooltip({content:e.tooltip.content,position:e.tooltip.position,left:e.position2D.x,top:e.position2D.y,box:{width:e.width,height:e.height}}))},r.prototype._onMouseLeave=function(t){var e;if(t.target&&(e=t.target.psvMarker)){if(e.isPoly()&&t.relatedTarget&&x.hasParent(t.relatedTarget,this.psv.tooltip.container))return;this.psv.trigger("leave-marker",e),this.hoveringMarker=null,this.psv.tooltip.hideTooltip()}},r.prototype._onMouseMove=function(t){if(!this.psv.prop.moving){var e;if(t.target&&(e=t.target.psvMarker)&&e.isPoly()||t.target&&x.hasParent(t.target,this.psv.tooltip.container)&&(e=this.hoveringMarker)){this.hoveringMarker||(this.psv.trigger("over-marker",e),this.hoveringMarker=e);var i=this.psv.container.getBoundingClientRect();e.tooltip&&this.psv.tooltip.showTooltip({content:e.tooltip.content,position:e.tooltip.position,top:t.clientY-i.top-this.psv.config.tooltip.arrow_size/2,left:t.clientX-i.left-this.psv.config.tooltip.arrow_size,box:{width:2*this.psv.config.tooltip.arrow_size,height:2*this.psv.config.tooltip.arrow_size}})}else this.hoveringMarker&&this.hoveringMarker.isPoly()&&(this.psv.trigger("leave-marker",this.hoveringMarker),this.hoveringMarker=null,this.psv.tooltip.hideTooltip())}},r.prototype._onClick=function(t,e,i){var o;t.target&&(o=x.getClosest(t.target,".psv-marker"))&&o.psvMarker?(this.currentMarker=o.psvMarker,this.psv.trigger("select-marker",this.currentMarker,i),this.psv.config.click_event_on_marker?t.marker=o.psvMarker:e.stopPropagation()):this.currentMarker&&(this.psv.trigger("unselect-marker",this.currentMarker),this.currentMarker=null),o&&o.psvMarker&&o.psvMarker.content?this.psv.panel.showPanel(o.psvMarker.content):this.psv.panel.prop.opened&&(e.stopPropagation(),this.psv.panel.hidePanel())},r.prototype._onClickItem=function(t){var e;if(t.target&&(e=x.getClosest(t.target,"li"))&&e.dataset.psvMarker){var i=this.getMarker(e.dataset.psvMarker);this.psv.trigger("select-marker-list",i),this.gotoMarker(i,1e3),this.psv.panel.hidePanel()}},r.prototype._onPanelOpened=function(){this.prop.panelOpening?(this.prop.panelOpening=!1,this.prop.panelOpened=!0):this.prop.panelOpened=!1,this.prop.markersButton&&this.prop.markersButton.toggleActive(this.prop.panelOpened)},r.prototype._onPanelClosed=function(){this.prop.panelOpened=!1,this.prop.panelOpening=!1,this.prop.markersButton&&this.prop.markersButton.toggleActive(!1)};function a(t){s.call(this,t),this.canvas=null,this.loader=null,this.create()}a.prototype=Object.create(s.prototype),a.prototype.constructor=a,a.className="psv-loader-container",a.prototype.create=function(){s.prototype.create.call(this);var t=n.SYSTEM.pixelRatio;this.loader=document.createElement("div"),this.loader.className="psv-loader",this.container.appendChild(this.loader),this.canvas=document.createElement("canvas"),this.canvas.className="psv-loader-canvas",this.canvas.width=this.loader.clientWidth*t,this.canvas.height=this.loader.clientWidth*t,this.loader.appendChild(this.canvas),this.tickness=(this.loader.offsetWidth-this.loader.clientWidth)/2*t;var e;if(this.psv.config.loading_img?((e=document.createElement("img")).className="psv-loader-image",e.src=this.psv.config.loading_img):this.psv.config.loading_txt&&((e=document.createElement("div")).className="psv-loader-text",e.innerHTML=this.psv.config.loading_txt),e){var i=Math.round(Math.sqrt(2*Math.pow((this.canvas.width/2-this.tickness/2)/t,2)));e.style.maxWidth=i+"px",e.style.maxHeight=i+"px",this.loader.appendChild(e)}},a.prototype.destroy=function(){delete this.loader,delete this.canvas,s.prototype.destroy.call(this)},a.prototype.setProgress=function(t){var e=this.canvas.getContext("2d");e.clearRect(0,0,this.canvas.width,this.canvas.height),e.lineWidth=this.tickness,e.strokeStyle=x.getStyle(this.loader,"color"),e.beginPath(),e.arc(this.canvas.width/2,this.canvas.height/2,this.canvas.width/2-this.tickness/2,-Math.PI/2,t/100*2*Math.PI-Math.PI/2),e.stroke()};function h(t){if(s.call(this,t),this.config=this.psv.config.navbar,this.items=[],!0===this.config)this.config=x.clone(n.DEFAULTS.navbar);else if("string"==typeof this.config)this.config=this.config.split(" ");else if(!Array.isArray(this.config)){console.warn('PhotoSphereViewer: hashmap form of "navbar" is deprecated, use an array instead.');var e=this.config;this.config=[],x.forEach(e,function(t,e){t&&this.config.push(e)}.bind(this)),this.config.sort(function(t,e){return n.DEFAULTS.navbar.indexOf(t)-n.DEFAULTS.navbar.indexOf(e)})}this.create()}h.prototype=Object.create(s.prototype),h.prototype.constructor=h,h.className="psv-navbar psv-navbar--open",h.publicMethods=["showNavbar","hideNavbar","toggleNavbar","getNavbarButton"],h.prototype.create=function(){s.prototype.create.call(this),this.config.forEach(function(t){if("object"==typeof t)this.items.push(new m(this,t));else switch(t){case g.id:this.items.push(new g(this));break;case M.id:this.items.push(new M(this));break;case v.id:this.items.push(new v(this));break;case w.id:this.items.push(new w(this));break;case y.id:this.items.push(new y(this));break;case b.id:this.items.push(new b(this));break;case _.id:this.items.push(new _(this));break;case"caption":this.items.push(new p(this,this.psv.config.caption));break;default:if(0!==t.indexOf("spacer"))throw new E("Unknown button "+t);console.warn("PhotoSphereViewer: navbar spacers have been removed.")}},this)},h.prototype.destroy=function(){this.items.forEach(function(t){t.destroy()}),this.items.length=0,delete this.config,s.prototype.destroy.call(this)},h.prototype.getNavbarButton=function(t,e){var i=null;return this.items.some(function(e){return e.id===t&&(i=e,!0)}),i||e||console.warn('PhotoSphereViewer: button "'+t+'" not found in the navbar.'),i},h.prototype.showNavbar=function(){this.toggleNavbar(!0)},h.prototype.hideNavbar=function(){this.toggleNavbar(!1)},h.prototype.toggleNavbar=function(t){x.toggleClass(this.container,"psv-navbar--open",t)};function p(t,e){s.call(this,t),this.content=null,this.icon=null,this.prop={caption:"",width:0,hidden:!1},this.create(),this.setCaption(e)}p.prototype=Object.create(s.prototype),p.prototype.constructor=p,p.className="psv-caption",p.publicMethods=["setCaption"],p.prototype.create=function(){s.prototype.create.call(this),this.container.innerHTML=n.ICONS["info.svg"],this.icon=this.container.querySelector("svg"),this.icon.setAttribute("class","psv-caption-icon"),this.icon.style.display="none",this.content=document.createElement("span"),this.content.className="psv-caption-content",this.container.appendChild(this.content),this.icon.addEventListener("click",this),window.addEventListener("resize",this)},p.prototype.destroy=function(){window.removeEventListener("resize",this),delete this.content,s.prototype.destroy.call(this)},p.prototype.handleEvent=function(t){switch(t.type){case"resize":this._onResize();break;case"click":this._onClick()}},p.prototype.setCaption=function(t){this.prop.caption=t||"",this.content.innerHTML=this.prop.caption,this.content.style.display="",this.prop.width=this.content.offsetWidth,this._onResize()},p.prototype._onResize=function(){parseInt(x.getStyle(this.container,"width"))>=this.prop.width?(this.icon.style.display="none",this.content.style.display=""):(this.icon.style.display="",this.content.style.display="none")},p.prototype._onClick=function(){this.psv.isNotificationVisible()?this.psv.hideNotification():this.psv.showNotification(this.prop.caption)};function c(t){s.call(this,t),this.create()}c.prototype=Object.create(s.prototype),c.prototype.constructor=c,c.className="psv-notification",c.publicMethods=["showNotification","hideNotification","isNotificationVisible"],c.prototype.create=function(){s.prototype.create.call(this),this.content=document.createElement("div"),this.content.className="psv-notification-content",this.container.appendChild(this.content),this.content.addEventListener("click",this.hideNotification.bind(this))},c.prototype.destroy=function(){delete this.content,s.prototype.destroy.call(this)},c.prototype.isNotificationVisible=function(){return this.container.classList.contains("psv-notification--visible")},c.prototype.showNotification=function(t){"string"==typeof t&&(t={content:t}),this.content.innerHTML=t.content,this.container.classList.add("psv-notification--visible"),this.psv.trigger("show-notification"),t.timeout&&setTimeout(this.hideNotification.bind(this),t.timeout)},c.prototype.hideNotification=function(){this.isNotificationVisible()&&(this.container.classList.remove("psv-notification--visible"),this.psv.trigger("hide-notification"))};function l(t){s.call(this,t),this.content=null,this.prop={mouse_x:0,mouse_y:0,mousedown:!1,opened:!1},this.create()}l.prototype=Object.create(s.prototype),l.prototype.constructor=l,l.className="psv-panel",l.publicMethods=["showPanel","hidePanel"],l.prototype.create=function(){s.prototype.create.call(this),this.container.innerHTML='<div class="psv-panel-resizer"></div><div class="psv-panel-close-button"></div><div class="psv-panel-content"></div>',this.content=this.container.querySelector(".psv-panel-content");this.container.querySelector(".psv-panel-close-button").addEventListener("click",this.hidePanel.bind(this)),this.psv.config.mousewheel&&this.container.addEventListener(n.SYSTEM.mouseWheelEvent,function(t){t.stopPropagation()});var t=this.container.querySelector(".psv-panel-resizer");t.addEventListener("mousedown",this),t.addEventListener("touchstart",this),this.psv.container.addEventListener("mouseup",this),this.psv.container.addEventListener("touchend",this),this.psv.container.addEventListener("mousemove",this),this.psv.container.addEventListener("touchmove",this)},l.prototype.destroy=function(){this.psv.container.removeEventListener("mousemove",this),this.psv.container.removeEventListener("touchmove",this),this.psv.container.removeEventListener("mouseup",this),this.psv.container.removeEventListener("touchend",this),delete this.prop,delete this.content,s.prototype.destroy.call(this)},l.prototype.handleEvent=function(t){switch(t.type){case"mousedown":this._onMouseDown(t);break;case"touchstart":this._onTouchStart(t);break;case"mousemove":this._onMouseMove(t);break;case"touchmove":this._onTouchMove(t);break;case"mouseup":case"touchend":this._onMouseUp(t)}},l.prototype.showPanel=function(t,e){this.content.innerHTML=t,this.content.scrollTop=0,this.container.classList.add("psv-panel--open"),x.toggleClass(this.content,"psv-panel-content--no-margin",!0===e),this.prop.opened=!0,this.psv.trigger("open-panel")},l.prototype.hidePanel=function(){this.content.innerHTML=null,this.prop.opened=!1,this.container.classList.remove("psv-panel--open"),this.psv.trigger("close-panel")},l.prototype._onMouseDown=function(t){t.stopPropagation(),this._startResize(t)},l.prototype._onTouchStart=function(t){t.stopPropagation(),this._startResize(t.changedTouches[0])},l.prototype._onMouseUp=function(t){this.prop.mousedown&&(t.stopPropagation(),this.prop.mousedown=!1,this.content.classList.remove("psv-panel-content--no-interaction"))},l.prototype._onMouseMove=function(t){this.prop.mousedown&&(t.stopPropagation(),this._resize(t))},l.prototype._onTouchMove=function(t){this.prop.mousedown&&this._resize(t.touches[0])},l.prototype._startResize=function(t){this.prop.mouse_x=parseInt(t.clientX),this.prop.mouse_y=parseInt(t.clientY),this.prop.mousedown=!0,this.content.classList.add("psv-panel-content--no-interaction")},l.prototype._resize=function(t){var e=parseInt(t.clientX),i=parseInt(t.clientY);this.container.style.width=this.container.offsetWidth-(e-this.prop.mouse_x)+"px",this.prop.mouse_x=e,this.prop.mouse_y=i};function u(t){s.call(this,t),this.create()}u.prototype=Object.create(s.prototype),u.prototype.constructor=u,u.className="psv-please-rotate",u.prototype.create=function(){s.prototype.create.call(this),this.container.innerHTML='<div class="psv-please-rotate-image">'+n.ICONS["mobile-rotate.svg"]+'</div><div class="psv-please-rotate-text">'+this.psv.config.lang.please_rotate[0]+'</div><div class="psv-please-rotate-subtext">'+this.psv.config.lang.please_rotate[1]+"</div>",this.container.addEventListener("click",this),window.addEventListener("orientationchange",this)},u.prototype.destroy=function(){window.removeEventListener("orientationchange",this),s.prototype.destroy.call(this)},u.prototype.handleEvent=function(t){switch(t.type){case"click":this.hide();break;case"orientationchange":90===Math.abs(window.orientation)&&this.hide()}};function d(t){s.call(this,t),this.config=this.psv.config.tooltip,this.prop={timeout:null},this.create()}d.prototype=Object.create(s.prototype),d.prototype.constructor=d,d.className="psv-tooltip",d.publicMethods=["showTooltip","hideTooltip","isTooltipVisible"],d.leftMap={0:"left",.5:"center",1:"right"},d.topMap={0:"top",.5:"center",1:"bottom"},d.prototype.create=function(){s.prototype.create.call(this),this.container.innerHTML='<div class="psv-tooltip-arrow"></div><div class="psv-tooltip-content"></div>',this.container.style.top="-1000px",this.container.style.left="-1000px",this.content=this.container.querySelector(".psv-tooltip-content"),this.arrow=this.container.querySelector(".psv-tooltip-arrow"),this.psv.on("render",this)},d.prototype.destroy=function(){this.psv.off("render",this),delete this.config,delete this.prop,s.prototype.destroy.call(this)},d.prototype.handleEvent=function(t){switch(t.type){case"render":this.hideTooltip()}},d.prototype.isTooltipVisible=function(){return this.container.classList.contains("psv-tooltip--visible")},d.prototype.showTooltip=function(t){this.prop.timeout&&(window.clearTimeout(this.prop.timeout),this.prop.timeout=null);var e=this.isTooltipVisible(),i=this.container,o=this.content,n=this.arrow;if(t.position||(t.position=["top","center"]),t.box||(t.box={width:0,height:0}),"string"==typeof t.position){var s=x.parsePosition(t.position);if(!(s.left in d.leftMap&&s.top in d.topMap))throw new E('unable to parse tooltip position "'+t.position+'"');t.position=[d.topMap[s.top],d.leftMap[s.left]]}if("center"===t.position[0]&&"center"===t.position[1])throw new E('unable to parse tooltip position "center center"');if(e)for(var r=i.classList.length-1;r>=0;r--){var a=i.classList.item(r);"psv-tooltip"!==a&&"psv-tooltip--visible"!==a&&i.classList.remove(a)}else i.className="psv-tooltip";t.className&&x.addClasses(i,t.className),o.innerHTML=t.content,i.style.top="0px",i.style.left="0px";var h=i.getBoundingClientRect(),p={posClass:t.position.slice(),width:h.right-h.left,height:h.bottom-h.top,top:0,left:0,arrow_top:0,arrow_left:0};this._computeTooltipPosition(p,t);var c=!1;p.top<this.config.offset?(p.posClass[0]="bottom",c=!0):p.top+p.height>this.psv.prop.size.height-this.config.offset&&(p.posClass[0]="top",c=!0),p.left<this.config.offset?(p.posClass[1]="right",c=!0):p.left+p.width>this.psv.prop.size.width-this.config.offset&&(p.posClass[1]="left",c=!0),c&&this._computeTooltipPosition(p,t),i.style.top=p.top+"px",i.style.left=p.left+"px",n.style.top=p.arrow_top+"px",n.style.left=p.arrow_left+"px",i.classList.add("psv-tooltip--"+p.posClass.join("-")),e||(this.prop.timeout=window.setTimeout(function(){i.classList.add("psv-tooltip--visible"),this.prop.timeout=null,this.psv.trigger("show-tooltip")}.bind(this),this.config.delay))},d.prototype.hideTooltip=function(){this.prop.timeout&&(window.clearTimeout(this.prop.timeout),this.prop.timeout=null),this.isTooltipVisible()&&(this.container.classList.remove("psv-tooltip--visible"),this.prop.timeout=window.setTimeout(function(){this.content.innerHTML=null,this.container.style.top="-1000px",this.container.style.left="-1000px",this.prop.timeout=null}.bind(this),this.config.delay),this.psv.trigger("hide-tooltip"))},d.prototype._computeTooltipPosition=function(t,e){var i=!1;switch(t.posClass[0]){case"bottom":t.top=e.top+e.box.height+this.config.offset+this.config.arrow_size,t.arrow_top=2*-this.config.arrow_size,i=!0;break;case"center":t.top=e.top+e.box.height/2-t.height/2,t.arrow_top=t.height/2-this.config.arrow_size;break;case"top":t.top=e.top-t.height-this.config.offset-this.config.arrow_size,t.arrow_top=t.height,i=!0}switch(t.posClass[1]){case"right":i?(t.left=e.left+e.box.width/2-this.config.offset-this.config.arrow_size,t.arrow_left=this.config.offset):(t.left=e.left+e.box.width+this.config.offset+this.config.arrow_size,t.arrow_left=2*-this.config.arrow_size);break;case"center":t.left=e.left+e.box.width/2-t.width/2,t.arrow_left=t.width/2-this.config.arrow_size;break;case"left":i?(t.left=e.left-t.width+e.box.width/2+this.config.offset+this.config.arrow_size,t.arrow_left=t.width-this.config.offset-2*this.config.arrow_size):(t.left=e.left-t.width-this.config.offset-this.config.arrow_size,t.arrow_left=t.width)}};function f(t){s.call(this,t),this.id=void 0,this.constructor.id&&(this.id=this.constructor.id),this.enabled=!0}f.prototype=Object.create(s.prototype),f.prototype.constructor=f,f.id=null,f.icon=null,f.iconActive=null,f.prototype.create=function(){s.prototype.create.call(this),this.constructor.icon&&this._setIcon(this.constructor.icon),this.id&&this.psv.config.lang[this.id]&&(this.container.title=this.psv.config.lang[this.id]),this.container.addEventListener("click",function(t){this.enabled&&this._onClick(),t.stopPropagation()}.bind(this))},f.prototype.destroy=function(){s.prototype.destroy.call(this)},f.prototype.toggleActive=function(t){x.toggleClass(this.container,"psv-button--active",t),this.constructor.iconActive&&this._setIcon(t?this.constructor.iconActive:this.constructor.icon)},f.prototype.disable=function(){this.container.classList.add("psv-button--disabled"),this.enabled=!1},f.prototype.enable=function(){this.container.classList.remove("psv-button--disabled"),this.enabled=!0},f.prototype._setIcon=function(t,e){e||(e=this.container),t?(e.innerHTML=n.ICONS[t],e.querySelector("svg").setAttribute("class","psv-button-svg")):e.innerHTML=""},f.prototype._onClick=function(){};function g(t){f.call(this,t),this.create()}g.prototype=Object.create(f.prototype),g.prototype.constructor=g,g.id="autorotate",g.className="psv-button psv-button--hover-scale psv-autorotate-button",g.icon="play.svg",g.iconActive="play-active.svg",g.prototype.create=function(){f.prototype.create.call(this),this.psv.on("autorotate",this)},g.prototype.destroy=function(){this.psv.off("autorotate",this),f.prototype.destroy.call(this)},g.prototype.handleEvent=function(t){switch(t.type){case"autorotate":this.toggleActive(t.args[0])}},g.prototype._onClick=function(){this.psv.toggleAutorotate()};function m(t,e){f.call(this,t),this.config=e,this.config.id&&(this.id=this.config.id),this.create()}m.prototype=Object.create(f.prototype),m.prototype.constructor=m,m.className="psv-button psv-custom-button",m.prototype.create=function(){f.prototype.create.call(this),this.config.className&&x.addClasses(this.container,this.config.className),this.config.title&&(this.container.title=this.config.title),this.config.content&&(this.container.innerHTML=this.config.content),!1!==this.config.enabled&&!0!==this.config.disabled||this.disable(),!1!==this.config.visible&&!0!==this.config.hidden||this.hide()},m.prototype.destroy=function(){delete this.config,f.prototype.destroy.call(this)},m.prototype._onClick=function(){this.config.onClick&&this.config.onClick.apply(this.psv)};function v(t){f.call(this,t),this.create()}v.prototype=Object.create(f.prototype),v.prototype.constructor=v,v.id="download",v.className="psv-button psv-button--hover-scale psv-download-button",v.icon="download.svg",v.prototype._onClick=function(){var t=document.createElement("a");t.href=this.psv.config.panorama,t.download=this.psv.config.panorama,this.psv.container.appendChild(t),t.click()};function y(t){f.call(this,t),this.create()}y.prototype=Object.create(f.prototype),y.prototype.constructor=y,y.id="fullscreen",y.className="psv-button psv-button--hover-scale psv-fullscreen-button",y.icon="fullscreen-in.svg",y.iconActive="fullscreen-out.svg",y.prototype.create=function(){f.prototype.create.call(this),n.SYSTEM.fullscreenEvent||(this.hide(),console.warn("PhotoSphereViewer: fullscreen not supported.")),this.psv.on("fullscreen-updated",this)},y.prototype.destroy=function(){this.psv.off("fullscreen-updated",this),f.prototype.destroy.call(this)},y.prototype.handleEvent=function(t){switch(t.type){case"fullscreen-updated":this.toggleActive(t.args[0])}},y.prototype._onClick=function(){this.psv.toggleFullscreen()};function _(t){f.call(this,t),this.create()}_.prototype=Object.create(f.prototype),_.prototype.constructor=_,_.id="gyroscope",_.className="psv-button psv-button--hover-scale psv-gyroscope-button",_.icon="compass.svg",_.prototype.create=function(){f.prototype.create.call(this),n.SYSTEM.deviceOrientationSupported.then(this._onAvailabilityChange.bind(this,!0),this._onAvailabilityChange.bind(this,!1)),this.hide(),this.psv.on("gyroscope-updated",this)},_.prototype.destroy=function(){this.psv.off("gyroscope-updated",this),f.prototype.destroy.call(this)},_.prototype.handleEvent=function(t){switch(t.type){case"gyroscope-updated":this.toggleActive(t.args[0])}},_.prototype._onClick=function(){this.psv.toggleGyroscopeControl()},_.prototype._onAvailabilityChange=function(t){t&&x.checkTHREE("DeviceOrientationControls")&&this.show()};function w(t){f.call(this,t),this.create()}w.prototype=Object.create(f.prototype),w.prototype.constructor=w,w.id="markers",w.className="psv-button psv-button--hover-scale psv-markers-button",w.icon="pin.svg",w.prototype._onClick=function(){this.psv.hud.toggleMarkersList()};function b(t){f.call(this,t),this.create()}b.prototype=Object.create(f.prototype),b.prototype.constructor=b,b.id="stereo",b.className="psv-button psv-button--hover-scale psv-stereo-button",b.icon="stereo.svg",b.prototype.create=function(){f.prototype.create.call(this),n.SYSTEM.deviceOrientationSupported.then(this._onAvailabilityChange.bind(this,!0),this._onAvailabilityChange.bind(this,!1)),this.hide(),this.psv.on("stereo-updated",this)},b.prototype.destroy=function(){this.psv.off("stereo-updated",this),f.prototype.destroy.call(this)},b.prototype.handleEvent=function(t){switch(t.type){case"stereo-updated":this.toggleActive(t.args[0])}},b.prototype._onClick=function(){this.psv.toggleStereoView()},b.prototype._onAvailabilityChange=function(t){t&&x.checkTHREE("DeviceOrientationControls","StereoEffect")&&this.show()};function M(t){f.call(this,t),this.zoom_range=null,this.zoom_value=null,this.prop={mousedown:!1,buttondown:!1,longPressInterval:null,longPressTimeout:null},this.create()}M.prototype=Object.create(f.prototype),M.prototype.constructor=M,M.id="zoom",M.className="psv-button psv-zoom-button",M.prototype.create=function(){f.prototype.create.call(this);var t=document.createElement("div");t.className="psv-zoom-button-minus",t.title=this.psv.config.lang.zoomOut,this._setIcon("zoom-out.svg",t),this.container.appendChild(t);var e=document.createElement("div");e.className="psv-zoom-button-range",this.container.appendChild(e),this.zoom_range=document.createElement("div"),this.zoom_range.className="psv-zoom-button-line",e.appendChild(this.zoom_range),this.zoom_value=document.createElement("div"),this.zoom_value.className="psv-zoom-button-handle",this.zoom_range.appendChild(this.zoom_value);var i=document.createElement("div");i.className="psv-zoom-button-plus",i.title=this.psv.config.lang.zoomIn,this._setIcon("zoom-in.svg",i),this.container.appendChild(i),this.zoom_range.addEventListener("mousedown",this),this.zoom_range.addEventListener("touchstart",this),this.psv.container.addEventListener("mousemove",this),this.psv.container.addEventListener("touchmove",this),this.psv.container.addEventListener("mouseup",this),this.psv.container.addEventListener("touchend",this),t.addEventListener("mousedown",this._zoomOut.bind(this)),i.addEventListener("mousedown",this._zoomIn.bind(this)),this.psv.on("zoom-updated",this),this.psv.once("ready",function(){this._moveZoomValue(this.psv.prop.zoom_lvl)}.bind(this))},M.prototype.destroy=function(){this._stopZoomChange(),this.psv.container.removeEventListener("mousemove",this),this.psv.container.removeEventListener("touchmove",this),this.psv.container.removeEventListener("mouseup",this),this.psv.container.removeEventListener("touchend",this),delete this.zoom_range,delete this.zoom_value,this.psv.off("zoom-updated",this),f.prototype.destroy.call(this)},M.prototype.handleEvent=function(t){switch(t.type){case"mousedown":this._initZoomChangeWithMouse(t);break;case"touchstart":this._initZoomChangeByTouch(t);break;case"mousemove":this._changeZoomWithMouse(t);break;case"touchmove":this._changeZoomByTouch(t);break;case"mouseup":case"touchend":this._stopZoomChange(t);break;case"zoom-updated":this._moveZoomValue(t.args[0])}},M.prototype._moveZoomValue=function(t){this.zoom_value.style.left=t/100*this.zoom_range.offsetWidth-this.zoom_value.offsetWidth/2+"px"},M.prototype._initZoomChangeWithMouse=function(t){this.enabled&&(this.prop.mousedown=!0,this._changeZoom(t.clientX))},M.prototype._initZoomChangeByTouch=function(t){this.enabled&&(this.prop.mousedown=!0,this._changeZoom(t.changedTouches[0].clientX))},M.prototype._zoomIn=function(){this.enabled&&(this.prop.buttondown=!0,this.psv.zoomIn(),this.prop.longPressTimeout=window.setTimeout(this._startLongPressInterval.bind(this,1),200))},M.prototype._zoomOut=function(){this.enabled&&(this.prop.buttondown=!0,this.psv.zoomOut(),this.prop.longPressTimeout=window.setTimeout(this._startLongPressInterval.bind(this,-1),200))},M.prototype._startLongPressInterval=function(t){this.prop.buttondown&&(this.prop.longPressInterval=window.setInterval(function(){this.psv.zoom(this.psv.prop.zoom_lvl+t)}.bind(this),50))},M.prototype._stopZoomChange=function(){this.enabled&&(window.clearInterval(this.prop.longPressInterval),window.clearTimeout(this.prop.longPressTimeout),this.prop.longPressInterval=null,this.prop.mousedown=!1,this.prop.buttondown=!1)},M.prototype._changeZoomWithMouse=function(t){this.enabled&&(t.preventDefault(),this._changeZoom(t.clientX))},M.prototype._changeZoomByTouch=function(t){this.enabled&&this._changeZoom(t.changedTouches[0].clientX)},M.prototype._changeZoom=function(t){if(this.prop.mousedown){var e=(parseInt(t)-this.zoom_range.getBoundingClientRect().left)/this.zoom_range.offsetWidth*100;this.psv.zoom(e)}};function E(t){this.message=t,"captureStackTrace"in Error?Error.captureStackTrace(this,E):this.stack=(new Error).stack}E.prototype=Object.create(Error.prototype),E.prototype.name="PSVError",E.prototype.constructor=E,n.Error=E;function k(t,e){if(!t.id)throw new E("missing marker id");if(t.image&&(!t.width||!t.height))throw new E("missing marker width/height");if((t.image||t.html)&&!(t.hasOwnProperty("x")&&t.hasOwnProperty("y")||t.hasOwnProperty("latitude")&&t.hasOwnProperty("longitude")))throw new E("missing marker position, latitude/longitude or x/y");this.psv=e,this.visible=!0,this._dynamicSize=!1;var i,o=t.id,n=k.getType(t,!1);Object.defineProperties(this,{id:{configurable:!1,enumerable:!0,get:function(){return o},set:function(){}},type:{configurable:!1,enumerable:!0,get:function(){return n},set:function(){}},$el:{configurable:!1,enumerable:!0,get:function(){return i},set:function(){}},_def:{configurable:!1,enumerable:!0,get:function(){return this[n]},set:function(t){this[n]=t}}}),(i=this.isNormal()?document.createElement("div"):this.isPolygon()?document.createElementNS(x.svgNS,"polygon"):this.isPolyline()?document.createElementNS(x.svgNS,"polyline"):document.createElementNS(x.svgNS,this.type)).id="psv-marker-"+this.id,i.psvMarker=this,this.update(t)}k.types=["image","html","polygon_px","polygon_rad","polyline_px","polyline_rad","rect","circle","ellipse","path"],k.getType=function(t,e){var i=[];if(k.types.forEach(function(e){t[e]&&i.push(e)}),0===i.length&&!e)throw new E("missing marker content, either "+k.types.join(", "));if(i.length>1)throw new E("multiple marker content, either "+k.types.join(", "));return i[0]},k.prototype.destroy=function(){delete this.$el.psvMarker},k.prototype.isNormal=function(){return"image"===this.type||"html"===this.type},k.prototype.isPoly=function(){return this.isPolygon()||this.isPolyline()},k.prototype.isPolygon=function(){return"polygon_px"===this.type||"polygon_rad"===this.type},k.prototype.isPolyline=function(){return"polyline_px"===this.type||"polyline_rad"===this.type},k.prototype.isSvg=function(){return"rect"===this.type||"circle"===this.type||"ellipse"===this.type||"path"===this.type},k.prototype.getScale=function(t){return Array.isArray(this.scale)?this.scale[0]+(this.scale[1]-this.scale[0])*x.animation.easings.inQuad(t/100):"function"==typeof this.scale?this.scale(t):"number"==typeof this.scale?this.scale*x.animation.easings.inQuad(t/100):1},k.prototype.update=function(t){if(t&&t!==this){var e=k.getType(t,!0);if(void 0!==e&&e!==this.type)throw new E("cannot change marker type");x.deepmerge(this,t)}this.isNormal()?this.$el.setAttribute("class","psv-marker psv-marker--normal"):this.$el.setAttribute("class","psv-marker psv-marker--svg"),this.className&&x.addClasses(this.$el,this.className),this.tooltip&&(x.addClasses(this.$el,"has-tooltip"),"string"==typeof this.tooltip&&(this.tooltip={content:this.tooltip})),this.style&&x.deepmerge(this.$el.style,this.style),this.anchor=x.parsePosition(this.anchor),this.isNormal()?this._updateNormal():this.isPolygon()?this._updatePoly("polygon_rad","polygon_px"):this.isPolyline()?this._updatePoly("polyline_rad","polyline_px"):this._updateSvg()},k.prototype._updateNormal=function(){this.width&&this.height?(this.$el.style.width=this.width+"px",this.$el.style.height=this.height+"px",this._dynamicSize=!1):this._dynamicSize=!0,this.image?this.$el.style.backgroundImage="url("+this.image+")":this.$el.innerHTML=this.html,this.$el.style.transformOrigin=100*this.anchor.left+"% "+100*this.anchor.top+"%",this.psv.cleanPosition(this),this.position3D=this.psv.sphericalCoordsToVector3(this)},k.prototype._updateSvg=function(){switch(this._dynamicSize=!0,this.type){case"rect":"number"==typeof this._def?this._def={x:0,y:0,width:this._def,height:this._def}:Array.isArray(this._def)?this._def={x:0,y:0,width:this._def[0],height:this._def[1]}:this._def.x=this._def.y=0;break;case"circle":"number"==typeof this._def?this._def={cx:this._def,cy:this._def,r:this._def}:Array.isArray(this._def)?this._def={cx:this._def[0],cy:this._def[0],r:this._def[0]}:this._def.cx=this._def.cy=this._def.r;break;case"ellipse":"number"==typeof this._def?this._def={cx:this._def,cy:this._def,rx:this._def,ry:this._def}:Array.isArray(this._def)?this._def={cx:this._def[0],cy:this._def[1],rx:this._def[0],ry:this._def[1]}:(this._def.cx=this._def.rx,this._def.cy=this._def.ry);break;case"path":"string"==typeof this._def&&(this._def={d:this._def})}Object.getOwnPropertyNames(this._def).forEach(function(t){this.$el.setAttributeNS(null,t,this._def[t])},this),this.svgStyle?Object.getOwnPropertyNames(this.svgStyle).forEach(function(t){this.$el.setAttributeNS(null,x.dasherize(t),this.svgStyle[t])},this):this.$el.setAttributeNS(null,"fill","rgba(0,0,0,0.5)"),this.psv.cleanPosition(this),this.position3D=this.psv.sphericalCoordsToVector3(this)},k.prototype._updatePoly=function(t,e){this._dynamicSize=!0,this.svgStyle?(Object.getOwnPropertyNames(this.svgStyle).forEach(function(t){this.$el.setAttributeNS(null,x.dasherize(t),this.svgStyle[t])},this),this.isPolyline()&&!this.svgStyle.fill&&this.$el.setAttributeNS(null,"fill","none")):this.isPolygon()?this.$el.setAttributeNS(null,"fill","rgba(0,0,0,0.5)"):this.isPolyline()&&(this.$el.setAttributeNS(null,"fill","none"),this.$el.setAttributeNS(null,"stroke","rgb(0,0,0)")),[this[t],this[e]].forEach(function(t){if(t&&"object"!=typeof t[0])for(var e=0;e<t.length;e++)t.splice(e,2,[t[e],t[e+1]])}),this[e]?this[t]=this[e].map(function(t){var e=this.psv.textureCoordsToSphericalCoords({x:t[0],y:t[1]});return[e.longitude,e.latitude]},this):this[t]=this[t].map(function(t){return[x.parseAngle(t[0]),x.parseAngle(t[1],!0)]}),this.longitude=this[t][0][0],this.latitude=this[t][0][1],this.positions3D=this[t].map(function(t){return this.psv.sphericalCoordsToVector3({longitude:t[0],latitude:t[1]})},this)};var x={};return n.Utils=x,x.TwoPI=2*Math.PI,x.HalfPI=Math.PI/2,x.svgNS="http://www.w3.org/2000/svg",x.checkTHREE=function(e){for(var i=0,o=arguments.length;i<o;i++)if(!(arguments[i]in t))return!1;return!0},x.isCanvasSupported=function(){var t=document.createElement("canvas");return!(!t.getContext||!t.getContext("2d"))},x.getWebGLCtx=function(){var t=document.createElement("canvas"),e=null;return t.getContext&&["webgl","experimental-webgl","moz-webgl","webkit-3d"].some(function(i){try{return(e=t.getContext(i))&&"function"==typeof e.getParameter}catch(t){return!1}})?e:null},x.isWebGLSupported=function(){return!!window.WebGLRenderingContext&&null!==x.getWebGLCtx()},x.isDeviceOrientationSupported=function(){var t=e();if("DeviceOrientationEvent"in window){var i=function(e){e&&null!==e.alpha&&!isNaN(e.alpha)?t.resolve():t.reject(),window.removeEventListener("deviceorientation",i)};window.addEventListener("deviceorientation",i,!1),setTimeout(function(){t.promise.isPending()&&i(null)},2e3)}else t.reject();return t.promise},x.isTouchEnabled=function(){var t=e(),i=function(e){e?t.resolve():t.reject(),window.removeEventListener("touchstart",i)};return window.addEventListener("touchstart",i,!1),setTimeout(function(){t.promise.isPending()&&i(null)},1e4),t.promise},x.getMaxTextureWidth=function(){var t=x.getWebGLCtx();return null!==t?t.getParameter(t.MAX_TEXTURE_SIZE):0},x.toggleClass=function(t,e,i){if(t.classList)void 0===i?t.classList.toggle(e):i&&!t.classList.contains(e)?t.classList.add(e):i||t.classList.remove(e);else{var o=t.getAttribute("class")||"",n=-1!==o.indexOf(e),s=new RegExp("(?:^|\\s)"+e+"(?:\\s|$)");void 0!==i&&!i||n?i||(o=o.replace(s," ")):o+=o.length>0?" "+e:e,t.setAttribute("class",o)}},x.addClasses=function(t,e){e&&e.split(" ").forEach(function(e){x.toggleClass(t,e,!0)})},x.removeClasses=function(t,e){e&&e.split(" ").forEach(function(e){x.toggleClass(t,e,!1)})},x.hasParent=function(t,e){do{if(t===e)return!0}while(t=t.parentNode);return!1},x.getClosest=function(t,e){var i=t.matches||t.msMatchesSelector;do{if(i.bind(t)(e))return t}while(t=t.parentElement);return null},x.mouseWheelEvent=function(){return"onwheel"in document.createElement("div")?"wheel":void 0!==document.onmousewheel?"mousewheel":"DOMMouseScroll"},x.fullscreenEvent=function(){var t={exitFullscreen:"fullscreenchange",webkitExitFullscreen:"webkitfullscreenchange",mozCancelFullScreen:"mozfullscreenchange",msExitFullscreen:"MSFullscreenChange"};for(var e in t)if(t.hasOwnProperty(e)&&e in document)return t[e];return null},x.bound=function(t,e,i){return Math.max(e,Math.min(i,t))},x.isInteger=Number.isInteger||function(t){return"number"==typeof t&&isFinite(t)&&Math.floor(t)===t},x.sum=function(t){return t.reduce(function(t,e){return t+e},0)},x.dasherize=function(t){return t.replace(/[A-Z](?:(?=[^A-Z])|[A-Z]*(?=[A-Z][^A-Z]|$))/g,function(t,e){return(e>0?"-":"")+t.toLowerCase()})},x.getXMPValue=function(t,e){var i;return null!==(i=t.match("<GPano:"+e+">(.*)</GPano:"+e+">"))?i[1]:null!==(i=t.match("GPano:"+e+'="(.*?)"'))?i[1]:null},x.isFullscreenEnabled=function(t){return(document.fullscreenElement||document.mozFullScreenElement||document.webkitFullscreenElement||document.msFullscreenElement)===t},x.requestFullscreen=function(t){(t.requestFullscreen||t.mozRequestFullScreen||t.webkitRequestFullscreen||t.msRequestFullscreen).call(t)},x.exitFullscreen=function(){(document.exitFullscreen||document.mozCancelFullScreen||document.webkitExitFullscreen||document.msExitFullscreen).call(document)},x.getStyle=function(t,e){return window.getComputedStyle(t,null)[e]},x.getShortestArc=function(t,e){return[0,x.TwoPI,-x.TwoPI].reduce(function(i,o){return o=e-t+o,Math.abs(o)<Math.abs(i)?o:i},1/0)},x.parsePosition=function(t){if(!t)return{top:.5,left:.5};if("object"==typeof t)return t;var e=t.toLocaleLowerCase().split(" ").slice(0,2);1===e.length&&(e=void 0!==x.parsePosition.positions[e[0]]?[e[0],"center"]:[e[0],e[0]]);var i="left"!==e[1]&&"right"!==e[1]&&"top"!==e[0]&&"bottom"!==e[0];e=e.map(function(t){return x.parsePosition.positions[t]||t}),i||e.reverse();var o=e.join(" ").match(/^([0-9.]+)% ([0-9.]+)%$/);return o?{left:o[1]/100,top:o[2]/100}:{top:.5,left:.5}},x.parsePosition.positions={top:"0%",bottom:"100%",left:"0%",right:"100%",center:"50%"},x.parseSpeed=function(e){if("string"==typeof e){e=e.toString().trim();var i=parseFloat(e.replace(/^(-?[0-9]+(?:\.[0-9]*)?).*$/,"$1")),o=e.replace(/^-?[0-9]+(?:\.[0-9]*)?(.*)$/,"$1").trim();switch(o.match(/(pm|per minute)$/)&&(i/=60),o){case"dpm":case"degrees per minute":case"dps":case"degrees per second":e=t.Math.degToRad(i);break;case"radians per minute":case"radians per second":e=i;break;case"rpm":case"revolutions per minute":case"rps":case"revolutions per second":e=i*x.TwoPI;break;default:throw new E('unknown speed unit "'+o+'"')}}return e},x.parseAngle=function(e,i){if("string"==typeof e){var o=e.toLowerCase().trim().match(/^(-?[0-9]+(?:\.[0-9]*)?)(.*)$/);if(!o)throw new E('unknown angle "'+e+'"');var n=parseFloat(o[1]),s=o[2];if(s)switch(s){case"deg":case"degs":e=t.Math.degToRad(n);break;case"rad":case"rads":e=n;break;default:throw new E('unknown angle unit "'+s+'"')}else e=n}return(e=(i?e+Math.PI:e)%x.TwoPI)<0&&(e=x.TwoPI+e),i?x.bound(e-Math.PI,-x.HalfPI,x.HalfPI):e},x.cleanTHREEScene=function(e){e.children.forEach(function(e){e instanceof t.Mesh&&(e.geometry&&(e.geometry.dispose(),e.geometry=null),e.material&&(e.material.materials?(e.material.materials.forEach(function(t){t.map&&(t.map.dispose(),t.map=null),t.dispose()}),e.material.materials.length=0):(e.material.map&&(e.material.map.dispose(),e.material.map=null),e.material.dispose()),e.material=null))}),e.children.length=0},x.animation=function(t){var i=e(!1),o=null;t.easing&&"string"!=typeof t.easing||(t.easing=x.animation.easings[t.easing||"linear"]);function n(e){if(-1!==i.promise.getStatus()){null===o&&(o=e);var s,r=(e-o)/t.duration,a={};if(r<1){for(s in t.properties)a[s]=t.properties[s].start+(t.properties[s].end-t.properties[s].start)*t.easing(r);t.onTick(a,r),window.requestAnimationFrame(n)}else{for(s in t.properties)a[s]=t.properties[s].end;t.onTick(a,1),window.requestAnimationFrame(function(){i.resolve()})}}}void 0!==t.delay?window.setTimeout(function(){window.requestAnimationFrame(n)},t.delay):window.requestAnimationFrame(n);var s=i.promise;return s.cancel=function(){i.reject()},s},x.animation.easings={linear:function(t){return t},inQuad:function(t){return t*t},outQuad:function(t){return t*(2-t)},inOutQuad:function(t){return t<.5?2*t*t:(4-2*t)*t-1},inCubic:function(t){return t*t*t},outCubic:function(t){return--t*t*t+1},inOutCubic:function(t){return t<.5?4*t*t*t:(t-1)*(2*t-2)*(2*t-2)+1},inQuart:function(t){return t*t*t*t},outQuart:function(t){return 1- --t*t*t*t},inOutQuart:function(t){return t<.5?8*t*t*t*t:1-8*--t*t*t*t},inQuint:function(t){return t*t*t*t*t},outQuint:function(t){return 1+--t*t*t*t*t},inOutQuint:function(t){return t<.5?16*t*t*t*t*t:1+16*--t*t*t*t*t},inSine:function(t){return 1-Math.cos(t*(Math.PI/2))},outSine:function(t){return Math.sin(t*(Math.PI/2))},inOutSine:function(t){return.5-.5*Math.cos(Math.PI*t)},inExpo:function(t){return Math.pow(2,10*(t-1))},outExpo:function(t){return 1-Math.pow(2,-10*t)},inOutExpo:function(t){return(t=2*t-1)<0?.5*Math.pow(2,10*t):1-.5*Math.pow(2,-10*t)},inCirc:function(t){return 1-Math.sqrt(1-t*t)},outCirc:function(t){return t--,Math.sqrt(1-t*t)},inOutCirc:function(t){return(t*=2)<1?.5-.5*Math.sqrt(1-t*t):.5+.5*Math.sqrt(1-(t-=2)*t)}},x.throttle=function(t,e){var i,o,n,s=null,r=0,a=function(){r=Date.now(),s=null,n=t.apply(i,o),s||(i=o=null)};return function(){var h=Date.now();r||(r=h);var p=e-(h-r);return i=this,o=arguments,p<=0||p>e?(s&&(clearTimeout(s),s=null),r=h,n=t.apply(i,o),s||(i=o=null)):s||(s=setTimeout(a,p)),n}},x.isPlainObject=function(t){if("object"==typeof t&&null!==t){if("function"==typeof Object.getPrototypeOf){var e=Object.getPrototypeOf(t);return e===Object.prototype||null===e}return"[object Object]"===Object.prototype.toString.call(t)}return!1},x.deepmerge=function(t,e){var i=e;return function t(e,o){return Array.isArray(o)?(e&&Array.isArray(e)?e.length=0:e=[],o.forEach(function(i,o){e[o]=t(null,i)})):"object"==typeof o?(e&&!Array.isArray(e)||(e={}),Object.keys(o).forEach(function(n){"object"==typeof o[n]&&o[n]&&x.isPlainObject(o[n])?o[n]!=i&&(e[n]?t(e[n],o[n]):e[n]=t(null,o[n])):e[n]=o[n]})):e=o,e}(t,e)},x.clone=function(t){return x.deepmerge(null,t)},x.normalizeWheel=function(t){var e=0,i=0,o=0,n=0;return"detail"in t&&(i=t.detail),"wheelDelta"in t&&(i=-t.wheelDelta/120),"wheelDeltaY"in t&&(i=-t.wheelDeltaY/120),"wheelDeltaX"in t&&(e=-t.wheelDeltaX/120),"axis"in t&&t.axis===t.HORIZONTAL_AXIS&&(e=i,i=0),o=10*e,n=10*i,"deltaY"in t&&(n=t.deltaY),"deltaX"in t&&(o=t.deltaX),(o||n)&&t.deltaMode&&(1===t.deltaMode?(o*=40,n*=40):(o*=800,n*=800)),o&&!e&&(e=o<1?-1:1),n&&!i&&(i=n<1?-1:1),{spinX:e,spinY:i,pixelX:o,pixelY:n}},x.forEach=function(t,e){for(var i in t)t.hasOwnProperty(i)&&e(t[i],i)},function(t){if(t.requestAnimationFrame=t.requestAnimationFrame||t.mozRequestAnimationFrame||t.webkitRequestAnimationFrame||t.msRequestAnimationFrame,t.cancelAnimationFrame=t.cancelAnimationFrame||t.mozCancelAnimationFrame||t.webkitCancelAnimationFrame||t.msCancelAnimationFrame,!t.requestAnimationFrame){var e,i=[],o=[],n=0;t.requestAnimationFrame=function(t){return i.push([++n,t]),e||(e=setInterval(function(){if(i.length){var t=+new Date,n=o;for(o=i,i=n;o.length;)o.shift()[1](t)}else clearInterval(e),e=void 0},20)),n},t.cancelAnimationFrame=function(t){var e,n;for(e=0,n=i.length;e<n;e+=1)if(i[e][0]===t)return void i.splice(e,1);for(e=0,n=o.length;e<n;e+=1)if(o[e][0]===t)return void o.splice(e,1)}}}(window),n.ICONS["compass.svg"]='<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><path d="M50 0a50 50 0 1 0 0 100A50 50 0 0 0 50 0zm0 88.81a38.86 38.86 0 0 1-38.81-38.8 38.86 38.86 0 0 1 38.8-38.82A38.86 38.86 0 0 1 88.82 50 38.87 38.87 0 0 1 50 88.81z"/><path d="M72.07 25.9L40.25 41.06 27.92 74.12l31.82-15.18v-.01l12.32-33.03zM57.84 54.4L44.9 42.58l21.1-10.06-8.17 21.9z"/>\x3c!--Created by iconoci from the Noun Project--\x3e</svg>',n.ICONS["download.svg"]='<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><path d="M83.3 35.6h-17V3H32.2v32.6H16.6l33.6 32.7 33-32.7z"/><path d="M83.3 64.2v16.3H16.6V64.2H-.1v32.6H100V64.2H83.3z"/>\x3c!--Created by Michael Zenaty from the Noun Project--\x3e</svg>',n.ICONS["fullscreen-in.svg"]='<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><path d="M100 40H87.1V18.8h-21V6H100zM100 93.2H66V80.3h21.1v-21H100zM34 93.2H0v-34h12.9v21.1h21zM12.9 40H0V6h34v12.9H12.8z"/>\x3c!--Created by Garrett Knoll from the Noun Project--\x3e</svg>',n.ICONS["fullscreen-out.svg"]='<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><path d="M66 7h13v21h21v13H66zM66 60.3h34v12.9H79v21H66zM0 60.3h34v34H21V73.1H0zM21 7h13v34H0V28h21z"/>\x3c!--Created by Garrett Knoll from the Noun Project--\x3e</svg>',n.ICONS["info.svg"]='<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 64 64"><path d="M28.3 26.1c-1 2.6-1.9 4.8-2.6 7-2.5 7.4-5 14.7-7.2 22-1.3 4.4.5 7.2 4.3 7.8 1.3.2 2.8.2 4.2-.1 8.2-2 11.9-8.6 15.7-15.2l-2.2 2a18.8 18.8 0 0 1-7.4 5.2 2 2 0 0 1-1.6-.2c-.2-.1 0-1 0-1.4l.8-1.8L41.9 28c.5-1.4.9-3 .7-4.4-.2-2.6-3-4.4-6.3-4.4-8.8.2-15 4.5-19.5 11.8-.2.3-.2.6-.3 1.3 3.7-2.8 6.8-6.1 11.8-6.2z"/><circle cx="39.3" cy="9.2" r="8.2"/>\x3c!--Created by Arafat Uddin from the Noun Project--\x3e</svg>',n.ICONS["mobile-rotate.svg"]='<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><path d="M66.7 19a14 14 0 0 1 13.8 12.1l-3.9-2.7c-.5-.3-1.1-.2-1.4.3-.3.5-.2 1.1.3 1.4l5.7 3.9.6.2c.3 0 .6-.2.8-.4l3.9-5.7c.3-.5.2-1.1-.3-1.4-.5-.3-1.1-.2-1.4.3l-2.4 3.5A16 16 0 0 0 66.7 17c-.6 0-1 .4-1 1s.4 1 1 1zM25 15h10c.6 0 1-.4 1-1s-.4-1-1-1H25c-.6 0-1 .4-1 1s.4 1 1 1zm-6.9 30H16l-2 .2a1 1 0 0 0-.8 1.2c.1.5.5.8 1 .8h.2l1.7-.2h2.1c.6 0 1-.4 1-1s-.5-1-1.1-1zm10 0h-4c-.6 0-1 .4-1 1s.4 1 1 1h4c.6 0 1-.4 1-1s-.4-1-1-1zM84 45H55V16A11 11 0 0 0 44 5H16A11 11 0 0 0 5 16v68a11 11 0 0 0 11 11h68a11 11 0 0 0 11-11V56a11 11 0 0 0-11-11zM16 93c-5 0-9-4-9-9V53.2c.3-.1.6-.3.7-.6a9.8 9.8 0 0 1 2-3c.4-.4.4-1 0-1.4a1 1 0 0 0-1.4 0l-1.2 1.5V16c0-5 4-9 9-9h28c5 0 9 4 9 9v68c0 5-4 9-9 9H16zm77-9c0 5-4 9-9 9H50.3c2.8-2 4.7-5.3 4.7-9V47h29c5 0 9 4 9 9v28zM38.1 45h-4c-.6 0-1 .4-1 1s.4 1 1 1h4c.6 0 1-.4 1-1s-.5-1-1-1zm9.9 0h-4c-.6 0-1 .4-1 1s.4 1 1 1h4c.6 0 1-.4 1-1s-.4-1-1-1zm38 19c-.6 0-1 .4-1 1v10c0 .6.4 1 1 1s1-.4 1-1V65c0-.6-.4-1-1-1z"/>\x3c!--Created by Anthony Bresset from the Noun Project--\x3e</svg>',n.ICONS["pin.svg"]='<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 48 48"><path d="M24 0C13.8 0 5.5 8.3 5.5 18.5c0 10.07 17.57 28.64 18.32 29.42a.25.25 0 0 0 .36 0c.75-.78 18.32-19.35 18.32-29.42C42.5 8.3 34.2 0 24 0zm0 7.14a10.35 10.35 0 0 1 0 20.68 10.35 10.35 0 0 1 0-20.68z"/>\x3c!--Created by Daniele Marucci from the Noun Project--\x3e</svg>',n.ICONS["play-active.svg"]='<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 41 41"><path d="M40.5 14.1c-.1-.1-1.2-.5-2.898-1-.102 0-.202-.1-.202-.2C34.5 6.5 28 2 20.5 2S6.6 6.5 3.7 12.9c0 .1-.1.1-.2.2-1.7.6-2.8 1-2.9 1l-.6.3v12.1l.6.2c.1 0 1.1.399 2.7.899.1 0 .2.101.2.199C6.3 34.4 12.9 39 20.5 39c7.602 0 14.102-4.6 16.9-11.1 0-.102.1-.102.199-.2 1.699-.601 2.699-1 2.801-1l.6-.3V14.3l-.5-.2zM6.701 11.5C9.7 7 14.8 4 20.5 4c5.8 0 10.9 3 13.8 7.5.2.3-.1.6-.399.5-3.799-1-8.799-2-13.6-2-4.7 0-9.5 1-13.2 2-.3.1-.5-.2-.4-.5zM25.1 20.3L18.7 24c-.3.2-.7 0-.7-.5v-7.4c0-.4.4-.6.7-.4l6.399 3.8c.301.1.301.6.001.8zm9.4 8.901A16.421 16.421 0 0 1 20.5 37c-5.9 0-11.1-3.1-14-7.898-.2-.302.1-.602.4-.5 3.9 1 8.9 2.1 13.6 2.1 5 0 9.9-1 13.602-2 .298-.1.5.198.398.499z"/>\x3c!--Created by Nick Bluth from the Noun Project--\x3e</svg>',n.ICONS["play.svg"]='<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 41 41"><path d="M40.5 14.1c-.1-.1-1.2-.5-2.899-1-.101 0-.2-.1-.2-.2C34.5 6.5 28 2 20.5 2S6.6 6.5 3.7 12.9c0 .1-.1.1-.2.2-1.7.6-2.8 1-2.9 1l-.6.3v12.1l.6.2c.1 0 1.1.4 2.7.9.1 0 .2.1.2.199C6.3 34.4 12.9 39 20.5 39c7.601 0 14.101-4.6 16.9-11.1 0-.101.1-.101.2-.2 1.699-.6 2.699-1 2.8-1l.6-.3V14.3l-.5-.2zM20.5 4c5.8 0 10.9 3 13.8 7.5.2.3-.1.6-.399.5-3.8-1-8.8-2-13.6-2-4.7 0-9.5 1-13.2 2-.3.1-.5-.2-.4-.5C9.7 7 14.8 4 20.5 4zm0 33c-5.9 0-11.1-3.1-14-7.899-.2-.301.1-.601.4-.5 3.9 1 8.9 2.1 13.6 2.1 5 0 9.9-1 13.601-2 .3-.1.5.2.399.5A16.422 16.422 0 0 1 20.5 37zm18.601-12.1c0 .1-.101.3-.2.3-2.5.9-10.4 3.6-18.4 3.6-7.1 0-15.6-2.699-18.3-3.6C2.1 25.2 2 25 2 24.9V16c0-.1.1-.3.2-.3 2.6-.9 10.6-3.6 18.2-3.6 7.5 0 15.899 2.7 18.5 3.6.1 0 .2.2.2.3v8.9z"/><path d="M18.7 24l6.4-3.7c.3-.2.3-.7 0-.8l-6.4-3.8c-.3-.2-.7 0-.7.4v7.4c0 .5.4.7.7.5z"/>\x3c!--Created by Nick Bluth from the Noun Project--\x3e</svg>',n.ICONS["stereo.svg"]='<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 -2 16 16"><path d="M13.104 0H2.896C2.332 0 1 .392 1 .875h14C15 .392 13.668 0 13.104 0zM15 1H1a1 1 0 0 0-1 1v8a1 1 0 0 0 1 1h3.534a2 2 0 0 0 1.821-1.172l1.19-2.618a.5.5 0 0 1 .91 0l1.19 2.618A2 2 0 0 0 11.466 11H15a1 1 0 0 0 1-1V2a1 1 0 0 0-1-1zM4 7a2 2 0 1 1 0-4 2 2 0 0 1 0 4zm8 0a2 2 0 1 1 0-4 2 2 0 0 1 0 4z"/>\x3c!--Created by Idevã Batista from the Noun Project--\x3e</svg>',n.ICONS["zoom-in.svg"]='<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"><path d="M14.043 12.22a7.738 7.738 0 1 0-1.823 1.822l4.985 4.985c.503.504 1.32.504 1.822 0a1.285 1.285 0 0 0 0-1.822l-4.984-4.985zm-6.305 1.043a5.527 5.527 0 1 1 0-11.053 5.527 5.527 0 0 1 0 11.053z"/><path d="M8.728 4.009H6.744v2.737H4.006V8.73h2.738v2.736h1.984V8.73h2.737V6.746H8.728z"/>\x3c!--Created by Ryan Canning from the Noun Project--\x3e</svg>',n.ICONS["zoom-out.svg"]='<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"><path d="M14.043 12.22a7.738 7.738 0 1 0-1.823 1.822l4.985 4.985c.503.504 1.32.504 1.822 0a1.285 1.285 0 0 0 0-1.822l-4.984-4.985zm-6.305 1.043a5.527 5.527 0 1 1 0-11.053 5.527 5.527 0 0 1 0 11.053z"/><path d="M4.006 6.746h7.459V8.73H4.006z"/>\x3c!--Created by Ryan Canning from the Noun Project--\x3e</svg>',n});