/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger.streampane;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;

public class Stream {
    private static final Log LOG = LogFactory.getLog(Stream.class);
    public static final String UNFILTERED = "Unfiltered";
    public static final String IMAGE = "Image";
    private final COSStream strm;
    private final boolean isThumb;
    private final boolean isImage;
    private final boolean isXmlMetadata;
    private final Map<String, List<String>> filters;

    Stream(COSStream cosStream, boolean isThumb) {
        this.strm = cosStream;
        this.isThumb = isThumb;
        this.isImage = this.isImageStream(cosStream, isThumb);
        this.isXmlMetadata = this.isXmlMetadataStream(cosStream);
        this.filters = this.createFilterList(cosStream);
    }

    public boolean isImage() {
        return this.isImage;
    }

    public boolean isXmlMetadata() {
        return this.isXmlMetadata;
    }

    public List<String> getFilterList() {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, List<String>> entry : this.filters.entrySet()) {
            list.add(entry.getKey());
        }
        return list;
    }

    private String getFilteredLabel() {
        StringBuilder sb = new StringBuilder();
        COSBase base = this.strm.getFilters();
        if (base instanceof COSName) {
            sb.append(((COSName)base).getName());
        } else if (base instanceof COSArray) {
            COSArray filterArray = (COSArray)base;
            for (int i = 0; i < filterArray.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(((COSName)filterArray.get(i)).getName());
            }
        }
        return "Filtered (" + sb.toString() + ")";
    }

    public InputStream getStream(String key) {
        try {
            if (UNFILTERED.equals(key)) {
                return this.strm.createInputStream();
            }
            if (this.getFilteredLabel().equals(key)) {
                return this.strm.createRawInputStream();
            }
            return new PDStream(this.strm).createInputStream(this.filters.get(key));
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), e);
            return null;
        }
    }

    public BufferedImage getImage(PDResources resources) {
        try {
            PDImageXObject imageXObject = this.isThumb ? PDImageXObject.createThumbnail(this.strm) : new PDImageXObject(new PDStream(this.strm), resources);
            return imageXObject.getImage();
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), e);
            return null;
        }
    }

    private Map<String, List<String>> createFilterList(COSStream stream) {
        LinkedHashMap<String, List<String>> filterList = new LinkedHashMap<String, List<String>>();
        if (this.isImage) {
            filterList.put(IMAGE, null);
        }
        filterList.put(UNFILTERED, null);
        PDStream pdStream = new PDStream(stream);
        if (pdStream.getFilters() != null) {
            int filtersSize = pdStream.getFilters().size();
            for (int i = filtersSize - 1; i >= 1; --i) {
                filterList.put(this.getPartialStreamCommand(i), this.getStopFilterList(i));
            }
            filterList.put(this.getFilteredLabel(), null);
        }
        return filterList;
    }

    private String getPartialStreamCommand(int indexOfStopFilter) {
        List<COSName> availableFilters = new PDStream(this.strm).getFilters();
        StringBuilder nameListBuilder = new StringBuilder();
        for (int i = indexOfStopFilter; i < availableFilters.size(); ++i) {
            nameListBuilder.append(availableFilters.get(i).getName()).append(" & ");
        }
        nameListBuilder.delete(nameListBuilder.lastIndexOf("&"), nameListBuilder.length());
        return "Keep " + nameListBuilder.toString() + "...";
    }

    private List<String> getStopFilterList(int stopFilterIndex) {
        List<COSName> availableFilters = new PDStream(this.strm).getFilters();
        ArrayList<String> stopFilters = new ArrayList<String>(1);
        stopFilters.add(availableFilters.get(stopFilterIndex).getName());
        return stopFilters;
    }

    private boolean isImageStream(COSDictionary dic, boolean isThumb) {
        if (isThumb) {
            return true;
        }
        return dic.containsKey(COSName.SUBTYPE) && dic.getCOSName(COSName.SUBTYPE).equals(COSName.IMAGE);
    }

    private boolean isXmlMetadataStream(COSDictionary dic) {
        return dic.containsKey(COSName.SUBTYPE) && dic.getCOSName(COSName.SUBTYPE).equals(COSName.getPDFName("XML"));
    }
}

