/*
 * Decompiled with CFR 0.152.
 */
package gui;

import core.RecipeList;
import gui.AboutDialog;
import gui.I18n;
import gui.MainWindow;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class MenuListener
implements ActionListener {
    private MainWindow main_window;
    private AboutDialog about_dialog;
    private FileFilter html_file_filter = new FileFilter(){

        @Override
        public boolean accept(File arg0) {
            if (arg0.isDirectory()) {
                return true;
            }
            return arg0.getName().endsWith(".html");
        }

        @Override
        public String getDescription() {
            return I18n.tr("html_file");
        }
    };
    private FileFilter markdown_file_filter = new FileFilter(){

        @Override
        public boolean accept(File arg0) {
            if (arg0.isDirectory()) {
                return true;
            }
            if (arg0.getName().endsWith(".md")) {
                return true;
            }
            return arg0.getName().endsWith(".markdown");
        }

        @Override
        public String getDescription() {
            return I18n.tr("markdown_file");
        }
    };
    private FileFilter xml_file_filter = new FileFilter(){

        @Override
        public boolean accept(File arg0) {
            if (arg0.isDirectory()) {
                return true;
            }
            return arg0.getName().endsWith(".xml");
        }

        @Override
        public String getDescription() {
            return I18n.tr("xml_file");
        }
    };
    private FileFilter json_file_filter = new FileFilter(){

        @Override
        public boolean accept(File arg0) {
            return arg0.isDirectory();
        }

        @Override
        public String getDescription() {
            return I18n.tr("json_file");
        }
    };
    private FileFilter pdf_file_filter = new FileFilter(){

        @Override
        public boolean accept(File arg0) {
            if (arg0.isDirectory()) {
                return true;
            }
            return arg0.getName().endsWith(".pdf");
        }

        @Override
        public String getDescription() {
            return I18n.tr("pdf_file");
        }
    };

    public MenuListener(MainWindow mw) {
        this.main_window = mw;
        this.about_dialog = new AboutDialog(mw);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        switch (e.getActionCommand()) {
            case "about": {
                this.about_dialog.setLocationRelativeTo(this.main_window);
                this.about_dialog.setVisible(true);
                break;
            }
            case "close": {
                this.main_window.setVisible(false);
                break;
            }
            case "new": {
                this.main_window.rl.clear();
                this.main_window.old_rl = (RecipeList)this.main_window.rl.clone();
                this.main_window.mntmSaveAs.setEnabled(true);
                this.main_window.mntmSave.setEnabled(false);
                this.main_window.txtpnRecipeview.setText(I18n.tr("No recipe selected"));
                this.main_window.list.clearSelection();
                this.main_window.tabbed_pane.setSelectedIndex(0);
                this.main_window.delete_button.setEnabled(false);
                break;
            }
            case "open": {
                JFileChooser chooser = new JFileChooser();
                int returnVal = chooser.showDialog(this.main_window, I18n.tr("Open"));
                if (returnVal != 0) break;
                try {
                    this.main_window.rl.open(chooser.getSelectedFile().getAbsolutePath());
                    this.main_window.old_rl = (RecipeList)this.main_window.rl.clone();
                    this.main_window.mntmSave.setEnabled(true);
                    this.main_window.mntmSaveAs.setEnabled(true);
                    this.main_window.txtpnRecipeview.setText(I18n.tr("No recipe selected"));
                    this.main_window.list.clearSelection();
                    this.main_window.delete_button.setEnabled(false);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    JOptionPane opt = new JOptionPane(I18n.tr("FileNotValid"), 0, -1);
                    JDialog jd = opt.createDialog(this.main_window, I18n.tr("Error"));
                    jd.setVisible(true);
                    this.main_window.mntmSave.setEnabled(false);
                }
                break;
            }
            case "save": {
                try {
                    this.main_window.rl.save();
                    this.main_window.old_rl = (RecipeList)this.main_window.rl.clone();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    JOptionPane opt = new JOptionPane(I18n.tr("FileNotValid"), 0, -1);
                    JDialog jd = opt.createDialog(this.main_window, I18n.tr("Error"));
                    jd.setVisible(true);
                }
                break;
            }
            case "save_as": {
                JFileChooser save_chooser = new JFileChooser();
                int returnVal2 = save_chooser.showDialog(this.main_window, I18n.tr("Save"));
                if (returnVal2 != 0) break;
                try {
                    this.main_window.rl.save(save_chooser.getSelectedFile().getAbsolutePath());
                    this.main_window.old_rl = (RecipeList)this.main_window.rl.clone();
                    this.main_window.mntmSave.setEnabled(true);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    JOptionPane opt = new JOptionPane(I18n.tr("FileNotValid"), 0, -1);
                    JDialog jd = opt.createDialog(this.main_window, I18n.tr("Error"));
                    jd.setVisible(true);
                }
                break;
            }
            case "export": {
                JOptionPane opt;
                JDialog jd;
                JOptionPane opt2;
                JFileChooser export_chooser = new JFileChooser();
                export_chooser.setAcceptAllFileFilterUsed(false);
                export_chooser.addChoosableFileFilter(this.html_file_filter);
                export_chooser.addChoosableFileFilter(this.markdown_file_filter);
                export_chooser.addChoosableFileFilter(this.xml_file_filter);
                export_chooser.addChoosableFileFilter(this.pdf_file_filter);
                export_chooser.addChoosableFileFilter(this.json_file_filter);
                export_chooser.setFileSelectionMode(2);
                int returnVal3 = export_chooser.showDialog(this.main_window, I18n.tr("Export"));
                if (returnVal3 != 0) break;
                File selected_file = export_chooser.getSelectedFile();
                if (selected_file.exists() && selected_file.isFile()) {
                    opt2 = new JOptionPane(String.valueOf(I18n.tr("Overwrite?")) + "(" + selected_file.getAbsolutePath() + ")", 3, 0);
                    jd = opt2.createDialog(this.main_window, I18n.tr("OverwriteFile"));
                    jd.setVisible(true);
                    if (opt2.getValue() == Integer.valueOf(1)) break;
                }
                try {
                    if (export_chooser.getFileFilter().equals(this.json_file_filter)) {
                        if (!selected_file.isDirectory()) {
                            opt2 = new JOptionPane(I18n.tr("ExportErrorNeedFolder"), 0, -1);
                            jd = opt2.createDialog(this.main_window, I18n.tr("Error"));
                            jd.setVisible(true);
                            break;
                        }
                        this.main_window.rl.exportToJson(selected_file.getAbsolutePath());
                        break;
                    }
                    if (selected_file.exists() && !selected_file.isFile()) {
                        opt2 = new JOptionPane(I18n.tr("ExportErrorNeedFile"), 0, -1);
                        jd = opt2.createDialog(this.main_window, I18n.tr("Error"));
                        jd.setVisible(true);
                        break;
                    }
                    if (export_chooser.getFileFilter().equals(this.html_file_filter)) {
                        this.main_window.rl.exportToHtml(selected_file.getAbsolutePath());
                        break;
                    }
                    if (export_chooser.getFileFilter().equals(this.xml_file_filter)) {
                        this.main_window.rl.exportToXml(selected_file.getAbsolutePath());
                        break;
                    }
                    if (export_chooser.getFileFilter().equals(this.markdown_file_filter)) {
                        this.main_window.rl.exportToMarkdown(selected_file.getAbsolutePath());
                        break;
                    }
                    this.main_window.rl.exportToPdf(selected_file.getAbsolutePath());
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    opt = new JOptionPane(I18n.tr("FileNotValid"), 0, -1);
                    JDialog jd2 = opt.createDialog(this.main_window, I18n.tr("Error"));
                    jd2.setVisible(true);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    opt = new JOptionPane(I18n.tr("ExportError"), 0, -1);
                    JDialog jd3 = opt.createDialog(this.main_window, I18n.tr("Error"));
                    jd3.setVisible(true);
                }
                break;
            }
        }
    }
}

