/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger.pagepane;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.debugger.PDFDebugger;
import org.apache.pdfbox.debugger.ui.HighResolutionImageIcon;
import org.apache.pdfbox.debugger.ui.ImageUtil;
import org.apache.pdfbox.debugger.ui.RotationMenu;
import org.apache.pdfbox.debugger.ui.ZoomMenu;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.rendering.PDFRenderer;

public class PagePane
implements ActionListener,
AncestorListener,
MouseMotionListener,
MouseListener {
    private JPanel panel;
    private int pageIndex = -1;
    private final PDDocument document;
    private JLabel label;
    private ZoomMenu zoomMenu;
    private RotationMenu rotationMenu;
    private final JLabel statuslabel;
    private final PDPage page;
    private String labelText = "";
    private final Map<PDRectangle, String> rectMap = new HashMap<PDRectangle, String>();
    private final AffineTransform defaultTransform = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getDefaultTransform();

    public PagePane(PDDocument document, COSDictionary pageDict, JLabel statuslabel) {
        this.page = new PDPage(pageDict);
        this.pageIndex = document.getPages().indexOf(this.page);
        this.document = document;
        this.statuslabel = statuslabel;
        this.initUI();
        this.initRectMap();
    }

    private void initRectMap() {
        PDAcroForm acroForm = this.document.getDocumentCatalog().getAcroForm();
        if (acroForm == null) {
            return;
        }
        for (PDField field : acroForm.getFieldTree()) {
            String fullyQualifiedName = field.getFullyQualifiedName();
            for (PDAnnotationWidget widget : field.getWidgets()) {
                if (!this.page.equals(widget.getPage())) continue;
                this.rectMap.put(widget.getRectangle(), fullyQualifiedName);
            }
        }
    }

    private void initUI() {
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        String pageLabelText = this.pageIndex < 0 ? "Page number not found" : "Page " + (this.pageIndex + 1);
        String lbl = PDFDebugger.getPageLabel(this.document, this.pageIndex);
        if (lbl != null) {
            pageLabelText = pageLabelText + " - " + lbl;
        }
        JLabel pageLabel = new JLabel(pageLabelText);
        pageLabel.setAlignmentX(0.5f);
        pageLabel.setFont(new Font("Monospaced", 1, 30));
        pageLabel.setBackground(Color.GREEN);
        this.panel.add(pageLabel);
        this.label = new JLabel();
        this.label.addMouseMotionListener(this);
        this.label.addMouseListener(this);
        this.label.setBackground(this.panel.getBackground());
        this.label.setAlignmentX(0.5f);
        this.panel.add(this.label);
        this.panel.addAncestorListener(this);
        this.zoomMenu = ZoomMenu.getInstance();
        this.zoomMenu.changeZoomSelection(this.zoomMenu.getPageZoomScale());
        this.startRendering();
    }

    public Component getPanel() {
        return this.panel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String actionCommand = actionEvent.getActionCommand();
        if (ZoomMenu.isZoomMenu(actionCommand) || RotationMenu.isRotationMenu(actionCommand) || actionEvent.getSource() == PDFDebugger.allowSubsampling) {
            this.startRendering();
            this.zoomMenu.setPageZoomScale(ZoomMenu.getZoomScale());
        }
    }

    private void startRendering() {
        new RenderWorker(ZoomMenu.getZoomScale(), RotationMenu.getRotationDegrees(), PDFDebugger.allowSubsampling.isSelected()).execute();
        this.zoomMenu.setPageZoomScale(ZoomMenu.getZoomScale());
    }

    @Override
    public void ancestorAdded(AncestorEvent ancestorEvent) {
        this.zoomMenu.addMenuListeners(this);
        this.zoomMenu.setEnableMenu(true);
        this.rotationMenu = RotationMenu.getInstance();
        this.rotationMenu.addMenuListeners(this);
        this.rotationMenu.setEnableMenu(true);
        PDFDebugger.allowSubsampling.setEnabled(true);
        PDFDebugger.allowSubsampling.addActionListener(this);
    }

    @Override
    public void ancestorRemoved(AncestorEvent ancestorEvent) {
        this.zoomMenu.setEnableMenu(false);
        this.rotationMenu.setEnableMenu(false);
        PDFDebugger.allowSubsampling.setEnabled(false);
        PDFDebugger.allowSubsampling.removeActionListener(this);
    }

    @Override
    public void ancestorMoved(AncestorEvent ancestorEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int y1;
        int x1;
        float height = this.page.getCropBox().getHeight();
        float width = this.page.getCropBox().getWidth();
        float offsetX = this.page.getCropBox().getLowerLeftX();
        float offsetY = this.page.getCropBox().getLowerLeftY();
        float zoomScale = this.zoomMenu.getPageZoomScale();
        float x = (float)e.getX() / zoomScale * (float)this.defaultTransform.getScaleX();
        float y = (float)e.getY() / zoomScale * (float)this.defaultTransform.getScaleY();
        switch ((RotationMenu.getRotationDegrees() + this.page.getRotation()) % 360) {
            case 90: {
                x1 = (int)(y + offsetX);
                y1 = (int)(x + offsetY);
                break;
            }
            case 180: {
                x1 = (int)(width - x + offsetX);
                y1 = (int)(y - offsetY);
                break;
            }
            case 270: {
                x1 = (int)(width - y + offsetX);
                y1 = (int)(height - x + offsetY);
                break;
            }
            default: {
                x1 = (int)(x + offsetX);
                y1 = (int)(height - y + offsetY);
            }
        }
        String text = "x: " + x1 + ", y: " + y1;
        for (Map.Entry<PDRectangle, String> entry : this.rectMap.entrySet()) {
            if (!entry.getKey().contains(x1, y1)) continue;
            text = text + ", field: " + this.rectMap.get(entry.getKey());
            break;
        }
        this.statuslabel.setText(text);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.statuslabel.setText(this.labelText);
    }

    private final class RenderWorker
    extends SwingWorker<BufferedImage, Integer> {
        private final float scale;
        private final int rotation;
        private final boolean allowSubsampling;

        private RenderWorker(float scale, int rotation, boolean allowSubsampling) {
            this.scale = scale;
            this.rotation = rotation;
            this.allowSubsampling = allowSubsampling;
        }

        @Override
        protected BufferedImage doInBackground() throws IOException {
            PagePane.this.label.setIcon(null);
            PagePane.this.labelText = "Rendering...";
            PagePane.this.label.setText(PagePane.this.labelText);
            PDFRenderer renderer = new PDFRenderer(PagePane.this.document);
            renderer.setSubsamplingAllowed(this.allowSubsampling);
            long t0 = System.currentTimeMillis();
            PagePane.this.statuslabel.setText(PagePane.this.labelText);
            BufferedImage bim = renderer.renderImage(PagePane.this.pageIndex, this.scale);
            float t = (float)(System.currentTimeMillis() - t0) / 1000.0f;
            PagePane.this.labelText = "Rendered in " + t + " second" + (t > 1.0f ? "s" : "");
            PagePane.this.statuslabel.setText(PagePane.this.labelText);
            return ImageUtil.getRotatedImage(bim, this.rotation);
        }

        @Override
        protected void done() {
            try {
                BufferedImage image = (BufferedImage)this.get();
                PagePane.this.label.setSize((int)Math.ceil((double)image.getWidth() / PagePane.this.defaultTransform.getScaleX()), (int)Math.ceil((double)image.getHeight() / PagePane.this.defaultTransform.getScaleY()));
                PagePane.this.label.setIcon(new HighResolutionImageIcon(image, PagePane.this.label.getWidth(), PagePane.this.label.getHeight()));
                PagePane.this.label.setText(null);
            }
            catch (InterruptedException e) {
                PagePane.this.label.setText(e.getMessage());
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                PagePane.this.label.setText(e.getMessage());
                throw new RuntimeException(e);
            }
        }
    }
}

