/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.Baking;
import core.Difficulty;
import core.I18n;
import core.Ingredient;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.jdom2.Attribute;
import org.jdom2.Element;

public class Recipe
implements Serializable,
Cloneable {
    private String name;
    private int time = 0;
    private List<Ingredient> ingredients;
    private Baking baking = Baking.None;
    private List<String> actions;
    private List<String> utensils;
    private Difficulty difficulty;
    private int grade = 0;
    private int nb_person = 0;
    private static final long serialVersionUID = 8267746199251258267L;

    public Recipe(String n) {
        this.name = n;
        this.ingredients = new ArrayList<Ingredient>();
        this.actions = new ArrayList<String>();
        this.utensils = new ArrayList<String>();
    }

    public Object clone() {
        Recipe r = new Recipe(this.name);
        r.time = this.time;
        r.baking = this.baking;
        r.grade = this.grade;
        r.difficulty = this.difficulty;
        r.nb_person = this.nb_person;
        for (Ingredient i : this.ingredients) {
            r.ingredients.add((Ingredient)i.clone());
        }
        for (String s : this.actions) {
            r.actions.add(s);
        }
        for (String s : this.utensils) {
            r.utensils.add(s);
        }
        return r;
    }

    public Element toXmlElement() {
        Element re = new Element("recipe");
        re.addContent(new Element("name").setText(this.name));
        re.addContent(new Element("time").setText(new Integer(this.time).toString()));
        re.addContent(new Element("difficulty").setText(new Integer(this.difficulty.toInt()).toString()));
        re.addContent(new Element("grade").setText(new Integer(this.grade).toString()));
        re.addContent(new Element("nb_person").setText(new Integer(this.nb_person).toString()));
        re.addContent(new Element("baking").setText(new Integer(this.baking.toInt()).toString()));
        Element ingredients_list = new Element("ingredients_list");
        re.addContent(ingredients_list);
        for (Ingredient i : this.ingredients) {
            ingredients_list.addContent(i.toXmlElement());
        }
        Element ustensil_list = new Element("ustensils_list");
        re.addContent(ustensil_list);
        for (String s : this.utensils) {
            Element ustensil = new Element("ustensil");
            ustensil.setText(s);
            ustensil_list.addContent(ustensil);
        }
        Element actions_list = new Element("actions_list");
        re.addContent(actions_list);
        Integer i = 0;
        for (String s : this.actions) {
            Element action = new Element("action");
            action.setAttribute(new Attribute("order", i.toString()));
            action.setText(s);
            actions_list.addContent(action);
            i = i + 1;
        }
        return re;
    }

    public List<PDPage> toPdfPage(PDDocument doc) throws IOException {
        float width = PDRectangle.A4.getWidth();
        float height = PDRectangle.A4.getHeight();
        float margin = 40.0f;
        PdfTextWriter writer = new PdfTextWriter(height);
        PDType1Font font_title = PDType1Font.TIMES_BOLD;
        int font_size = 12;
        InputStream input = this.getClass().getClassLoader().getResourceAsStream("org/apache/pdfbox/resources/ttf/LiberationSans-Regular.ttf");
        PDType0Font font = PDType0Font.load(doc, input);
        writer.addPage(doc);
        writer.begin();
        writer.setFont(font_title, 28.0f);
        writer.newLineAtOffset((width - writer.getStringWidth(this.name)) / 2.0f, height - writer.getLineHeight() - 40.0f);
        writer.write(this.name);
        writer.end();
        writer.begin();
        writer.setFont(font, 12.0f);
        writer.newLineAtOffset(40.0f, height - 120.0f);
        writer.write(String.valueOf(I18n.tr("PreparationTime")) + this.time + " " + I18n.tr("Minutes"));
        writer.newLine();
        writer.write(String.valueOf(I18n.tr("Difficulty")) + this.difficulty);
        writer.newLine();
        writer.write(String.valueOf(I18n.tr("Baking")) + this.baking);
        writer.newLine();
        writer.write(String.valueOf(I18n.tr("Grade")) + this.grade);
        writer.newLine();
        writer.newLine();
        writer.write(String.valueOf(I18n.tr("Ingredients1")) + this.nb_person + I18n.tr("Ingredients2"));
        for (Ingredient ing : this.ingredients) {
            writer.newLine();
            writer.write("    \u2022 " + ing.toString());
        }
        if (!this.utensils.isEmpty()) {
            writer.newLine();
            writer.newLine();
            writer.write(I18n.tr("Ustensils"));
            for (String s : this.utensils) {
                writer.newLine();
                writer.write("    \u2022 " + s);
            }
        }
        writer.newLine();
        writer.newLine();
        writer.write(I18n.tr("Preparation"));
        for (String a : this.actions) {
            boolean first_line = true;
            int size = a.length();
            StringBuffer sb = new StringBuffer(a);
            if (writer.getPosition() < 40.0f) {
                writer.end();
                writer.addPage(doc);
                writer.setFont(font, 12.0f);
                writer.begin();
                writer.newLineAtOffset(40.0f, height - 40.0f - writer.getLineHeight());
            } else {
                writer.newLine();
            }
            while (sb.length() > 0) {
                float text_width = writer.getStringWidth("      " + sb.substring(1, size));
                if (text_width < width - 80.0f && (sb.charAt(size - 1) == ' ' || size == sb.length())) {
                    if (first_line) {
                        first_line = false;
                        writer.write("    \u2022 " + sb.substring(0, size));
                    } else {
                        writer.newLine();
                        writer.write("      " + sb.substring(0, size));
                    }
                    sb.delete(0, size);
                    size = sb.length();
                    continue;
                }
                --size;
            }
        }
        writer.end();
        writer.close();
        return writer.getPages();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public List<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public void setIngredients(List<Ingredient> ingredients) {
        this.ingredients = ingredients;
    }

    public Baking getBaking() {
        return this.baking;
    }

    public void setBaking(Baking baking) {
        this.baking = baking;
    }

    public List<String> getActions() {
        return this.actions;
    }

    public void setActions(List<String> actions) {
        this.actions = actions;
    }

    public List<String> getUtensils() {
        return this.utensils;
    }

    public void setUtensils(List<String> utensils) {
        this.utensils = utensils;
    }

    public Difficulty getDifficulty() {
        return this.difficulty;
    }

    public void setDifficulty(Difficulty difficulty) {
        this.difficulty = difficulty;
    }

    public int getGrade() {
        return this.grade;
    }

    public void setGrade(int grade) {
        this.grade = grade;
    }

    public int getNb_person() {
        return this.nb_person;
    }

    public void setNb_person(int nb_person) {
        this.nb_person = nb_person;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.actions == null ? 0 : this.actions.hashCode());
        result = 31 * result + (this.baking == null ? 0 : this.baking.hashCode());
        result = 31 * result + (this.difficulty == null ? 0 : this.difficulty.hashCode());
        result = 31 * result + this.grade;
        result = 31 * result + (this.ingredients == null ? 0 : this.ingredients.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.time;
        result = 31 * result + this.nb_person;
        result = 31 * result + (this.utensils == null ? 0 : this.utensils.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Recipe other = (Recipe)obj;
        if (this.actions == null ? other.actions != null : !this.actions.equals(other.actions)) {
            return false;
        }
        if (this.baking != other.baking) {
            return false;
        }
        if (this.difficulty != other.difficulty) {
            return false;
        }
        if (this.grade != other.grade) {
            return false;
        }
        if (this.ingredients == null ? other.ingredients != null : !this.ingredients.equals(other.ingredients)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.time != other.time) {
            return false;
        }
        if (this.nb_person != other.nb_person) {
            return false;
        }
        return !(this.utensils == null ? other.utensils != null : !this.utensils.equals(other.utensils));
    }

    public String toString() {
        StringBuffer sf = new StringBuffer();
        sf.append(String.valueOf(this.name) + "\n");
        sf.append(String.valueOf(I18n.tr("PreparationTime")) + this.time + " " + I18n.tr("Minutes") + "\n");
        sf.append(String.valueOf(I18n.tr("Difficulty")) + this.difficulty + "\n");
        sf.append(String.valueOf(I18n.tr("Grade")) + this.grade + "\n");
        sf.append(String.valueOf(I18n.tr("Baking")) + this.baking + "\n");
        sf.append(String.valueOf(I18n.tr("Ingredients1")) + this.nb_person + I18n.tr("Ingredients2") + "\n");
        for (Ingredient i : this.ingredients) {
            sf.append(" - " + i.toString() + "\n");
        }
        if (!this.utensils.isEmpty()) {
            sf.append(String.valueOf(I18n.tr("Ustensils")) + "\n");
            for (String s : this.utensils) {
                sf.append(" - " + s + "\n");
            }
        }
        sf.append(String.valueOf(I18n.tr("Preparation")) + "\n");
        for (String s : this.actions) {
            sf.append(" - " + s + "\n");
        }
        return sf.toString();
    }

    public String toHTMLString() {
        StringBuffer sf = new StringBuffer();
        sf.append("<html>");
        sf.append("<b><font size=\"6\"><center>" + this.name + "</center></font></b>");
        sf.append("<p>" + I18n.tr("PreparationTime") + this.time + " " + I18n.tr("Minutes") + "<br>");
        sf.append(String.valueOf(I18n.tr("Difficulty")) + this.difficulty + "<br>");
        sf.append(String.valueOf(I18n.tr("Grade")) + this.grade + "<br>");
        sf.append(String.valueOf(I18n.tr("Baking")) + this.baking + "</p>");
        sf.append("<p>" + I18n.tr("Ingredients1") + this.nb_person + I18n.tr("Ingredients2") + "<br><ul>");
        for (Ingredient i : this.ingredients) {
            sf.append("<li>" + i.toString() + "</li>");
        }
        sf.append("</ul></p>");
        if (!this.utensils.isEmpty()) {
            sf.append("<p>" + I18n.tr("Ustensils") + "<br><ul>");
            for (String s : this.utensils) {
                sf.append("<li>" + s + "</li>");
            }
            sf.append("</ul></p>");
        }
        sf.append("<p>" + I18n.tr("Preparation") + "<br><ul>");
        for (String s : this.actions) {
            sf.append("<li>" + s + "</li>");
        }
        sf.append("</ul></p>");
        sf.append("</html>");
        return sf.toString();
    }

    public String toMarkdownString() {
        StringBuffer sf = new StringBuffer();
        sf.append("#" + this.name + System.lineSeparator() + System.lineSeparator());
        sf.append(String.valueOf(I18n.tr("PreparationTime")) + this.time + " " + I18n.tr("Minutes") + System.lineSeparator());
        sf.append(String.valueOf(I18n.tr("Difficulty")) + this.difficulty + System.lineSeparator());
        sf.append(String.valueOf(I18n.tr("Grade")) + this.grade + System.lineSeparator());
        sf.append(String.valueOf(I18n.tr("Baking")) + this.baking + System.lineSeparator() + System.lineSeparator());
        sf.append(String.valueOf(I18n.tr("Ingredients1")) + this.nb_person + I18n.tr("Ingredients2") + System.lineSeparator() + System.lineSeparator());
        for (Ingredient i : this.ingredients) {
            sf.append("* " + i.toString() + System.lineSeparator());
        }
        sf.append(System.lineSeparator());
        if (!this.utensils.isEmpty()) {
            sf.append(String.valueOf(I18n.tr("Ustensils")) + System.lineSeparator() + System.lineSeparator());
            for (String s : this.utensils) {
                sf.append("* " + s + System.lineSeparator());
            }
            sf.append(System.lineSeparator());
        }
        sf.append(String.valueOf(I18n.tr("Preparation")) + System.lineSeparator() + System.lineSeparator());
        for (String s : this.actions) {
            sf.append("* " + s + System.lineSeparator());
        }
        sf.append(System.lineSeparator());
        return sf.toString();
    }

    private class PdfTextWriter {
        private float position;
        private float leading;
        private List<PDPage> pages;
        private PDPageContentStream content = null;
        private PDFont font;
        float font_size;

        public PdfTextWriter(float h) {
            this.position = h;
            this.pages = new ArrayList<PDPage>();
        }

        public void addPage(PDDocument doc) throws IOException {
            this.close();
            PDPage page = new PDPage(PDRectangle.A4);
            this.pages.add(page);
            this.content = new PDPageContentStream(doc, page);
        }

        public void begin() throws IOException {
            this.content.beginText();
        }

        public void end() throws IOException {
            this.content.endText();
        }

        public void setFont(PDFont f, float fontSize) throws IOException {
            this.content.setFont(f, fontSize);
            this.content.setLeading(fontSize + 1.0f);
            this.font = f;
            this.font_size = fontSize;
            this.leading = this.getLineHeight();
        }

        public float getLineHeight() {
            return this.font.getFontDescriptor().getFontBoundingBox().getHeight() / 1000.0f * (this.font_size + 1.0f) * 0.82f;
        }

        public float getStringWidth(String text) throws IOException {
            return this.font.getStringWidth(text) / 1000.0f * this.font_size;
        }

        public void newLine() throws IOException {
            this.position -= this.leading;
            this.content.newLine();
        }

        public void newLineAtOffset(float tx, float ty) throws IOException {
            this.content.newLineAtOffset(tx, ty);
            this.position = ty;
        }

        public void write(String text) throws IOException {
            this.content.showText(text);
        }

        public float getPosition() {
            return this.position;
        }

        public void close() throws IOException {
            if (this.content != null) {
                this.content.close();
            }
        }

        public List<PDPage> getPages() throws IOException {
            return this.pages;
        }
    }
}

