/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.I18n;
import core.Unit;
import java.io.Serializable;
import org.jdom2.Element;

public class Ingredient
implements Serializable,
Cloneable {
    private double quantity;
    private Unit unit;
    private String name;
    private String comment;
    private static final long serialVersionUID = -6929041792870716120L;

    public Ingredient(double q, Unit u, String n, String c) {
        this.quantity = q;
        this.unit = u;
        this.name = n;
        this.comment = c;
    }

    public Ingredient() {
        this(0.0, Unit.Gramme, "", "");
    }

    public Ingredient(String n) {
        this(0.0, Unit.Gramme, n, "");
    }

    public String toString() {
        StringBuffer sf = new StringBuffer();
        if (this.unit != Unit.NoQuantity) {
            if (this.quantity == (double)((int)this.quantity)) {
                sf.append((int)this.quantity);
            } else {
                sf.append(this.quantity);
            }
            if (this.unit == Unit.Gramme || this.unit == Unit.Litre || this.unit == Unit.Millilitre) {
                sf.append(String.valueOf(this.unit.toString()) + " " + I18n.tr("of"));
            } else if (this.unit != Unit.None) {
                sf.append(" " + this.unit.toString() + " " + I18n.tr("of"));
            }
            sf.append(" ");
        }
        sf.append(this.name);
        if (!this.comment.isEmpty()) {
            sf.append(" (" + this.comment + ")");
        }
        return sf.toString();
    }

    public Object clone() {
        Ingredient i = new Ingredient();
        i.quantity = this.quantity;
        i.unit = this.unit;
        i.name = this.name;
        i.comment = this.comment;
        return i;
    }

    public Element toXmlElement() {
        Element ie = new Element("ingredient");
        ie.addContent(new Element("quantity").setText(new Double(this.quantity).toString()));
        ie.addContent(new Element("unit").setText(new Integer(this.unit.toInt()).toString()));
        ie.addContent(new Element("name").setText(this.name));
        ie.addContent(new Element("comment").setText(this.comment));
        return ie;
    }

    public double getQuantity() {
        return this.quantity;
    }

    public void setQuantity(double quantity) {
        this.quantity = quantity;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.comment == null ? 0 : this.comment.hashCode());
        result = (int)((double)(31 * result) + this.quantity);
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Ingredient other = (Ingredient)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.comment == null ? other.comment != null : !this.comment.equals(other.comment)) {
            return false;
        }
        if (this.quantity != other.quantity) {
            return false;
        }
        return this.unit == other.unit;
    }
}

