/*
 * Decompiled with CFR 0.152.
 */
package gui;

import core.Baking;
import core.Difficulty;
import core.Ingredient;
import core.Recipe;
import core.Unit;
import gui.I18n;
import gui.MainWindow;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TabbedListener
implements ChangeListener {
    private MainWindow main_window;
    private JPanel edit_panel;
    private Recipe r;
    private JTextField name_textfield;
    private DocumentListener name_listener = new DocumentListener(){

        @Override
        public void changedUpdate(DocumentEvent arg0) {
            this.saveChange();
        }

        @Override
        public void insertUpdate(DocumentEvent arg0) {
            this.saveChange();
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
            this.saveChange();
        }

        private void saveChange() {
            TabbedListener.this.r.setName(TabbedListener.this.name_textfield.getText());
            ((TabbedListener)TabbedListener.this).main_window.rl.notifyChangment();
        }
    };
    private JSpinner time_spinner;
    private ChangeListener time_listener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            TabbedListener.this.r.setTime((Integer)TabbedListener.this.time_spinner.getValue());
        }
    };
    private JComboBox<Difficulty> difficulty_combobox;
    private ActionListener difficulty_listener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            TabbedListener.this.r.setDifficulty((Difficulty)TabbedListener.this.difficulty_combobox.getSelectedItem());
        }
    };
    private JComboBox<Baking> baking_combobox;
    private ActionListener baking_listener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            TabbedListener.this.r.setBaking((Baking)TabbedListener.this.baking_combobox.getSelectedItem());
        }
    };
    private JSpinner grade_spinner;
    private ChangeListener grade_listener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            TabbedListener.this.r.setGrade((Integer)TabbedListener.this.grade_spinner.getValue());
        }
    };
    private JSpinner nb_person_spinner;
    private ChangeListener nb_person_listener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            TabbedListener.this.r.setNb_person((Integer)TabbedListener.this.nb_person_spinner.getValue());
        }
    };
    private static final int ing_textfield_size = 12;
    private JPanel ingredients_panel;
    private ArrayList<JTextField> ingredient_name_textfields;
    private ArrayList<JTextField> ingredient_note_textfields;
    private ArrayList<JComboBox<Unit>> ingredient_combobox;
    private ArrayList<JSpinner> ingredient_spinner;
    private ArrayList<JButton> ingredients_remove_buttons;
    private ActionListener ingredient_add_listener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            String str = I18n.tr("NewIngredient");
            Ingredient ing = new Ingredient(str);
            TabbedListener.this.r.getIngredients().add(ing);
            JPanel tmp_panel = new JPanel();
            JSpinner spin = new JSpinner(new SpinnerNumberModel(0.0, 0.0, Double.MAX_VALUE, 0.1));
            spin.setValue(ing.getQuantity());
            ((JSpinner.DefaultEditor)spin.getEditor()).getTextField().setColumns(4);
            spin.addChangeListener(TabbedListener.this.ingredients_spinner_listener);
            TabbedListener.this.ingredient_spinner.add(spin);
            tmp_panel.add(spin);
            JComboBox<Unit> combo = new JComboBox<Unit>(Unit.values());
            combo.setSelectedItem(ing.getUnit());
            combo.addActionListener(TabbedListener.this.ingredients_combobox_listener);
            TabbedListener.this.ingredient_combobox.add(combo);
            tmp_panel.add(combo);
            JTextField txt = new JTextField();
            txt.setColumns(12);
            txt.setText(ing.getName());
            txt.setMaximumSize(txt.getPreferredSize());
            txt.getDocument().addDocumentListener(TabbedListener.this.ingredients_name_listener);
            TabbedListener.this.ingredient_name_textfields.add(txt);
            tmp_panel.add(txt);
            JTextField txt2 = new JTextField();
            txt2.setColumns(12);
            txt2.setText(ing.getComment());
            txt2.setMaximumSize(txt2.getPreferredSize());
            txt2.getDocument().addDocumentListener(TabbedListener.this.ingredients_note_listener);
            TabbedListener.this.ingredient_note_textfields.add(txt2);
            tmp_panel.add(txt2);
            JButton remove_button = new JButton(I18n.tr("Remove"));
            remove_button.setActionCommand(Integer.valueOf(TabbedListener.this.r.getIngredients().size() - 1).toString());
            remove_button.addActionListener(TabbedListener.this.ingredient_remove_listener);
            TabbedListener.this.ingredients_remove_buttons.add(remove_button);
            tmp_panel.add(remove_button);
            TabbedListener.this.ingredients_panel.add((Component)tmp_panel, TabbedListener.this.r.getIngredients().size());
            TabbedListener.this.ingredients_panel.revalidate();
            TabbedListener.this.ingredients_panel.repaint();
        }
    };
    private ActionListener ingredient_remove_listener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            int index = Integer.parseInt(e.getActionCommand());
            TabbedListener.this.ingredient_name_textfields.remove(index);
            TabbedListener.this.ingredient_combobox.remove(index);
            TabbedListener.this.ingredient_note_textfields.remove(index);
            TabbedListener.this.ingredient_spinner.remove(index);
            TabbedListener.this.ingredients_remove_buttons.remove(index);
            TabbedListener.this.r.getIngredients().remove(index);
            TabbedListener.this.ingredients_panel.remove(index + 1);
            TabbedListener.this.ingredients_panel.revalidate();
            TabbedListener.this.ingredients_panel.repaint();
            int i = 0;
            while (i < TabbedListener.this.r.getIngredients().size()) {
                ((JButton)TabbedListener.this.ingredients_remove_buttons.get(i)).setActionCommand(Integer.valueOf(i).toString());
                ++i;
            }
        }
    };
    private ActionListener ingredients_combobox_listener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            int i = 0;
            while (i < TabbedListener.this.r.getIngredients().size()) {
                TabbedListener.this.r.getIngredients().get(i).setUnit((Unit)((JComboBox)TabbedListener.this.ingredient_combobox.get(i)).getSelectedItem());
                ++i;
            }
        }
    };
    private ChangeListener ingredients_spinner_listener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            int i = 0;
            while (i < TabbedListener.this.r.getIngredients().size()) {
                TabbedListener.this.r.getIngredients().get(i).setQuantity((Double)((JSpinner)TabbedListener.this.ingredient_spinner.get(i)).getValue());
                ++i;
            }
        }
    };
    private DocumentListener ingredients_name_listener = new DocumentListener(){

        @Override
        public void changedUpdate(DocumentEvent arg0) {
            this.saveChange();
        }

        @Override
        public void insertUpdate(DocumentEvent arg0) {
            this.saveChange();
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
            this.saveChange();
        }

        private void saveChange() {
            int i = 0;
            while (i < TabbedListener.this.r.getIngredients().size()) {
                TabbedListener.this.r.getIngredients().get(i).setName(((JTextField)TabbedListener.this.ingredient_name_textfields.get(i)).getText());
                ++i;
            }
        }
    };
    private DocumentListener ingredients_note_listener = new DocumentListener(){

        @Override
        public void changedUpdate(DocumentEvent arg0) {
            this.saveChange();
        }

        @Override
        public void insertUpdate(DocumentEvent arg0) {
            this.saveChange();
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
            this.saveChange();
        }

        private void saveChange() {
            int i = 0;
            while (i < TabbedListener.this.r.getIngredients().size()) {
                TabbedListener.this.r.getIngredients().get(i).setComment(((JTextField)TabbedListener.this.ingredient_note_textfields.get(i)).getText());
                ++i;
            }
        }
    };
    private static final int textfield_size = 35;
    private JPanel ustensils_panel;
    private ArrayList<JTextField> ustensils_textfields;
    private ArrayList<JButton> ustensils_remove_buttons;
    private ActionListener ustensils_add_listener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JPanel tmp_panel = new JPanel();
            String str = I18n.tr("NewUstensil");
            TabbedListener.this.r.getUtensils().add(str);
            JTextField txt = new JTextField();
            txt.setColumns(35);
            txt.setText(str);
            txt.setMaximumSize(txt.getPreferredSize());
            txt.getDocument().addDocumentListener(TabbedListener.this.ustensils_listener);
            tmp_panel.add(txt);
            JButton remove_button = new JButton(I18n.tr("Remove"));
            remove_button.setActionCommand(Integer.valueOf(TabbedListener.this.r.getUtensils().size() - 1).toString());
            remove_button.addActionListener(TabbedListener.this.ustensils_remove_listener);
            TabbedListener.this.ustensils_remove_buttons.add(remove_button);
            tmp_panel.add(remove_button);
            TabbedListener.this.ustensils_textfields.add(txt);
            TabbedListener.this.ustensils_panel.add((Component)tmp_panel, TabbedListener.this.r.getUtensils().size());
            TabbedListener.this.ustensils_panel.revalidate();
            TabbedListener.this.ustensils_panel.repaint();
        }
    };
    private ActionListener ustensils_remove_listener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            int index = Integer.parseInt(e.getActionCommand());
            TabbedListener.this.ustensils_textfields.remove(index);
            TabbedListener.this.ustensils_remove_buttons.remove(index);
            TabbedListener.this.r.getUtensils().remove(index);
            TabbedListener.this.ustensils_panel.remove(index + 1);
            TabbedListener.this.ustensils_panel.revalidate();
            TabbedListener.this.ustensils_panel.repaint();
            int i = 0;
            while (i < TabbedListener.this.r.getUtensils().size()) {
                ((JButton)TabbedListener.this.ustensils_remove_buttons.get(i)).setActionCommand(Integer.valueOf(i).toString());
                ++i;
            }
        }
    };
    private DocumentListener ustensils_listener = new DocumentListener(){

        @Override
        public void changedUpdate(DocumentEvent arg0) {
            this.saveChange();
        }

        @Override
        public void insertUpdate(DocumentEvent arg0) {
            this.saveChange();
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
            this.saveChange();
        }

        private void saveChange() {
            int i = 0;
            while (i < TabbedListener.this.r.getUtensils().size()) {
                TabbedListener.this.r.getUtensils().set(i, ((JTextField)TabbedListener.this.ustensils_textfields.get(i)).getText());
                ++i;
            }
        }
    };
    private JPanel actions_panel;
    private ArrayList<JTextField> actions_textfields;
    private ArrayList<JButton> actions_remove_buttons;
    private ActionListener actions_add_listener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JPanel tmp_panel = new JPanel();
            String str = I18n.tr("NewAction");
            TabbedListener.this.r.getActions().add(str);
            JTextField txt = new JTextField();
            txt.setText(str);
            txt.setColumns(35);
            txt.setMaximumSize(new Dimension(Integer.MAX_VALUE, (int)txt.getPreferredSize().getHeight()));
            txt.getDocument().addDocumentListener(TabbedListener.this.actions_listener);
            tmp_panel.add(txt);
            JButton remove_button = new JButton(I18n.tr("Remove"));
            remove_button.setActionCommand(Integer.valueOf(TabbedListener.this.r.getActions().size() - 1).toString());
            remove_button.addActionListener(TabbedListener.this.actions_remove_listener);
            TabbedListener.this.actions_remove_buttons.add(remove_button);
            tmp_panel.add(remove_button);
            TabbedListener.this.actions_textfields.add(txt);
            TabbedListener.this.actions_panel.add((Component)tmp_panel, TabbedListener.this.r.getActions().size());
            TabbedListener.this.actions_panel.revalidate();
            TabbedListener.this.actions_panel.repaint();
        }
    };
    private ActionListener actions_remove_listener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            int index = Integer.parseInt(e.getActionCommand());
            TabbedListener.this.actions_textfields.remove(index);
            TabbedListener.this.actions_remove_buttons.remove(index);
            TabbedListener.this.r.getActions().remove(index);
            TabbedListener.this.actions_panel.remove(index + 1);
            TabbedListener.this.actions_panel.revalidate();
            TabbedListener.this.actions_panel.repaint();
            int i = 0;
            while (i < TabbedListener.this.r.getActions().size()) {
                ((JButton)TabbedListener.this.actions_remove_buttons.get(i)).setActionCommand(Integer.valueOf(i).toString());
                ++i;
            }
        }
    };
    private DocumentListener actions_listener = new DocumentListener(){

        @Override
        public void changedUpdate(DocumentEvent arg0) {
            this.saveChange();
        }

        @Override
        public void insertUpdate(DocumentEvent arg0) {
            this.saveChange();
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
            this.saveChange();
        }

        private void saveChange() {
            int i = 0;
            while (i < TabbedListener.this.r.getActions().size()) {
                TabbedListener.this.r.getActions().set(i, ((JTextField)TabbedListener.this.actions_textfields.get(i)).getText());
                ++i;
            }
        }
    };

    public TabbedListener(MainWindow mw) {
        this.main_window = mw;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int list_index = this.main_window.list.getSelectedIndex();
        if (this.main_window.tabbed_pane.getSelectedIndex() == 1 && list_index >= 0) {
            JButton remove_button;
            this.r = this.main_window.rl.getRecipes().get(list_index);
            this.edit_panel = new JPanel();
            this.edit_panel.setLayout(new BoxLayout(this.edit_panel, 3));
            this.main_window.edit_scrollPane.setViewportView(this.edit_panel);
            JPanel name_panel = new JPanel();
            name_panel.add(new JLabel(I18n.tr("Name")));
            this.name_textfield = new JTextField();
            this.name_textfield.setColumns(30);
            this.name_textfield.setText(this.r.getName());
            this.name_textfield.getDocument().addDocumentListener(this.name_listener);
            name_panel.add(this.name_textfield);
            this.edit_panel.add(name_panel);
            JPanel time_panel = new JPanel();
            time_panel.add(new JLabel(I18n.tr("PreparationTime")));
            this.time_spinner = new JSpinner(new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1));
            this.time_spinner.setValue(this.r.getTime());
            ((JSpinner.DefaultEditor)this.time_spinner.getEditor()).getTextField().setColumns(5);
            this.time_spinner.addChangeListener(this.time_listener);
            time_panel.add(this.time_spinner);
            this.edit_panel.add(time_panel);
            JPanel difficulty_panel = new JPanel();
            difficulty_panel.add(new JLabel(I18n.tr("Difficulty")));
            this.difficulty_combobox = new JComboBox<Difficulty>(Difficulty.values());
            this.difficulty_combobox.setSelectedItem(this.r.getDifficulty());
            this.difficulty_combobox.addActionListener(this.difficulty_listener);
            difficulty_panel.add(this.difficulty_combobox);
            this.edit_panel.add(difficulty_panel);
            JPanel grade_panel = new JPanel();
            grade_panel.add(new JLabel(I18n.tr("Grade")));
            this.grade_spinner = new JSpinner(new SpinnerNumberModel(0, 0, 10, 1));
            this.grade_spinner.setValue(this.r.getGrade());
            ((JSpinner.DefaultEditor)this.grade_spinner.getEditor()).getTextField().setColumns(5);
            this.grade_spinner.addChangeListener(this.grade_listener);
            grade_panel.add(this.grade_spinner);
            this.edit_panel.add(grade_panel);
            JPanel baking_panel = new JPanel();
            baking_panel.add(new JLabel(I18n.tr("Baking")));
            this.baking_combobox = new JComboBox<Baking>(Baking.values());
            this.baking_combobox.setSelectedItem(this.r.getBaking());
            this.baking_combobox.addActionListener(this.baking_listener);
            baking_panel.add(this.baking_combobox);
            this.edit_panel.add(baking_panel);
            JPanel nb_person_panel = new JPanel();
            nb_person_panel.add(new JLabel(I18n.tr("NbPerson")));
            this.nb_person_spinner = new JSpinner(new SpinnerNumberModel(0, 0, 50, 1));
            this.nb_person_spinner.setValue(this.r.getNb_person());
            ((JSpinner.DefaultEditor)this.nb_person_spinner.getEditor()).getTextField().setColumns(5);
            this.nb_person_spinner.addChangeListener(this.nb_person_listener);
            nb_person_panel.add(this.nb_person_spinner);
            this.edit_panel.add(nb_person_panel);
            this.ingredients_panel = new JPanel();
            this.ingredients_panel.setLayout(new BoxLayout(this.ingredients_panel, 3));
            JLabel ingredients_label = new JLabel(I18n.tr("Ingredients"));
            ingredients_label.setAlignmentX(0.5f);
            this.ingredients_panel.add(ingredients_label);
            this.ingredient_name_textfields = new ArrayList();
            this.ingredient_note_textfields = new ArrayList();
            this.ingredient_spinner = new ArrayList();
            this.ingredient_combobox = new ArrayList();
            this.ingredients_remove_buttons = new ArrayList();
            int i = 0;
            while (i < this.r.getIngredients().size()) {
                Ingredient ing = this.r.getIngredients().get(i);
                JPanel tmp_panel = new JPanel();
                JSpinner spin = new JSpinner(new SpinnerNumberModel(0.0, 0.0, Double.MAX_VALUE, 0.1));
                spin.setValue(ing.getQuantity());
                ((JSpinner.DefaultEditor)spin.getEditor()).getTextField().setColumns(4);
                spin.addChangeListener(this.ingredients_spinner_listener);
                this.ingredient_spinner.add(spin);
                tmp_panel.add(spin);
                JComboBox<Unit> combo = new JComboBox<Unit>(Unit.values());
                combo.setSelectedItem(ing.getUnit());
                combo.addActionListener(this.ingredients_combobox_listener);
                this.ingredient_combobox.add(combo);
                tmp_panel.add(combo);
                JTextField txt = new JTextField();
                txt.setColumns(12);
                txt.setText(ing.getName());
                txt.setMaximumSize(txt.getPreferredSize());
                txt.getDocument().addDocumentListener(this.ingredients_name_listener);
                this.ingredient_name_textfields.add(txt);
                tmp_panel.add(txt);
                JTextField txt2 = new JTextField();
                txt2.setColumns(12);
                txt2.setText(ing.getComment());
                txt2.setMaximumSize(txt2.getPreferredSize());
                txt2.getDocument().addDocumentListener(this.ingredients_note_listener);
                this.ingredient_note_textfields.add(txt2);
                tmp_panel.add(txt2);
                remove_button = new JButton(I18n.tr("Remove"));
                remove_button.setActionCommand(Integer.valueOf(i).toString());
                remove_button.addActionListener(this.ingredient_remove_listener);
                this.ingredients_remove_buttons.add(remove_button);
                tmp_panel.add(remove_button);
                this.ingredients_panel.add(tmp_panel);
                ++i;
            }
            JButton add_ingredients = new JButton(I18n.tr("Add"));
            add_ingredients.setAlignmentX(0.5f);
            add_ingredients.addActionListener(this.ingredient_add_listener);
            this.ingredients_panel.add(add_ingredients);
            this.edit_panel.add(this.ingredients_panel);
            this.ustensils_panel = new JPanel();
            this.ustensils_panel.setLayout(new BoxLayout(this.ustensils_panel, 3));
            JLabel ustensil_label = new JLabel(I18n.tr("Ustensils"));
            ustensil_label.setAlignmentX(0.5f);
            this.ustensils_panel.add(ustensil_label);
            this.ustensils_textfields = new ArrayList();
            this.ustensils_remove_buttons = new ArrayList();
            int i2 = 0;
            while (i2 < this.r.getUtensils().size()) {
                JPanel tmp_panel = new JPanel();
                JTextField txt = new JTextField();
                txt.setColumns(35);
                txt.setText(this.r.getUtensils().get(i2));
                txt.setMaximumSize(txt.getPreferredSize());
                txt.getDocument().addDocumentListener(this.ustensils_listener);
                this.ustensils_textfields.add(txt);
                tmp_panel.add(txt);
                JButton remove_button2 = new JButton(I18n.tr("Remove"));
                remove_button2.setActionCommand(Integer.valueOf(i2).toString());
                remove_button2.addActionListener(this.ustensils_remove_listener);
                this.ustensils_remove_buttons.add(remove_button2);
                tmp_panel.add(remove_button2);
                this.ustensils_panel.add(tmp_panel);
                ++i2;
            }
            JButton add_ustensil = new JButton(I18n.tr("Add"));
            add_ustensil.setAlignmentX(0.5f);
            add_ustensil.addActionListener(this.ustensils_add_listener);
            this.ustensils_panel.add(add_ustensil);
            this.edit_panel.add(this.ustensils_panel);
            this.actions_panel = new JPanel();
            this.actions_panel.setLayout(new BoxLayout(this.actions_panel, 3));
            JLabel actions_label = new JLabel(I18n.tr("Actions"));
            actions_label.setAlignmentX(0.5f);
            this.actions_panel.add(actions_label);
            this.actions_textfields = new ArrayList();
            this.actions_remove_buttons = new ArrayList();
            int i3 = 0;
            while (i3 < this.r.getActions().size()) {
                JPanel tmp_panel = new JPanel();
                JTextField txt = new JTextField();
                txt.setText(this.r.getActions().get(i3));
                txt.setColumns(35);
                txt.setMaximumSize(new Dimension(Integer.MAX_VALUE, (int)txt.getPreferredSize().getHeight()));
                txt.getDocument().addDocumentListener(this.actions_listener);
                this.actions_textfields.add(txt);
                tmp_panel.add(txt);
                remove_button = new JButton(I18n.tr("Remove"));
                remove_button.setActionCommand(Integer.valueOf(i3).toString());
                remove_button.addActionListener(this.actions_remove_listener);
                this.actions_remove_buttons.add(remove_button);
                tmp_panel.add(remove_button);
                this.actions_panel.add(tmp_panel);
                ++i3;
            }
            JButton add_actions = new JButton(I18n.tr("Add"));
            add_actions.setAlignmentX(0.5f);
            add_actions.addActionListener(this.actions_add_listener);
            this.actions_panel.add(add_actions);
            this.edit_panel.add(this.actions_panel);
        } else {
            if (list_index >= 0) {
                this.main_window.txtpnRecipeview.setText(this.main_window.rl.getRecipes().get(list_index).toHTMLString());
            } else if (this.main_window.txtpnRecipeview != null) {
                this.main_window.txtpnRecipeview.setText(I18n.tr("No recipe selected"));
            }
            if (this.edit_panel != null) {
                this.edit_panel.removeAll();
            }
        }
    }
}

