/*
 * Decompiled with CFR 0.152.
 */
package gui;

import core.Recipe;
import core.RecipeList;
import gui.GuiRecipeList;
import gui.I18n;
import gui.MenuListener;
import gui.TabbedListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MainWindow
extends JFrame {
    private static final long serialVersionUID = -1810393566512302281L;
    private JPanel contentPane;
    JList<String> list;
    JTextPane txtpnRecipeview;
    JMenuItem mntmSave;
    JMenuItem mntmSaveAs;
    JTabbedPane tabbed_pane;
    JScrollPane edit_scrollPane;
    JButton delete_button;
    private MenuListener menu_listener;
    GuiRecipeList rl;
    RecipeList old_rl;
    private ListSelectionListener list_listener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent arg0) {
            int index;
            if (!arg0.getValueIsAdjusting() && (index = MainWindow.this.list.getSelectedIndex()) >= 0) {
                MainWindow.this.delete_button.setEnabled(true);
                if (index < MainWindow.this.rl.getRecipes().size()) {
                    MainWindow.this.tabbed_pane.setSelectedIndex(0);
                    MainWindow.this.txtpnRecipeview.setText(MainWindow.this.rl.getRecipes().get(index).toHTMLString());
                } else {
                    MainWindow.this.rl.add(new Recipe(I18n.tr("NewRecipe")));
                    if (MainWindow.this.tabbed_pane.getSelectedIndex() == 1) {
                        MainWindow.this.tabbed_pane.setSelectedIndex(0);
                    } else {
                        MainWindow.this.txtpnRecipeview.setText(MainWindow.this.rl.getRecipes().get(index).toHTMLString());
                    }
                }
            }
        }
    };
    private ActionListener delete_recipe_listener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            int index = MainWindow.this.list.getSelectedIndex();
            Recipe r = MainWindow.this.rl.getRecipes().get(index);
            MainWindow.this.rl.remove(r);
            MainWindow.this.tabbed_pane.setSelectedIndex(0);
            MainWindow.this.delete_button.setEnabled(false);
            MainWindow.this.txtpnRecipeview.setText(I18n.tr("No recipe selected"));
            MainWindow.this.list.clearSelection();
        }
    };
    private WindowAdapter close_window_listener = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent e) {
            if (!MainWindow.this.old_rl.sameRecipes(MainWindow.this.rl)) {
                JOptionPane opt = new JOptionPane(I18n.tr("Save?"), 3, 0);
                JDialog jd = opt.createDialog(MainWindow.this, I18n.tr("SaveCurrentFile"));
                jd.setVisible(true);
                if ((Integer)opt.getValue() == 0) {
                    if (MainWindow.this.rl.getName() == null) {
                        JFileChooser save_chooser = new JFileChooser();
                        int returnVal2 = save_chooser.showDialog(MainWindow.this, I18n.tr("Save"));
                        if (returnVal2 == 0) {
                            try {
                                MainWindow.this.rl.save(save_chooser.getSelectedFile().getAbsolutePath());
                            }
                            catch (IOException ex) {
                                ex.printStackTrace();
                                JOptionPane opt_error = new JOptionPane(I18n.tr("FileNotValid"), 0, -1);
                                JDialog jd_error = opt_error.createDialog(MainWindow.this, I18n.tr("Error"));
                                jd_error.setVisible(true);
                            }
                        }
                    } else {
                        try {
                            MainWindow.this.rl.save();
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                            JOptionPane opt_error = new JOptionPane(I18n.tr("FileNotValid"), 0, -1);
                            JDialog jd_error = opt_error.createDialog(MainWindow.this, I18n.tr("Error"));
                            jd_error.setVisible(true);
                        }
                    }
                }
            }
        }
    };
    private ChangeListener tabbed_listener;

    public MainWindow() {
        super("RecettesCuisine");
        this.setDefaultCloseOperation(3);
        this.setMinimumSize(new Dimension(700, 500));
        this.addWindowListener(this.close_window_listener);
        this.rl = new GuiRecipeList();
        this.old_rl = (RecipeList)this.rl.clone();
        this.menu_listener = new MenuListener(this);
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu mnFile = new JMenu(I18n.tr("File"));
        menuBar.add(mnFile);
        JMenuItem mntmNew = new JMenuItem(I18n.tr("New"));
        mntmNew.setActionCommand("new");
        mntmNew.addActionListener(this.menu_listener);
        mnFile.add(mntmNew);
        JMenuItem mntmOpen = new JMenuItem(I18n.tr("Open"));
        mntmOpen.setActionCommand("open");
        mntmOpen.addActionListener(this.menu_listener);
        mnFile.add(mntmOpen);
        this.mntmSave = new JMenuItem(I18n.tr("Save"));
        this.mntmSave.setActionCommand("save");
        this.mntmSave.addActionListener(this.menu_listener);
        this.mntmSave.setEnabled(false);
        mnFile.add(this.mntmSave);
        this.mntmSaveAs = new JMenuItem(I18n.tr("Save As"));
        this.mntmSaveAs.setActionCommand("save_as");
        this.mntmSaveAs.addActionListener(this.menu_listener);
        mnFile.add(this.mntmSaveAs);
        JMenuItem mntmClose = new JMenuItem(I18n.tr("Close"));
        mntmClose.setActionCommand("close");
        mntmClose.addActionListener(this.menu_listener);
        JMenuItem mntmExport = new JMenuItem(I18n.tr("Export"));
        mntmExport.setActionCommand("export");
        mntmExport.addActionListener(this.menu_listener);
        mnFile.add(mntmExport);
        mnFile.add(mntmClose);
        JMenu mnAbout = new JMenu(I18n.tr("About"));
        menuBar.add(mnAbout);
        JMenuItem mntmAbout = new JMenuItem(I18n.tr("About"));
        mntmAbout.setActionCommand("about");
        mntmAbout.addActionListener(this.menu_listener);
        mnAbout.add(mntmAbout);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(new BorderLayout(0, 0));
        JPanel list_panel = new JPanel();
        this.contentPane.add((Component)list_panel, "West");
        list_panel.setLayout(new BoxLayout(list_panel, 1));
        JLabel lblHereIsYour = new JLabel(I18n.tr("Here is your recipes"));
        lblHereIsYour.setAlignmentX(0.5f);
        list_panel.add(lblHereIsYour);
        lblHereIsYour.setHorizontalAlignment(2);
        JScrollPane scrollPane = new JScrollPane();
        list_panel.add(scrollPane);
        this.list = new JList<String>(this.rl);
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(this.list_listener);
        scrollPane.setViewportView(this.list);
        this.delete_button = new JButton(I18n.tr("Delete"));
        this.delete_button.setAlignmentX(0.5f);
        this.delete_button.setEnabled(false);
        this.delete_button.addActionListener(this.delete_recipe_listener);
        list_panel.add(this.delete_button);
        this.tabbed_pane = new JTabbedPane(1);
        this.tabbed_listener = new TabbedListener(this);
        this.tabbed_pane.addChangeListener(this.tabbed_listener);
        this.contentPane.add((Component)this.tabbed_pane, "Center");
        JScrollPane view_scrollPane = new JScrollPane();
        this.tabbed_pane.addTab(I18n.tr("View"), null, view_scrollPane, null);
        this.txtpnRecipeview = new JTextPane();
        this.txtpnRecipeview.setEditable(false);
        this.txtpnRecipeview.setContentType("text/html");
        this.txtpnRecipeview.setText(I18n.tr("No recipe selected"));
        view_scrollPane.setViewportView(this.txtpnRecipeview);
        this.edit_scrollPane = new JScrollPane();
        this.tabbed_pane.addTab(I18n.tr("Edit"), null, this.edit_scrollPane, null);
        this.pack();
        this.setSize(900, 600);
    }

    public RecipeList getRl() {
        return this.rl;
    }

    public void setRl(GuiRecipeList rl) {
        this.rl = rl;
    }
}

