/*
 * Decompiled with CFR 0.152.
 */
package gui;

import core.Recipe;
import core.RecipeList;
import gui.I18n;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class GuiRecipeList
extends RecipeList
implements ListModel<String> {
    protected ArrayList<ListDataListener> listener_list = new ArrayList();
    protected ArrayList<String> recipes_names = new ArrayList();
    private static final long serialVersionUID = 3632348981899074666L;

    public GuiRecipeList() {
        this.recipes_names.add(I18n.tr("New recipe"));
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        this.listener_list.add(l);
    }

    @Override
    public String getElementAt(int index) {
        return this.recipes_names.get(index);
    }

    @Override
    public int getSize() {
        return this.recipes_names.size();
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this.listener_list.remove(l);
    }

    @Override
    public void clear() {
        super.clear();
        this.recipes_names.clear();
        this.recipes_names.add(I18n.tr("New recipe"));
        this.notifyChangment();
    }

    @Override
    public void open(String n) throws IOException {
        super.open(n);
        this.recipes_names.clear();
        for (Recipe r : this.recipes) {
            this.recipes_names.add(r.getName());
        }
        this.recipes_names.add(I18n.tr("New recipe"));
        this.notifyChangment();
    }

    public void add(Recipe r) {
        this.recipes.add(r);
        this.recipes_names.remove(I18n.tr("New recipe"));
        this.recipes_names.add(r.getName());
        this.recipes_names.add(I18n.tr("New recipe"));
        this.notifyChangment();
    }

    public void remove(Recipe r) {
        this.recipes.remove(r);
        this.recipes_names.remove(r.getName());
        this.notifyChangment();
    }

    public void notifyChangment() {
        int i = 0;
        for (Recipe r : this.recipes) {
            if (r.getName() != this.recipes_names.get(i)) {
                this.recipes_names.remove(i);
                this.recipes_names.add(i, r.getName());
            }
            ++i;
        }
        for (ListDataListener l : this.listener_list) {
            l.contentsChanged(new ListDataEvent(this, 0, 0, 0));
        }
    }
}

