/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.Recipe;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class RecipeList
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -4579076863400484624L;
    protected List<Recipe> recipes = new ArrayList<Recipe>();
    protected String name;

    public Object clone() {
        RecipeList rl = new RecipeList();
        rl.name = this.name;
        for (Recipe r : this.recipes) {
            rl.recipes.add((Recipe)r.clone());
        }
        return rl;
    }

    public void save() throws IOException {
        FileOutputStream f = new FileOutputStream(this.name);
        ObjectOutputStream out = new ObjectOutputStream(f);
        out.writeObject(this.recipes);
        out.close();
    }

    public void save(String n) throws IOException {
        this.name = n;
        this.save();
    }

    protected void open() throws IOException {
        this.recipes.clear();
        FileInputStream f = new FileInputStream(this.name);
        ObjectInputStream in = new ObjectInputStream(f);
        try {
            this.recipes = (List)in.readObject();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        in.close();
    }

    public void open(String n) throws IOException {
        this.name = n;
        this.open();
    }

    public void exportToHtml(String s) throws IOException {
        FileWriter fw = new FileWriter(s);
        PrintWriter pw = new PrintWriter(fw);
        for (Recipe r : this.recipes) {
            pw.println(r.toHTMLString());
        }
        pw.close();
    }

    public void exportToXml(String s) throws IOException {
        Document doc = new Document();
        Element root = new Element("recipe_list");
        doc.setRootElement(root);
        root.addContent(new Element("version").setText("1.0"));
        for (Recipe r : this.recipes) {
            root.addContent(r.toXmlElement());
        }
        XMLOutputter xmlOutput = new XMLOutputter();
        xmlOutput.setFormat(Format.getPrettyFormat());
        xmlOutput.output(doc, (Writer)new FileWriter(s));
    }

    public void exportToPdf(String s) throws IOException {
        PDDocument doc = new PDDocument();
        for (Recipe r : this.recipes) {
            doc.addPage(r.toPdfPage(doc));
        }
        doc.save(s);
        doc.close();
    }

    public void clear() {
        this.recipes.clear();
        this.name = null;
    }

    public List<Recipe> getRecipes() {
        return this.recipes;
    }

    public void setRecipes(List<Recipe> recipes) {
        this.recipes = recipes;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.recipes == null ? 0 : this.recipes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RecipeList other = (RecipeList)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.recipes == null ? other.recipes != null : !this.recipes.equals(other.recipes));
    }

    public boolean sameRecipes(RecipeList rl) {
        if (this.recipes.size() != rl.recipes.size()) {
            return false;
        }
        int i = 0;
        while (i < this.recipes.size()) {
            if (!this.recipes.get(i).equals(rl.recipes.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        StringBuffer sf = new StringBuffer();
        sf.append(String.valueOf(this.name) + "\n\n");
        for (Recipe r : this.recipes) {
            sf.append(String.valueOf(r.toString()) + "\n\n");
        }
        return sf.toString();
    }
}

