/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.Baking;
import core.Difficulty;
import core.I18n;
import core.Ingredient;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.jdom2.Attribute;
import org.jdom2.Element;

public class Recipe
implements Serializable,
Cloneable {
    private String name;
    private int time = 0;
    private List<Ingredient> ingredients;
    private Baking baking = Baking.None;
    private List<String> actions;
    private List<String> utensils;
    private Difficulty difficulty;
    private int grade = 0;
    private int nb_person = 0;
    private static final long serialVersionUID = 8267746199251258267L;

    public Recipe(String n) {
        this.name = n;
        this.ingredients = new ArrayList<Ingredient>();
        this.actions = new ArrayList<String>();
        this.utensils = new ArrayList<String>();
    }

    public Object clone() {
        Recipe r = new Recipe(this.name);
        r.time = this.time;
        r.baking = this.baking;
        r.grade = this.grade;
        r.difficulty = this.difficulty;
        r.nb_person = this.nb_person;
        for (Ingredient i : this.ingredients) {
            r.ingredients.add((Ingredient)i.clone());
        }
        for (String s : this.actions) {
            r.actions.add(s);
        }
        for (String s : this.utensils) {
            r.utensils.add(s);
        }
        return r;
    }

    public Element toXmlElement() {
        Element re = new Element("recipe");
        re.addContent(new Element("name").setText(this.name));
        re.addContent(new Element("time").setText(new Integer(this.time).toString()));
        re.addContent(new Element("difficulty").setText(new Integer(this.difficulty.toInt()).toString()));
        re.addContent(new Element("grade").setText(new Integer(this.grade).toString()));
        re.addContent(new Element("nb_person").setText(new Integer(this.nb_person).toString()));
        re.addContent(new Element("baking").setText(new Integer(this.baking.toInt()).toString()));
        Element ingredients_list = new Element("ingredients_list");
        re.addContent(ingredients_list);
        for (Ingredient i : this.ingredients) {
            ingredients_list.addContent(i.toXmlElement());
        }
        Element ustensil_list = new Element("ustensils_list");
        re.addContent(ustensil_list);
        for (String s : this.utensils) {
            Element ustensil = new Element("ustensil");
            ustensil.setText(s);
            ustensil_list.addContent(ustensil);
        }
        Element actions_list = new Element("actions_list");
        re.addContent(actions_list);
        Integer i = 0;
        for (String s : this.actions) {
            Element action = new Element("action");
            action.setAttribute(new Attribute("order", i.toString()));
            action.setText(s);
            actions_list.addContent(action);
            i = i + 1;
        }
        return re;
    }

    public PDPage toPdfPage(PDDocument doc) throws IOException {
        PDPage page = new PDPage(PDRectangle.A4);
        float width = PDRectangle.A4.getWidth();
        float height = PDRectangle.A4.getHeight();
        PDType1Font font_title = PDType1Font.TIMES_BOLD;
        int title_font_size = 28;
        int font_size = 14;
        InputStream input = this.getClass().getClassLoader().getResourceAsStream("org/apache/pdfbox/resources/ttf/LiberationSans-Regular.ttf");
        PDType0Font font = PDType0Font.load(doc, input);
        float titleWidth = font_title.getStringWidth(this.name) / 1000.0f * (float)title_font_size;
        float titleHeight = font_title.getFontDescriptor().getFontBoundingBox().getHeight() / 1000.0f * (float)title_font_size;
        PDPageContentStream contents = new PDPageContentStream(doc, page);
        contents.beginText();
        contents.setFont(font_title, title_font_size);
        contents.newLineAtOffset((width - titleWidth) / 2.0f, height - titleHeight - 40.0f);
        contents.showText(this.name);
        contents.endText();
        contents.beginText();
        contents.setLeading(15.0);
        contents.setFont(font, font_size);
        contents.newLineAtOffset(40.0f, height - 120.0f);
        contents.showText(String.valueOf(I18n.tr("PreparationTime")) + this.time + " " + I18n.tr("Minutes"));
        contents.newLine();
        contents.showText(String.valueOf(I18n.tr("Difficulty")) + this.difficulty);
        contents.newLine();
        contents.showText(String.valueOf(I18n.tr("Baking")) + this.baking);
        contents.newLine();
        contents.showText(String.valueOf(I18n.tr("Grade")) + this.grade);
        contents.newLine();
        contents.newLine();
        contents.showText(String.valueOf(I18n.tr("Ingredients1")) + this.nb_person + I18n.tr("Ingredients2"));
        for (Ingredient ing : this.ingredients) {
            contents.newLine();
            contents.showText("    \u2022 " + ing.toString());
        }
        if (!this.utensils.isEmpty()) {
            contents.newLine();
            contents.newLine();
            contents.showText(I18n.tr("Ustensils"));
            for (String s : this.utensils) {
                contents.newLine();
                contents.showText("    \u2022 " + s);
            }
        }
        contents.newLine();
        contents.newLine();
        contents.showText(I18n.tr("Preparation"));
        for (String a : this.actions) {
            boolean first_line = true;
            int size = a.length();
            StringBuffer sb = new StringBuffer(a);
            contents.newLine();
            while (sb.length() > 0) {
                float text_width = font.getStringWidth("      " + sb.substring(1, size)) / 1000.0f * (float)font_size;
                if (text_width < width - 80.0f && (sb.charAt(size - 1) == ' ' || size == sb.length())) {
                    if (first_line) {
                        first_line = false;
                        contents.showText("    \u2022 " + sb.substring(0, size));
                    } else {
                        contents.newLine();
                        contents.showText("      " + sb.substring(0, size));
                    }
                    sb.delete(0, size);
                    size = sb.length();
                    continue;
                }
                --size;
            }
        }
        contents.endText();
        contents.close();
        return page;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public List<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public void setIngredients(List<Ingredient> ingredients) {
        this.ingredients = ingredients;
    }

    public Baking getBaking() {
        return this.baking;
    }

    public void setBaking(Baking baking) {
        this.baking = baking;
    }

    public List<String> getActions() {
        return this.actions;
    }

    public void setActions(List<String> actions) {
        this.actions = actions;
    }

    public List<String> getUtensils() {
        return this.utensils;
    }

    public void setUtensils(List<String> utensils) {
        this.utensils = utensils;
    }

    public Difficulty getDifficulty() {
        return this.difficulty;
    }

    public void setDifficulty(Difficulty difficulty) {
        this.difficulty = difficulty;
    }

    public int getGrade() {
        return this.grade;
    }

    public void setGrade(int grade) {
        this.grade = grade;
    }

    public int getNb_person() {
        return this.nb_person;
    }

    public void setNb_person(int nb_person) {
        this.nb_person = nb_person;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.actions == null ? 0 : this.actions.hashCode());
        result = 31 * result + (this.baking == null ? 0 : this.baking.hashCode());
        result = 31 * result + (this.difficulty == null ? 0 : this.difficulty.hashCode());
        result = 31 * result + this.grade;
        result = 31 * result + (this.ingredients == null ? 0 : this.ingredients.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.time;
        result = 31 * result + this.nb_person;
        result = 31 * result + (this.utensils == null ? 0 : this.utensils.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Recipe other = (Recipe)obj;
        if (this.actions == null ? other.actions != null : !this.actions.equals(other.actions)) {
            return false;
        }
        if (this.baking != other.baking) {
            return false;
        }
        if (this.difficulty != other.difficulty) {
            return false;
        }
        if (this.grade != other.grade) {
            return false;
        }
        if (this.ingredients == null ? other.ingredients != null : !this.ingredients.equals(other.ingredients)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.time != other.time) {
            return false;
        }
        if (this.nb_person != other.nb_person) {
            return false;
        }
        return !(this.utensils == null ? other.utensils != null : !this.utensils.equals(other.utensils));
    }

    public String toString() {
        StringBuffer sf = new StringBuffer();
        sf.append(String.valueOf(this.name) + "\n");
        sf.append(String.valueOf(I18n.tr("PreparationTime")) + this.time + " " + I18n.tr("Minutes") + "\n");
        sf.append(String.valueOf(I18n.tr("Difficulty")) + this.difficulty + "\n");
        sf.append(String.valueOf(I18n.tr("Grade")) + this.grade + "\n");
        sf.append(String.valueOf(I18n.tr("Baking")) + this.baking + "\n");
        sf.append(String.valueOf(I18n.tr("Ingredients1")) + this.nb_person + I18n.tr("Ingredients2") + "\n");
        for (Ingredient i : this.ingredients) {
            sf.append(" - " + i.toString() + "\n");
        }
        if (!this.utensils.isEmpty()) {
            sf.append(String.valueOf(I18n.tr("Ustensils")) + "\n");
            for (String s : this.utensils) {
                sf.append(" - " + s + "\n");
            }
        }
        sf.append(String.valueOf(I18n.tr("Preparation")) + "\n");
        for (String s : this.actions) {
            sf.append(" - " + s + "\n");
        }
        return sf.toString();
    }

    public String toHTMLString() {
        StringBuffer sf = new StringBuffer();
        sf.append("<html>");
        sf.append("<b><font size=\"6\"><center>" + this.name + "</center></font></b>");
        sf.append("<p>" + I18n.tr("PreparationTime") + this.time + " " + I18n.tr("Minutes") + "<br>");
        sf.append(String.valueOf(I18n.tr("Difficulty")) + this.difficulty + "<br>");
        sf.append(String.valueOf(I18n.tr("Grade")) + this.grade + "<br>");
        sf.append(String.valueOf(I18n.tr("Baking")) + this.baking + "</p>");
        sf.append("<p>" + I18n.tr("Ingredients1") + this.nb_person + I18n.tr("Ingredients2") + "<br><ul>");
        for (Ingredient i : this.ingredients) {
            sf.append("<li>" + i.toString() + "</li>");
        }
        sf.append("</ul></p>");
        if (!this.utensils.isEmpty()) {
            sf.append("<p>" + I18n.tr("Ustensils") + "<br><ul>");
            for (String s : this.utensils) {
                sf.append("<li>" + s + "</li>");
            }
            sf.append("</ul></p>");
        }
        sf.append("<p>" + I18n.tr("Preparation") + "<br><ul>");
        for (String s : this.actions) {
            sf.append("<li>" + s + "</li>");
        }
        sf.append("</ul></p>");
        sf.append("</html>");
        return sf.toString();
    }
}

