/*
* main.cpp
*
* Copyright 2016 Remi BERTHO <remi.bertho@openmailbox.org>
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 3 of the License, or
* (at your option) any later version.
*
* This program  is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
* MA 02110-1301, USA.
*
*
*/

#include <iostream>
#include <mutex>
#include "AsynchronousExecution.h"
#include "mutex_lockable.h"
#include "spinlock_lockable.h"

class toto : public AsynchronousExecution::SpinlockLockable, public std::enable_shared_from_this<toto>
{
private:
	int a;

public:
	toto(int aa) : a(aa)
	{

	}

	int tata(int b)
	{
		return a = a+b;
	}

	void tataAsync(	int								b,
					std::function<void(int&)>			return_function = nullptr,
					std::function<void(std::exception&)>	exception_function = nullptr)
	{
		execAsynchronously<int,std::exception,toto>(	return_function,
												exception_function,
												shared_from_this(),
												&toto::tata,
												b);
	}

	int titi(int b)
	{
		std::this_thread::sleep_for(std::chrono::milliseconds(150));
		return a = a-b;
	}

	void tutu()
	{
		std::cout << a << " " <<  "OK !!!" << std::endl;
	}

	void tutuCopyAsync()
	{
		std::shared_ptr<toto> tmp = std::make_shared<toto>(*this);
		tmp->a = 9;
		tmp->execVoidAsynchronously<std::exception,toto>(	nullptr,
													nullptr,
													tmp,
													&toto::tutu);
	}
};

void blop(int a)
{
	std::cout << a << std::endl;
}

int launchException()
{
	throw std::runtime_error("Error");
	return 5;
}


int main(int argc, char **argv)
{
	std::shared_ptr<toto> t = std::make_shared<toto>(6);
	std::mutex mut;

	t->execAsynchronously<int,std::exception,toto>
			(	[](int& i)
				{
						std::cout << i << std::endl;
				},
				[](auto& ex)
				{
						std::cout << ex.what() << std::endl;
				},
				nullptr,
				&toto::titi,
				20
			);

	std::this_thread::sleep_for(std::chrono::milliseconds(50));

	t->tutuCopyAsync();

	t->tataAsync(	7,
				[](auto& i)
				{
						std::cout << i << std::endl;
				}
			);

	AsynchronousExecution::execVoidFunction(
			t->getVoidFunction<toto>(&toto::tutu)
		);

	std::cout << "blop" << std::endl;

	AsynchronousExecution::execFunction<int,std::runtime_error>(
			launchException,
			blop,
			[](auto& ex)
			{
					std::cout << ex.what() << std::endl;
			},
			std::bind(&std::mutex::lock,std::ref(mut)),
			std::bind(&std::mutex::unlock,std::ref(mut))
		);

	AsynchronousExecution::execFunction<int*>(
			[]()
			{
				std::this_thread::sleep_for(std::chrono::milliseconds(100));
				return  new int (3);
			},
			[](auto& i)
			{
					std::cout << *i << std::endl;
					delete i;
			}
		);

	AsynchronousExecution::execVoidFunction<>(
			std::bind(blop,78)
		);

	std::this_thread::sleep_for(std::chrono::milliseconds(200));

	return 0;
}
