/*!
 * \file    libcsuper.h
 * \brief   Inclusion of all header files of libcsuper
 * \author  Remi BERTHO
 * \date    25/08/14
 * \version 4.0.2
 */

/*
* libcsuper.h
*
* Copyright 2014-2015 Remi BERTHO <remi.bertho@openmailbox.org>
*
* This file is part of LibCsuper.
*
* LibCsuper is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 3 of the License, or
* (at your option) any later version.
*
* LibCsuper is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
* MA 02110-1301, USA.
*
*
*/

#ifndef LIBCSUPER_H_INCLUDED
#define LIBCSUPER_H_INCLUDED

/*!
 * \def NOT_LIBCSUPER
 * Define that we don't compile libcsuper
 */
#define NOT_LIBCSUPER

#include "csu_struct.h"
#include "share.h"
#include "csu_files.h"
#include "preferences_files.h"
#include "main_argument.h"
#include "game_config.h"
#include "file.h"
#include "filename.h"
#include "export.h"
#include "calculator.h"
#include "gnuplot.h"

#endif
